/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.TileBounds;
import net.sf.freecol.common.model.Direction;

final class MapViewerScaledUtils {
    private final GeneralPath fog = new GeneralPath();
    private Font fontNormal;
    private Font fontItalic;
    private Font fontProduction;
    private Font fontTiny;
    private final EnumMap<Direction, Point2D.Float> borderPoints = new EnumMap(Direction.class);
    private final EnumMap<Direction, Point2D.Float> controlPoints = new EnumMap(Direction.class);
    private Stroke borderStroke = new BasicStroke(4.0f);
    private Stroke gridStroke = new BasicStroke(1.0f);

    MapViewerScaledUtils() {
    }

    void updateScaledVariables(ImageLibrary lib) {
        TileBounds tileBounds = new TileBounds(lib.getTileSize(), lib.getScaleFactor());
        this.fog.reset();
        this.fog.moveTo(tileBounds.getHalfWidth(), 0.0f);
        this.fog.lineTo(tileBounds.getWidth(), tileBounds.getHalfHeight());
        this.fog.lineTo(tileBounds.getHalfWidth(), tileBounds.getHeight());
        this.fog.lineTo(0.0f, tileBounds.getHalfHeight());
        this.fog.closePath();
        this.fontNormal = lib.getScaledFont("normal-bold-smaller", null);
        this.fontItalic = lib.getScaledFont("normal-bold+italic-smaller", null);
        this.fontProduction = lib.getScaledFont("normal-bold-tiny", null);
        this.fontTiny = lib.getScaledFont("normal-plain-tiny", null);
        if (this.fontNormal == null) {
            Font font = this.fontNormal = lib.getScaleFactor() < 1.0f ? FontLibrary.getUnscaledFont("normal-bold-tiny", null) : FontLibrary.getUnscaledFont("normal-bold-max", null);
        }
        if (this.fontItalic == null) {
            this.fontItalic = this.fontNormal;
        }
        int dx = tileBounds.getWidth() / 16;
        int dy = tileBounds.getHeight() / 16;
        int ddx = dx + dx / 2;
        int ddy = dy + dy / 2;
        this.controlPoints.put(Direction.N, new Point2D.Float(tileBounds.getHalfWidth(), dy));
        this.controlPoints.put(Direction.E, new Point2D.Float(tileBounds.getWidth() - dx, tileBounds.getHalfHeight()));
        this.controlPoints.put(Direction.S, new Point2D.Float(tileBounds.getHalfWidth(), tileBounds.getHeight() - dy));
        this.controlPoints.put(Direction.W, new Point2D.Float(dx, tileBounds.getHalfHeight()));
        this.controlPoints.put(Direction.SE, new Point2D.Float(tileBounds.getHalfWidth(), tileBounds.getHeight()));
        this.controlPoints.put(Direction.NE, new Point2D.Float(tileBounds.getWidth(), tileBounds.getHalfHeight()));
        this.controlPoints.put(Direction.SW, new Point2D.Float(0.0f, tileBounds.getHalfHeight()));
        this.controlPoints.put(Direction.NW, new Point2D.Float(tileBounds.getHalfWidth(), 0.0f));
        this.borderPoints.put(Direction.NW, new Point2D.Float(dx + ddx, tileBounds.getHalfHeight() - ddy));
        this.borderPoints.put(Direction.N, new Point2D.Float(tileBounds.getHalfWidth() - ddx, dy + ddy));
        this.borderPoints.put(Direction.NE, new Point2D.Float(tileBounds.getHalfWidth() + ddx, dy + ddy));
        this.borderPoints.put(Direction.E, new Point2D.Float(tileBounds.getWidth() - dx - ddx, tileBounds.getHalfHeight() - ddy));
        this.borderPoints.put(Direction.SE, new Point2D.Float(tileBounds.getWidth() - dx - ddx, tileBounds.getHalfHeight() + ddy));
        this.borderPoints.put(Direction.S, new Point2D.Float(tileBounds.getHalfWidth() + ddx, tileBounds.getHeight() - dy - ddy));
        this.borderPoints.put(Direction.SW, new Point2D.Float(tileBounds.getHalfWidth() - ddx, tileBounds.getHeight() - dy - ddy));
        this.borderPoints.put(Direction.W, new Point2D.Float(dx + ddx, tileBounds.getHalfHeight() + ddy));
        this.borderStroke = new BasicStroke(dy);
        this.gridStroke = new BasicStroke(lib.getScaleFactor());
    }

    GeneralPath getFog() {
        return this.fog;
    }

    Stroke getGridStroke() {
        return this.gridStroke;
    }

    Stroke getBorderStroke() {
        return this.borderStroke;
    }

    EnumMap<Direction, Point2D.Float> getBorderPoints() {
        return this.borderPoints;
    }

    EnumMap<Direction, Point2D.Float> getControlPoints() {
        return this.controlPoints;
    }

    Font getFontNormal() {
        return this.fontNormal;
    }

    Font getFontProduction() {
        return this.fontProduction;
    }

    Font getFontItalic() {
        return this.fontItalic;
    }

    Font getFontTiny() {
        return this.fontTiny;
    }
}

