/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;

public class GoldTradeItem
extends TradeItem {
    public static final String TAG = "goldTradeItem";
    private int gold;
    private static final String GOLD_TAG = "gold";

    public GoldTradeItem(Game game, Player source, Player destination, int gold) {
        super(game, Messages.nameKey("model.tradeItem.gold"), source, destination);
        this.gold = gold;
    }

    public GoldTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.gold >= 0 && this.getSource().checkGold(this.gold);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.template(Messages.descriptionKey("model.tradeItem.gold")).addAmount("%amount%", this.gold);
    }

    @Override
    public int getGold() {
        return this.gold;
    }

    @Override
    public void setGold(int gold) {
        this.gold = gold;
    }

    @Override
    public int evaluateFor(Player player) {
        return !this.isValid() ? Integer.MIN_VALUE : (this.getSource() == player ? -this.getGold() : this.getGold());
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ColonyTradeItem o = this.copyInCast(other, ColonyTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.gold = o.getGold();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(GOLD_TAG, this.gold);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.gold = xr.getAttribute(GOLD_TAG, Integer.MIN_VALUE);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof GoldTradeItem) {
            return this.gold == ((GoldTradeItem)other).gold && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + this.gold;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.gold).append(']');
        return sb.toString();
    }
}

