/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel.desktopintegrationeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.JListUtils;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;

public class Panels {
    public static JPanel createGeneratedPanel(JList list, ActionListener findOrphans) {
        return Panels.createIconsOrGeneratedPanel(list, findOrphans, Translator.R("DIMgeneratedJnlps"), Panels.bold(Translator.R("DIMgeneratedJnlpsTooltip")));
    }

    public static JPanel createIconsPanel(JList list, ActionListener findOrphans) {
        return Panels.createIconsOrGeneratedPanel(list, findOrphans, Translator.R("DIMicons"), Panels.bold(Translator.R("DIMiconsTooltip")));
    }

    private static JPanel createIconsOrGeneratedPanel(JList list, ActionListener findOrphans, String title, String tooltip) {
        JPanel iconsPanel = new JPanel(new BorderLayout());
        JLabel l = new JLabel(title);
        l.setToolTipText(Panels.createToolTip(tooltip, list));
        iconsPanel.add((Component)l, "First");
        JScrollPane scrollIcons = new JScrollPane();
        scrollIcons.setViewportView(list);
        iconsPanel.add((Component)scrollIcons, "Center");
        JPanel iconsToolPanel = new JPanel(new BorderLayout());
        JButton findOrphansButton = new JButton(Translator.R("DIMorphans"));
        findOrphansButton.addActionListener(findOrphans);
        findOrphansButton.setToolTipText(Translator.R("DIMorphansTooltip"));
        iconsToolPanel.add((Component)findOrphansButton, "Center");
        iconsPanel.add((Component)iconsToolPanel, "Last");
        return iconsPanel;
    }

    public static JPanel createMenuPanel(JList list, ActionListener findIcons, ActionListener findGenerated) {
        return Panels.createDesktopOrMenuPanel(list, findIcons, findGenerated, Translator.R("DIMmenuItems"), Panels.bold(Translator.R("DIMmenuItemsTooltip")));
    }

    public static JPanel createDesktopPanel(JList list, ActionListener findIcons, ActionListener findGenerated) {
        StringBuilder sb = new StringBuilder();
        sb.append(Translator.R("DIMdesktopItemsTooltipL1")).append("<br>").append(Translator.R("DIMdesktopItemsTooltipL2")).append(":<ul><li>").append(Translator.R("DIMdesktopItemsTooltipL3")).append("</li><li>").append(Translator.R("DIMdesktopItemsTooltipL4")).append("</li><li>").append(Translator.R("DIMdesktopItemsTooltipL5")).append("</li></ul>").append(Panels.bold(Translator.R("DIMdesktopItemsTooltipL6")));
        return Panels.createDesktopOrMenuPanel(list, findIcons, findGenerated, Translator.R("DIMdesktopItems"), sb.toString());
    }

    private static JPanel createDesktopOrMenuPanel(JList list, ActionListener findIcons, ActionListener findGenerated, String title, String tooltip) {
        JPanel desktopPanel = new JPanel(new BorderLayout());
        JLabel l = new JLabel(title);
        l.setToolTipText(Panels.createToolTip(tooltip, list));
        desktopPanel.add((Component)l, "First");
        JScrollPane scrollDesktop = new JScrollPane();
        scrollDesktop.setViewportView(list);
        desktopPanel.add((Component)scrollDesktop, "Center");
        JPanel desktopToolPanel = Panels.createDesktopOrMenuToolBox(findIcons, findGenerated);
        desktopPanel.add((Component)desktopToolPanel, "Last");
        return desktopPanel;
    }

    private static String createToolTip(String tooltip, JList list) {
        if (tooltip != null) {
            JListUtils.FileListBasedJListModel model = (JListUtils.FileListBasedJListModel)list.getModel();
            StringBuilder sb = new StringBuilder();
            sb.append("<ul><li>").append(model.getFile()).append("</li><br><li>").append(model.toString()).append("</li><br><li>").append(tooltip).append("</ul>");
            String tt = SecurityDialogPanel.htmlWrap(sb.toString());
            return tt;
        }
        return null;
    }

    private static JPanel createDesktopOrMenuToolBox(ActionListener findIcons, ActionListener findGenerated) {
        JPanel desktopToolPanel = new JPanel(new BorderLayout());
        JButton desktopFindGeneratedButton = new JButton(Translator.R("DIMgeneratedButton"));
        desktopFindGeneratedButton.setToolTipText(Translator.R("DIMgeneratedButtonTooltip"));
        desktopFindGeneratedButton.addActionListener(findGenerated);
        JButton desktopFindIconsButton = new JButton(Translator.R("DIMiconsButton"));
        desktopFindIconsButton.setToolTipText(Translator.R("DIMiconsButtonTooltip"));
        desktopFindIconsButton.addActionListener(findIcons);
        desktopToolPanel.add((Component)desktopFindGeneratedButton, "After");
        desktopToolPanel.add((Component)desktopFindIconsButton, "Before");
        return desktopToolPanel;
    }

    static JSplitPane createQuadroSplit(int width, JPanel menusPanel, JPanel desktopsPanel, JPanel iconsPanel, JPanel generatedsPanel) {
        JSplitPane splitAllAndGenerated = new JSplitPane();
        JSplitPane splitIconsAndLists = new JSplitPane();
        JSplitPane splitLists = new JSplitPane();
        splitLists.setLeftComponent(menusPanel);
        splitLists.setRightComponent(desktopsPanel);
        splitIconsAndLists.setRightComponent(splitLists);
        splitIconsAndLists.setLeftComponent(iconsPanel);
        splitAllAndGenerated.setLeftComponent(splitIconsAndLists);
        splitAllAndGenerated.setRightComponent(generatedsPanel);
        splitAllAndGenerated.setDividerLocation(width / 5 * 4);
        splitIconsAndLists.setDividerLocation(width / 4);
        splitLists.setDividerLocation(width / 4);
        return splitAllAndGenerated;
    }

    private static String bold(String s) {
        return "<b>" + s + "</b>";
    }
}

