/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.chooser.importProgress.ImportProgressPage;
import com.intellij.ide.startup.importSettings.chooser.productChooser.ProductChooserPage;
import com.intellij.ide.startup.importSettings.chooser.settingChooser.SettingChooserPage;
import com.intellij.ide.startup.importSettings.chooser.ui.BaseControllerImpl;
import com.intellij.ide.startup.importSettings.chooser.ui.ImportSettingsController;
import com.intellij.ide.startup.importSettings.chooser.ui.ImportSettingsControllerKt;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingDialog;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingPage;
import com.intellij.ide.startup.importSettings.chooser.ui.SettingsImportOrigin;
import com.intellij.ide.startup.importSettings.data.ActionsDataProvider;
import com.intellij.ide.startup.importSettings.data.BaseService;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DataToApply;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.ide.startup.importSettings.data.PluginService;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.data.StartupWizardService;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import com.intellij.ide.startup.importSettings.wizard.pluginChooser.WizardPluginsPage;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.OnboardingBackgroundImageProvider;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J2\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsController;", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BaseControllerImpl;", "dialog", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "skipImportAction", "Lkotlin/Function0;", "", "(Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;Lkotlin/jvm/functions/Function0;)V", "getSkipImportAction", "()Lkotlin/jvm/functions/Function0;", "canShowFeaturedPluginsPage", "", "origin", "Lcom/intellij/ide/startup/importSettings/chooser/ui/SettingsImportOrigin;", "configChosen", "goToFeaturedPluginsPage", "provider", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider;", "productService", "Lcom/intellij/ide/startup/importSettings/data/BaseService;", "product", "Lcom/intellij/ide/startup/importSettings/data/Product;", "dataForSave", "", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "goToProductChooserPage", "goToProgressPage", "importFromProduct", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "dataToApply", "Lcom/intellij/ide/startup/importSettings/data/DataToApply;", "goToSettingsPage", "shouldShowFeaturedPluginsPage", "productId", "", "skipImport", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nImportSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportSettingsController.kt\ncom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1747#2,3:167\n*S KotlinDebug\n*F\n+ 1 ImportSettingsController.kt\ncom/intellij/ide/startup/importSettings/chooser/ui/ImportSettingsControllerImpl\n*L\n106#1:167,3\n*E\n"})
final class ImportSettingsControllerImpl
extends BaseControllerImpl
implements ImportSettingsController {
    @NotNull
    private final Function0<Unit> skipImportAction;

    public ImportSettingsControllerImpl(final @NotNull OnboardingDialog dialog2, @NotNull Function0<Unit> skipImportAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Intrinsics.checkNotNullParameter(skipImportAction, (String)"skipImportAction");
        super(dialog2);
        this.skipImportAction = skipImportAction;
        SettingsService settService = SettingsService.Companion.getInstance();
        settService.getDoClose().advise(this.getLifetime(), (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                dialog2.dialogClose();
            }
        });
        InterfacesKt.viewNotNull((IViewable)((IViewable)settService.getNotification()), (Lifetime)this.getLifetime(), (Function2)((Function2)new Function2<Lifetime, NotificationData, Unit>(){

            public final void invoke(@NotNull Lifetime lt, @NotNull NotificationData it) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                dialog2.showOverlay(it, lt);
            }
        }));
    }

    @Override
    @NotNull
    public Function0<Unit> getSkipImportAction() {
        return this.skipImportAction;
    }

    @Override
    public void goToSettingsPage(@NotNull ActionsDataProvider<?> provider, @NotNull Product product) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        OnboardingPage page2 = SettingChooserPage.Companion.createPage(provider, product, this);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page2);
        provider.productSelected(product);
        this.getDialog().changePage(page2);
    }

    @Override
    public void goToProductChooserPage() {
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        boolean isDark = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.isDark() : true;
        ProductChooserPage page2 = new ProductChooserPage(this, OnboardingBackgroundImageProvider.Companion.getInstance().getImage(isDark));
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page2);
        ImportSettingsEventsCollector.INSTANCE.productPageShown();
        this.getDialog().changePage(page2);
    }

    @Override
    public boolean canShowFeaturedPluginsPage(@NotNull SettingsImportOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
        return switch (WhenMappings.$EnumSwitchMapping$0[origin.ordinal()]) {
            case 1, 2 -> {
                if (StartupWizardService.Companion.getInstance() != null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean shouldShowFeaturedPluginsPage(@NotNull String productId, @NotNull List<DataForSave> dataForSave, @NotNull BaseService productService) {
        boolean bl;
        Object pluginService;
        block5: {
            Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
            Intrinsics.checkNotNullParameter(dataForSave, (String)"dataForSave");
            Intrinsics.checkNotNullParameter((Object)productService, (String)"productService");
            Object object = StartupWizardService.Companion.getInstance();
            if (object == null || (object = object.getPluginService()) == null) {
                ImportSettingsControllerImpl $this$shouldShowFeaturedPluginsPage_u24lambda_u240 = this;
                boolean bl2 = false;
                ImportSettingsControllerKt.access$getLogger$p().info("No wizard service registered, not going to show the featured plugins page.");
                return false;
            }
            pluginService = object;
            Iterable $this$any$iv = dataForSave;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataForSave it = (DataForSave)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"plugins")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean installPlugins2 = bl;
        List<String> pluginIdsMarkedForInstallation = installPlugins2 ? productService.getImportablePluginIds(productId) : CollectionsKt.emptyList();
        ImportSettingsControllerKt.access$getLogger$p().info(pluginIdsMarkedForInstallation.size() + " plugins marked for installation so far.");
        if (!pluginService.shouldShowPage(pluginIdsMarkedForInstallation)) {
            ImportSettingsControllerKt.access$getLogger$p().info("Plugin service reported that showing the featured plugin page is unnecessary.");
            return false;
        }
        ImportSettingsControllerKt.access$getLogger$p().info("Going to show the featured plugin installation page.");
        return true;
    }

    @Override
    public void goToFeaturedPluginsPage(@NotNull ActionsDataProvider<?> provider, @NotNull BaseService productService, @NotNull Product product, @NotNull List<DataForSave> dataForSave) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)productService, (String)"productService");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter(dataForSave, (String)"dataForSave");
        StartupWizardService startupWizardService = StartupWizardService.Companion.getInstance();
        if (startupWizardService == null) {
            throw new IllegalStateException("Cannot find the wizard service.".toString());
        }
        StartupWizardService wizardService = startupWizardService;
        PluginService pluginService = wizardService.getPluginService();
        WizardPluginsPage page2 = new WizardPluginsPage(this, pluginService, (Function0<Unit>)((Function0)new Function0<Unit>(wizardService, this, provider, product){
            final /* synthetic */ StartupWizardService $wizardService;
            final /* synthetic */ ImportSettingsControllerImpl this$0;
            final /* synthetic */ ActionsDataProvider<?> $provider;
            final /* synthetic */ Product $product;
            {
                this.$wizardService = $wizardService;
                this.this$0 = $receiver;
                this.$provider = $provider;
                this.$product = $product;
                super(0);
            }

            public final void invoke() {
                this.$wizardService.onExit();
                this.this$0.goToSettingsPage(this.$provider, this.$product);
            }
        }), (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(dataForSave, productService, product, this){
            final /* synthetic */ List<DataForSave> $dataForSave;
            final /* synthetic */ BaseService $productService;
            final /* synthetic */ Product $product;
            final /* synthetic */ ImportSettingsControllerImpl this$0;
            {
                this.$dataForSave = $dataForSave;
                this.$productService = $productService;
                this.$product = $product;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> featuredPluginIds) {
                Intrinsics.checkNotNullParameter(featuredPluginIds, (String)"featuredPluginIds");
                DataToApply dataToApply = new DataToApply(this.$dataForSave, featuredPluginIds);
                DialogImportData importSettings2 = this.$productService.importSettings(this.$product.getId(), dataToApply);
                this.this$0.goToProgressPage(importSettings2, dataToApply);
            }
        }), ImportSettingsBundle.INSTANCE.message("onboarding.wizard.finish-button", new Object[0]));
        ImportSettingsEventsCollector.INSTANCE.featuredPluginsPageShown();
        wizardService.onEnter();
        this.getDialog().changePage(page2);
    }

    @Override
    public void goToProgressPage(@NotNull DialogImportData importFromProduct, @NotNull DataToApply dataToApply) {
        Intrinsics.checkNotNullParameter((Object)importFromProduct, (String)"importFromProduct");
        Intrinsics.checkNotNullParameter((Object)dataToApply, (String)"dataToApply");
        String dialogTitleOverride = !((Collection)dataToApply.getFeaturedPluginIds()).isEmpty() ? ImportSettingsBundle.INSTANCE.message("onboarding.wizard.getting-ready", new Object[0]) : null;
        ImportProgressPage page2 = new ImportProgressPage(importFromProduct, this, dialogTitleOverride);
        Disposer.tryRegister((Disposable)this.getDialog().getDisposable(), (Disposable)page2);
        ImportSettingsEventsCollector.INSTANCE.importProgressPageShown();
        this.getDialog().changePage(page2);
    }

    @Override
    public void skipImport() {
        this.getDialog().dialogClose();
    }

    @Override
    public void configChosen() {
        SettingsService.Companion.getInstance().configChosen();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SettingsImportOrigin.values().length];
            try {
                nArray[SettingsImportOrigin.ThirdPartyProduct.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsImportOrigin.JetBrainsProduct.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsImportOrigin.Sync.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

