/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.data;

import com.intellij.ide.startup.importSettings.data.ActionsDataProvider;
import com.intellij.ide.startup.importSettings.data.ExternalProductService;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsContributor;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import com.intellij.ide.startup.importSettings.transfer.ExternalProductInfo;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/startup/importSettings/data/ExtActionsDataProvider;", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider;", "Lcom/intellij/ide/startup/importSettings/data/ExternalProductService;", "productService", "(Lcom/intellij/ide/startup/importSettings/data/ExternalProductService;)V", "main", "", "Lcom/intellij/ide/startup/importSettings/data/Product;", "getMain", "()Ljava/util/List;", "other", "getOther", "getProductService", "()Lcom/intellij/ide/startup/importSettings/data/ExternalProductService;", "title", "", "getTitle", "()Ljava/lang/String;", "getComment", "contributor", "Lcom/intellij/ide/startup/importSettings/data/SettingsContributor;", "getProductIcon", "Ljavax/swing/Icon;", "productId", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "getText", "productSelected", "", "intellij.ide.startup.importSettings"})
public final class ExtActionsDataProvider
implements ActionsDataProvider<ExternalProductService> {
    @NotNull
    private final ExternalProductService productService;
    @Nullable
    private final List<Product> other;

    public ExtActionsDataProvider(@NotNull ExternalProductService productService) {
        Intrinsics.checkNotNullParameter((Object)productService, (String)"productService");
        this.productService = productService;
    }

    @Override
    @NotNull
    public ExternalProductService getProductService() {
        return this.productService;
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String productId, @NotNull IconProductSize size) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        return this.getProductService().getProductIcon(productId, size);
    }

    @Override
    @NotNull
    public String getText(@NotNull SettingsContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        return contributor.getName();
    }

    @Override
    @Nullable
    public String getComment(@NotNull SettingsContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        ExternalProductInfo externalProductInfo = contributor instanceof ExternalProductInfo ? (ExternalProductInfo)contributor : null;
        return externalProductInfo != null ? externalProductInfo.getComment() : null;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.getProductService().getProductTitle();
    }

    @Override
    @NotNull
    public List<Product> getMain() {
        return this.getProductService().products();
    }

    @Override
    @Nullable
    public List<Product> getOther() {
        return this.other;
    }

    @Override
    public void productSelected(@NotNull SettingsContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        ImportSettingsEventsCollector.INSTANCE.externalSelected(((Product)contributor).getId());
    }
}

