/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode;

import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vscode.VSCodeSettingsProcessor;
import com.intellij.ide.startup.importSettings.providers.vscode.VSCodeTransferSettingsRightPanelChooser;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.util.SmartList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0006H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020 H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "cachedIdeVersion", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "getCachedIdeVersion", "()Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "cachedIdeVersion$delegate", "Lkotlin/Lazy;", "name", "", "getName", "()Ljava/lang/String;", "processor", "Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor;", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getIdeVersion", "getIdeVersions", "Lcom/intellij/util/SmartList;", "skipIds", "", "getRightPanel", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ideV", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "hasDataToImport", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAvailable", "isVSCodeDetected", "intellij.ide.startup.importSettings"})
public final class VSCodeTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId;
    @NotNull
    private final VSCodeSettingsProcessor processor;
    @NotNull
    private final Lazy cachedIdeVersion$delegate;

    public VSCodeTransferSettingsProvider(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.transferableIdeId = TransferableIdeId.VSCode;
        this.processor = new VSCodeSettingsProcessor(scope);
        this.cachedIdeVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IdeVersion>(this){
            final /* synthetic */ VSCodeTransferSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IdeVersion invoke() {
                Icon icon = AllIcons.TransferSettings.Vscode;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vscode");
                return new IdeVersion(TransferableIdeId.VSCode, null, "VSCode", icon, "Visual Studio Code", null, (Function0)new Function0<Settings>(this.this$0){
                    final /* synthetic */ VSCodeTransferSettingsProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Settings invoke() {
                        return VSCodeTransferSettingsProvider.access$getProcessor$p(this.this$0).getProcessedSettings();
                    }
                }, null, this.this$0, 0, 672, null);
            }
        }));
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return "Visual Studio Code";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ VSCodeTransferSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxBoolean((boolean)VSCodeTransferSettingsProvider.access$isVSCodeDetected(this.this$0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public SmartList<IdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        SmartList smartList;
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        boolean bl = this.isVSCodeDetected();
        if (bl) {
            smartList = new SmartList((Object)this.getIdeVersion());
        } else if (!bl) {
            smartList = new SmartList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return smartList;
    }

    private final IdeVersion getCachedIdeVersion() {
        Lazy lazy = this.cachedIdeVersion$delegate;
        return (IdeVersion)lazy.getValue();
    }

    private final IdeVersion getIdeVersion() {
        return this.getCachedIdeVersion();
    }

    private final boolean isVSCodeDetected() {
        return Files.isDirectory(Paths.get(VSCodeSettingsProcessor.Companion.getVsCodeHome$intellij_ide_startup_importSettings(), new String[0]), new LinkOption[0]) && this.processor.isInstanceRecentEnough() && this.processor.willDetectAtLeastSomething();
    }

    @Override
    @NotNull
    public TransferSettingsRightPanelChooser getRightPanel(@NotNull IdeVersion ideV, @NotNull TransferSettingsConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)ideV, (String)"ideV");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new VSCodeTransferSettingsRightPanelChooser(ideV, config);
    }

    public static final /* synthetic */ boolean access$isVSCodeDetected(VSCodeTransferSettingsProvider $this) {
        return $this.isVSCodeDetected();
    }

    public static final /* synthetic */ VSCodeSettingsProcessor access$getProcessor$p(VSCodeTransferSettingsProvider $this) {
        return $this.processor;
    }
}

