/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vsmac.parsers;

import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.parsers.RecentProjectsParserKt;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/parsers/RecentProjectsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "file", "Ljava/io/File;", "processRecentProjects", "root", "Lorg/jdom/Element;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nRecentProjectsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectsParser.kt\ncom/intellij/ide/startup/importSettings/providers/vsmac/parsers/RecentProjectsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 RecentProjectsParser.kt\ncom/intellij/ide/startup/importSettings/providers/vsmac/parsers/RecentProjectsParser\n*L\n37#1:65,2\n*E\n"})
public final class RecentProjectsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private static final String MIME_TYPE = "Mime-Type";
    @NotNull
    private static final String SLN_TYPE = "application/x-sln";
    @NotNull
    private static final String URI_FIELD = "URI";

    public RecentProjectsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            RecentProjectsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processRecentProjects(root);
        }
        catch (Throwable t) {
            RecentProjectsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processRecentProjects(Element root) {
        long i = 0L;
        i = System.currentTimeMillis();
        List list = root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element recentItem = (Element)element$iv;
            boolean bl = false;
            try {
                RecentProjectMetaInfo recentProjectMetaInfo;
                Path path;
                String string;
                String string2;
                Element element = recentItem.getChild(MIME_TYPE);
                String string3 = string2 = element != null ? element.getValue() : null;
                if (string3 == null) continue;
                Intrinsics.checkNotNull((Object)string3);
                String mimeType = string2;
                if (!Intrinsics.areEqual((Object)mimeType, (Object)SLN_TYPE)) continue;
                Element element2 = recentItem.getChild(URI_FIELD);
                String string4 = string = element2 != null ? element2.getValue() : null;
                if (string4 == null) continue;
                Intrinsics.checkNotNull((Object)string4);
                String uri = string;
                Path path2 = path = Path.of(new URI(uri));
                if (path2 == null) continue;
                Intrinsics.checkNotNull((Object)path2);
                Path path3 = path;
                RecentProjectMetaInfo $this$processRecentProjects_u24lambda_u241_u24lambda_u240 = recentProjectMetaInfo = new RecentProjectMetaInfo();
                boolean bl2 = false;
                $this$processRecentProjects_u24lambda_u241_u24lambda_u240.setDisplayName(((Object)path3.getFileName()).toString());
                $this$processRecentProjects_u24lambda_u241_u24lambda_u240.setProjectOpenTimestamp(i -= (long)1000);
                $this$processRecentProjects_u24lambda_u241_u24lambda_u240.setBuildTimestamp(i);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    $this$processRecentProjects_u24lambda_u241_u24lambda_u240.setMetadata("folder|");
                }
                RecentProjectMetaInfo rpmi = recentProjectMetaInfo;
                this.settings.addRecentProjectIfNeeded((Function0<RecentPathInfo>)((Function0)new Function0<RecentPathInfo>(path3, rpmi){
                    final /* synthetic */ Path $path;
                    final /* synthetic */ RecentProjectMetaInfo $rpmi;
                    {
                        this.$path = $path;
                        this.$rpmi = $rpmi;
                        super(0);
                    }

                    @Nullable
                    public final RecentPathInfo invoke() {
                        return new RecentPathInfo(PathsKt.getInvariantSeparatorsPathString((Path)this.$path), this.$rpmi);
                    }
                }));
            }
            catch (Throwable t) {
                RecentProjectsParserKt.access$getLogger$p().warn(t);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/parsers/RecentProjectsParser$Companion;", "", "()V", "MIME_TYPE", "", "SLN_TYPE", "URI_FIELD", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

