/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.ui;

import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.TransferSettingsModel;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.ui.TransferSettingsLeftPanel;
import com.intellij.ide.startup.importSettings.ui.TransferSettingsView;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRepresentationPanel;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/startup/importSettings/ui/TransferSettingsView;", "", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "model", "Lcom/intellij/ide/startup/importSettings/models/TransferSettingsModel;", "(Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;Lcom/intellij/ide/startup/importSettings/models/TransferSettingsModel;)V", "cachedViews", "", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRepresentationPanel;", "contentPanel", "Ljavax/swing/JPanel;", "leftPanel", "Lcom/intellij/ide/startup/importSettings/ui/TransferSettingsLeftPanel;", "panel", "getPanel", "()Ljavax/swing/JPanel;", "selectedIde", "getSelectedIde", "()Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "initPanel", "performRefresh", "", "selectionTargetId", "", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nTransferSettingsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferSettingsView.kt\ncom/intellij/ide/startup/importSettings/ui/TransferSettingsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n350#2,7:100\n*S KotlinDebug\n*F\n+ 1 TransferSettingsView.kt\ncom/intellij/ide/startup/importSettings/ui/TransferSettingsView\n*L\n96#1:100,7\n*E\n"})
public final class TransferSettingsView {
    @NotNull
    private final TransferSettingsConfiguration config;
    @NotNull
    private final TransferSettingsModel model;
    @NotNull
    private final TransferSettingsLeftPanel leftPanel;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final Map<BaseIdeVersion, TransferSettingsRepresentationPanel> cachedViews;
    @NotNull
    private final JPanel panel;

    public TransferSettingsView(@NotNull TransferSettingsConfiguration config, @NotNull TransferSettingsModel model) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.config = config;
        this.model = model;
        this.leftPanel = new TransferSettingsLeftPanel((ListModel<BaseIdeVersion>)this.model.getListModel());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, fill"));
        this.cachedViews = new LinkedHashMap();
        this.panel = this.initPanel();
        this.config.getController().addListener(new TransferSettingsListener(){

            @Override
            public void reloadPerformed(@NotNull FailedIdeVersion ideVersion) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                cachedViews.remove(ideVersion);
                this.performRefresh(ideVersion.getId());
            }

            @Override
            public void importStarted(@NotNull IdeVersion ideVersion, @NotNull Settings settings) {
                Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                TransferSettingsRepresentationPanel transferSettingsRepresentationPanel = (TransferSettingsRepresentationPanel)cachedViews.get(this.getSelectedIde());
                if (transferSettingsRepresentationPanel != null) {
                    transferSettingsRepresentationPanel.block();
                }
                leftPanel.getList().setEnabled(false);
            }
        });
    }

    @Nullable
    public final BaseIdeVersion getSelectedIde() {
        return this.leftPanel.getList().getSelectedValue();
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    private final JPanel initPanel() {
        JPanel jPanel;
        JPanel $this$initPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$initPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout("ins 0, novisualpadding, fill"));
        $this$initPanel_u24lambda_u240.addComponentListener(new ComponentAdapter(){
            private boolean shown;

            public void componentShown(@Nullable ComponentEvent e) {
                this.onEvent();
            }

            public void componentResized(@Nullable ComponentEvent e) {
                this.onEvent();
            }

            private final void onEvent() {
                if (this.shown) {
                    return;
                }
                TransferSettingsCollector.INSTANCE.logTransferSettingsShown();
                this.shown = true;
            }
        });
        if (this.model.getShouldShowLeftPanel()) {
            $this$initPanel_u24lambda_u240.add((Component)((Object)this.leftPanel), "west, width 250px, wmax 250px, wmin 250px, growy, pushy, spany");
        }
        $this$initPanel_u24lambda_u240.add((Component)this.contentPanel, "east, grow, push, span");
        this.contentPanel.add(new JLabel());
        $this$initPanel_u24lambda_u240.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
        Ref.ObjectRef previousSelected = new Ref.ObjectRef();
        this.leftPanel.addListSelectionListener((Function2<? super JList<BaseIdeVersion>, ? super ListSelectionEvent, Unit>)((Function2)new Function2<JList<BaseIdeVersion>, ListSelectionEvent, Unit>((Ref.ObjectRef<BaseIdeVersion>)previousSelected, this){
            final /* synthetic */ Ref.ObjectRef<BaseIdeVersion> $previousSelected;
            final /* synthetic */ TransferSettingsView this$0;
            {
                this.$previousSelected = $previousSelected;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull JList<BaseIdeVersion> $this$addListSelectionListener, @NotNull ListSelectionEvent it) {
                Object object;
                Object object2;
                block8: {
                    V value$iv;
                    block5: {
                        TransferSettingsRepresentationPanel transferSettingsRepresentationPanel;
                        Object object3;
                        void key$iv;
                        void $this$getOrPut$iv;
                        TransferSettingsView transferSettingsView;
                        block7: {
                            block6: {
                                Intrinsics.checkNotNullParameter($this$addListSelectionListener, (String)"$this$addListSelectionListener");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if ($this$addListSelectionListener.getSelectedValue() == null) {
                                    return;
                                }
                                if (Intrinsics.areEqual((Object)this.$previousSelected.element, (Object)$this$addListSelectionListener.getSelectedValue())) {
                                    return;
                                }
                                this.$previousSelected.element = $this$addListSelectionListener.getSelectedValue();
                                object2 = TransferSettingsView.access$getCachedViews$p(this.this$0);
                                BaseIdeVersion baseIdeVersion = $this$addListSelectionListener.getSelectedValue();
                                Intrinsics.checkNotNullExpressionValue((Object)baseIdeVersion, (String)"getSelectedValue(...)");
                                BaseIdeVersion baseIdeVersion2 = baseIdeVersion;
                                transferSettingsView = this.this$0;
                                boolean $i$f$getOrPut = false;
                                value$iv = $this$getOrPut$iv.get(key$iv);
                                if (value$iv != null) break block5;
                                boolean bl = false;
                                BaseIdeVersion baseIdeVersion3 = $this$addListSelectionListener.getSelectedValue();
                                object3 = baseIdeVersion3 instanceof IdeVersion ? (IdeVersion)baseIdeVersion3 : null;
                                if (object3 == null) break block6;
                                IdeVersion it2 = object3;
                                boolean bl2 = false;
                                TransferSettingsRightPanelChooser transferSettingsRightPanelChooser = it2.getProvider().getRightPanel(it2, TransferSettingsView.access$getConfig$p(transferSettingsView));
                                object3 = transferSettingsRightPanelChooser;
                                if (transferSettingsRightPanelChooser != null) break block7;
                            }
                            BaseIdeVersion baseIdeVersion = $this$addListSelectionListener.getSelectedValue();
                            Intrinsics.checkNotNullExpressionValue((Object)baseIdeVersion, (String)"getSelectedValue(...)");
                            object3 = new TransferSettingsRightPanelChooser(baseIdeVersion, TransferSettingsView.access$getConfig$p(transferSettingsView));
                        }
                        Object chooser = object3;
                        TransferSettingsRepresentationPanel $this$invoke_u24lambda_u244_u24lambda_u243 = transferSettingsRepresentationPanel = ((TransferSettingsRightPanelChooser)chooser).select();
                        boolean bl = false;
                        $this$invoke_u24lambda_u244_u24lambda_u243.onStateChange(() -> initPanel.1.2.invoke$lambda$4$lambda$3$lambda$2($this$addListSelectionListener, transferSettingsView));
                        TransferSettingsRepresentationPanel answer$iv = transferSettingsRepresentationPanel;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                        break block8;
                    }
                    object = value$iv;
                }
                TransferSettingsRepresentationPanel view = (TransferSettingsRepresentationPanel)object;
                Object $this$invoke_u24lambda_u245 = object2 = TransferSettingsView.access$getContentPanel$p(this.this$0);
                boolean bl = false;
                ((Container)$this$invoke_u24lambda_u245).removeAll();
                ((Container)$this$invoke_u24lambda_u245).add((Component)view.getComponent(), "grow, push, span, wmax 100%");
                ((JComponent)$this$invoke_u24lambda_u245).revalidate();
                ((Component)$this$invoke_u24lambda_u245).repaint();
                TransferSettingsController transferSettingsController = TransferSettingsView.access$getConfig$p(this.this$0).getController();
                BaseIdeVersion baseIdeVersion = $this$addListSelectionListener.getSelectedValue();
                Intrinsics.checkNotNullExpressionValue((Object)baseIdeVersion, (String)"getSelectedValue(...)");
                transferSettingsController.itemSelected(baseIdeVersion);
            }

            private static final void invoke$lambda$4$lambda$3$lambda$2(JList $this_addListSelectionListener, TransferSettingsView this$0) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this_addListSelectionListener, (String)"$this_addListSelectionListener");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    E e = $this_addListSelectionListener.getSelectedValue();
                    IdeVersion ideVersion = e instanceof IdeVersion ? (IdeVersion)e : null;
                    if (ideVersion == null) break block0;
                    IdeVersion it1 = ideVersion;
                    boolean bl = false;
                    TransferSettingsView.access$getConfig$p(this$0).getController().updateCheckboxes(it1);
                }
            }
        }));
        this.performRefresh(null);
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final void performRefresh(String selectionTargetId) {
        int n;
        List<BaseIdeVersion> newOrdered = this.model.performRefresh();
        JList<BaseIdeVersion> jList = this.leftPanel.getList();
        if (selectionTargetId != null) {
            int n2;
            JList<BaseIdeVersion> jList2;
            block4: {
                void $this$indexOfFirst$iv;
                List<BaseIdeVersion> list = newOrdered;
                jList2 = jList;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    BaseIdeVersion it = (BaseIdeVersion)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)selectionTargetId)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            int n3 = n2;
            jList = jList2;
            n = n3;
        } else {
            n = 0;
        }
        jList.setSelectedIndex(n);
    }

    public static final /* synthetic */ JPanel access$getContentPanel$p(TransferSettingsView $this) {
        return $this.contentPanel;
    }

    public static final /* synthetic */ TransferSettingsConfiguration access$getConfig$p(TransferSettingsView $this) {
        return $this.config;
    }
}

