/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.PackageUtilKt;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.toolwindow.dialog.IgnoreVulnerabilitiesDialog;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\f0\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0003J\"\u0010\u0014\u001a\f0\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/VulnerabilityPanels;", "Lcom/intellij/ui/components/JBPanel;", "vulnerabilities", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "pkg", "Lorg/jetbrains/security/package/Package;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/packageChecker/model/ModuleModel;", "(Ljava/util/List;Lorg/jetbrains/security/package/Package;Lcom/intellij/openapi/project/Project;Lcom/intellij/packageChecker/model/ModuleModel;)V", "getVulnerabilities", "()Ljava/util/List;", "getContentAsText", "", "getCveLabelText", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "vulnerability", "getFalsePositiveContent", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerabilityPanels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilityPanels.kt\ncom/intellij/packageChecker/toolwindow/preview/VulnerabilityPanels\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1855#2,2:124\n*S KotlinDebug\n*F\n+ 1 VulnerabilityPanels.kt\ncom/intellij/packageChecker/toolwindow/preview/VulnerabilityPanels\n*L\n53#1:124,2\n*E\n"})
public final class VulnerabilityPanels
extends JBPanel<VulnerabilityPanels> {
    @NotNull
    private final List<Vulnerability> vulnerabilities;

    /*
     * WARNING - void declaration
     */
    public VulnerabilityPanels(@NotNull List<Vulnerability> vulnerabilities, final @NotNull Package pkg, final @NotNull Project project, final @Nullable ModuleModel module) {
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new GridBagLayout());
        this.vulnerabilities = vulnerabilities;
        GridBag gridBag = new GridBag().setDefaultAnchor(0, 17).setDefaultAnchor(1, 13).setDefaultInsets(0, 20, 16, 20).setDefaultFill(1);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultFill(...)");
        GridBag gridBag2 = gridBag;
        if (module != null) {
            String string = PackageCheckerBundle.message("problem.tab.ignoreVulnerabilities", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.add((Component)new ActionLink(string, (Function1)new Function1<ActionEvent, Unit>(){

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    new IgnoreVulnerabilitiesDialog(project, pkg, module.getParentModuleName()).show();
                }
            }), gridBag2.nextLine().next().insetTop(12));
        }
        Iterable $this$forEach$iv = this.vulnerabilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void jbLabel;
            JBLabel jBLabel;
            String vulnerabilityDescription;
            JEditorPane jEditorPane;
            Vulnerability vulnerability = (Vulnerability)element$iv;
            boolean bl = false;
            JBLabel severityIcon = new JBLabel(PackageUtilKt.severityIcon(SeverityFactory.Companion.fromScore(vulnerability.getCvssScore())));
            JEditorPane it = jEditorPane = ComponentsKt.htmlComponent$default((String)this.getCveLabelText(vulnerability), null, null, null, (boolean)false, null, (int)62, null);
            boolean bl2 = false;
            it.setFont((Font)JBFont.label().asBold());
            it.setFocusable(true);
            JEditorPane cveLabel = jEditorPane;
            WrapLayout wrapLayout = new WrapLayout(0);
            wrapLayout.setHgap(6);
            JBPanel cveAndSeverityIconPanel = new JBPanel((LayoutManager)wrapLayout);
            cveAndSeverityIconPanel.add((Component)severityIcon);
            cveAndSeverityIconPanel.add((Component)cveLabel);
            this.add((Component)cveAndSeverityIconPanel, gridBag2.nextLine().next().insetTop(12));
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeXmlEntities((String)vulnerability.getDescription()), (String)"escapeXmlEntities(...)");
            JComponent jComponent = ComponentsKt.htmlComponent$default((String)vulnerabilityDescription, null, null, null, (boolean)false, null, (int)46, null);
            JEditorPane textLabel = jComponent;
            boolean bl3 = false;
            textLabel.setFocusable(true);
            this.add(textLabel, gridBag2.nextLine().coverLine().weighty(1.0).weightx(1.0).insetBottom(0));
            JComponent linkPanel = jComponent = new JPanel(new FlowLayout(0, 0, 0));
            boolean bl4 = false;
            String string = PackageCheckerBundle.message("action.link.report.false.positive", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ActionLink reportFPActionLink2 = new ActionLink(string, (Function1)new Function1<ActionEvent, Unit>(project, pkg, vulnerability, this){
                final /* synthetic */ Project $project;
                final /* synthetic */ Package $pkg;
                final /* synthetic */ Vulnerability $vulnerability;
                final /* synthetic */ VulnerabilityPanels this$0;
                {
                    this.$project = $project;
                    this.$pkg = $pkg;
                    this.$vulnerability = $vulnerability;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PackageChecker.Companion.getInstance(this.$project).reportFP(this.$pkg, this.$vulnerability);
                    Messages.showInfoMessage((String)VulnerabilityPanels.access$getFalsePositiveContent(this.this$0, this.$vulnerability, this.$pkg), (String)PackageCheckerBundle.message("message.false.positive.title", new Object[0]));
                }
            });
            String string2 = PackageCheckerBundle.message("action.link.read.more", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            ActionLink readMoreLink2 = new ActionLink(string2, (Function1)new Function1<ActionEvent, Unit>(vulnerability){
                final /* synthetic */ Vulnerability $vulnerability;
                {
                    this.$vulnerability = $vulnerability;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    BrowserUtil.browse((String)PackageUtilKt.getReference(this.$vulnerability));
                }
            });
            readMoreLink2.setExternalLinkIcon();
            linkPanel.add((Component)reportFPActionLink2);
            linkPanel.add(new JSeparator(1));
            JBLabel jBLabel2 = jBLabel = new JBLabel("|");
            JComponent jComponent2 = linkPanel;
            boolean bl5 = false;
            jbLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
            jbLabel.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
            jComponent2.add((Component)jBLabel);
            linkPanel.add(new JSeparator(1));
            linkPanel.add((Component)readMoreLink2);
            this.add(linkPanel, gridBag2.nextLine().insetTop(12));
        }
    }

    @NotNull
    public final List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @NlsSafe
    private final String getCveLabelText(Vulnerability vulnerability) {
        Object[] objectArray = new Object[]{vulnerability.getCve(), Float.valueOf(vulnerability.getCvssScore())};
        String string = PackageCheckerBundle.message("cve.label.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NlsSafe
    private final String getFalsePositiveContent(Vulnerability vulnerability, Package pkg) {
        Object[] objectArray = new Object[]{vulnerability.getCve(), pkg.getHumanReadableCoordinates()};
        String string = PackageCheckerBundle.message("message.false.positive.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final String getContentAsText() {
        String newLine = System.lineSeparator();
        Iterable iterable = this.vulnerabilities;
        Intrinsics.checkNotNull((Object)newLine);
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)newLine, null, null, (int)0, null, (Function1)((Function1)new Function1<Vulnerability, CharSequence>(newLine){
            final /* synthetic */ String $newLine;
            {
                this.$newLine = $newLine;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Vulnerability it) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$newLine;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Object[] objectArray = new Object[]{it.getCve(), Float.valueOf(it.getCvssScore())};
                $this$invoke_u24lambda_u240.append(PackageCheckerBundle.message("cve.label.text", objectArray));
                $this$invoke_u24lambda_u240.append(string);
                $this$invoke_u24lambda_u240.append(string);
                $this$invoke_u24lambda_u240.append(it.getDescription());
                $this$invoke_u24lambda_u240.append(string);
                $this$invoke_u24lambda_u240.append(string);
                $this$invoke_u24lambda_u240.append(PackageCheckerBundle.message("action.link.read.more", new Object[0]));
                $this$invoke_u24lambda_u240.append(": ");
                $this$invoke_u24lambda_u240.append(it.getReference());
                $this$invoke_u24lambda_u240.append(string);
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }
        }), (int)30, null);
    }

    public static final /* synthetic */ String access$getFalsePositiveContent(VulnerabilityPanels $this, Vulnerability vulnerability, Package pkg) {
        return $this.getFalsePositiveContent(vulnerability, pkg);
    }
}

