/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security;

import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.ClientData;
import org.jetbrains.security.HttpUtilKt;
import org.jetbrains.security.RemoteConfig;
import org.jetbrains.security.ResourceUrl;
import org.jetbrains.security.VulnerabilitiesRepository;
import org.jetbrains.security.VulnerabilitiesRepositoryServer;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.dto.FalsePositiveReport;
import org.jetbrains.security.dto.HashesDto;
import org.jetbrains.security.dto.RequestDto;
import org.jetbrains.security.dto.VulnerablePackageDto;
import org.jetbrains.security.exceptions.AnalysisException;
import org.jetbrains.security.exceptions.AnalysisExceptionScope;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J%\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001e\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/security/VulnerabilitiesRepositoryServer;", "Lorg/jetbrains/security/VulnerabilitiesRepository;", "httpClient", "Lio/ktor/client/HttpClient;", "dbBaseUrl", "Lorg/jetbrains/security/ResourceUrl;", "packagesUrlString", "", "falsePositiveUrl", "userAgent", "attemptsToCheck", "", "clientData", "Lorg/jetbrains/security/ClientData;", "(Lio/ktor/client/HttpClient;Lorg/jetbrains/security/ResourceUrl;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILorg/jetbrains/security/ClientData;)V", "chunkSize", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createRequestDto", "Lorg/jetbrains/security/dto/RequestDto;", "packageChunk", "", "Lorg/jetbrains/security/package/Package;", "getVulnerabilities", "Lorg/jetbrains/security/VulnerablePackage;", "pkgs", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVulnerabilitiesFromServer", "requestData", "(Lorg/jetbrains/security/dto/RequestDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportFalsePositive", "", "pkg", "vulnerability", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "(Lorg/jetbrains/security/package/Package;Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "client"})
@SourceDebugExtension(value={"SMAP\nVulnerabilitiesRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilitiesRepositoryServer.kt\norg/jetbrains/security/VulnerabilitiesRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt\n+ 4 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 5 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 6 HttpClientCall.kt\nio/ktor/client/call/HttpClientCallKt\n*L\n1#1,119:1\n1360#2:120\n1446#2,5:121\n1549#2:126\n1620#2,3:127\n1549#2:178\n1620#2,3:179\n343#3:130\n233#3:131\n109#3,2:149\n22#3:151\n343#3:152\n233#3:153\n109#3,2:171\n22#3:173\n16#4,4:132\n21#4,10:139\n16#4,4:154\n21#4,10:161\n17#5,3:136\n17#5,3:158\n17#5,3:175\n156#6:174\n*S KotlinDebug\n*F\n+ 1 VulnerabilitiesRepositoryServer.kt\norg/jetbrains/security/VulnerabilitiesRepositoryServer\n*L\n36#1:120\n36#1:121,5\n76#1:126\n76#1:127,3\n113#1:178\n113#1:179,3\n88#1:130\n88#1:131\n88#1:149,2\n88#1:151\n104#1:152\n104#1:153\n104#1:171,2\n104#1:173\n89#1:132,4\n89#1:139,10\n105#1:154,4\n105#1:161,10\n89#1:136,3\n105#1:158,3\n111#1:175,3\n111#1:174\n*E\n"})
public class VulnerabilitiesRepositoryServer
implements VulnerabilitiesRepository {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final String falsePositiveUrl;
    @NotNull
    private final String userAgent;
    private final int attemptsToCheck;
    @NotNull
    private final ClientData clientData;
    private final int chunkSize;
    private final Logger logger;

    public VulnerabilitiesRepositoryServer(@NotNull HttpClient httpClient2, @NotNull ResourceUrl dbBaseUrl, @NotNull String packagesUrlString, @NotNull String falsePositiveUrl, @NotNull String userAgent, int attemptsToCheck, @NotNull ClientData clientData) {
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)falsePositiveUrl, (String)"falsePositiveUrl");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        this.httpClient = httpClient2;
        this.dbBaseUrl = dbBaseUrl;
        this.packagesUrlString = packagesUrlString;
        this.falsePositiveUrl = falsePositiveUrl;
        this.userAgent = userAgent;
        this.attemptsToCheck = attemptsToCheck;
        this.clientData = clientData;
        this.chunkSize = 4096;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ VulnerabilitiesRepositoryServer(HttpClient httpClient2, ResourceUrl resourceUrl, String string, String string2, String string3, int n, ClientData clientData, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            httpClient2 = HttpUtilKt.ktorHttpClient$default(0L, 0L, 0L, 7, null);
        }
        if ((n2 & 2) != 0) {
            resourceUrl = RemoteConfig.INSTANCE.getDefaultDbUrl();
        }
        if ((n2 & 4) != 0) {
            string = "/api/v3/vulnerabilities/cx";
        }
        if ((n2 & 8) != 0) {
            string2 = "/report";
        }
        if ((n2 & 0x10) != 0) {
            string3 = "JetBrains Vulnerability Scanner";
        }
        if ((n2 & 0x20) != 0) {
            n = 3;
        }
        this(httpClient2, resourceUrl, string, string2, string3, n, clientData);
    }

    @Override
    @Nullable
    public Object getVulnerabilities(@NotNull Iterable<Package> pkgs2, @NotNull Continuation<? super List<VulnerablePackage>> $completion) {
        return VulnerabilitiesRepositoryServer.getVulnerabilities$suspendImpl(this, pkgs2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getVulnerabilities$suspendImpl(VulnerabilitiesRepositoryServer var0, Iterable<Package> var1_1, Continuation<? super List<VulnerablePackage>> var2_2) {
        block21: {
            block20: {
                if (!(var2_2 instanceof getVulnerabilities.1)) ** GOTO lbl-1000
                var16_3 = var2_2;
                if ((var16_3.label & -2147483648) != 0) {
                    var16_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, var2_2){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return VulnerabilitiesRepositoryServer.getVulnerabilities$suspendImpl(this.this$0, null, (Continuation<? super List<VulnerablePackage>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!($this.attemptsToCheck > 0)) {
                            var4_6 = "Failed requirement.";
                            throw new IllegalArgumentException(var4_6.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked((Iterable)pkgs, (int)$this.chunkSize);
                        $i$f$flatMap = false;
                        var5_9 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var8_12 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var8_12.hasNext()) {
                            element$iv$iv = var8_12.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                            attempt = 0;
                            exception = null;
lbl27:
                            // 3 sources

                            while (attempt <= $this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block20;
                                }
                                $continuation.L$0 = $this;
                                $continuation.L$1 = destination$iv$iv;
                                $continuation.L$2 = var8_12;
                                $continuation.L$3 = pkgChunk;
                                $continuation.L$4 = null;
                                $continuation.I$0 = attempt;
                                $continuation.label = 1;
                                v1 = $this.getVulnerabilitiesFromServer($this.createRequestDto(pkgChunk), (Continuation<? super List<VulnerablePackage>>)$continuation);
                                ** if (v1 != var17_5) goto lbl45
lbl44:
                                // 1 sources

                                return var17_5;
lbl45:
                                // 1 sources

                                ** GOTO lbl61
                            }
                            break block2;
                        }
                        break block21;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        attempt = $continuation.I$0;
                        pkgChunk = (List)$continuation.L$3;
                        var8_12 = (Iterator<T>)$continuation.L$2;
                        destination$iv$iv = (Collection)$continuation.L$1;
                        $this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl61:
                            // 2 sources

                            v0 = (List)v1;
                            break block20;
                        }
                        catch (IOException io) {
                            $this.logger.warn("Failed to check dependencies on server : " + $this.dbBaseUrl.getUrl(), (Throwable)io);
                            v2 = io.getMessage();
                            if (v2 == null) {
                                v2 = "IOException";
                            }
                            exception = new AnalysisException("Fail to check dependencies on server", AnalysisExceptionScope.USER, v2);
                        }
                        catch (IllegalArgumentException ia) {
                            $this.logger.warn("Failed to check dependencies on server : " + $this.dbBaseUrl.getUrl(), (Throwable)ia);
                            v3 = "Failed to check dependencies on server : " + $this.dbBaseUrl.getUrl();
                            v4 = ia.getMessage();
                            if (v4 == null) {
                                v4 = "IllegalArgumentException";
                            }
                            exception = new AnalysisException(v3, AnalysisExceptionScope.USER, v4);
                        }
                        catch (AnalysisException e) {
                            $this.logger.error("SERVER failed with exception");
                            exception = e;
                        }
                        $continuation.L$0 = $this;
                        $continuation.L$1 = destination$iv$iv;
                        $continuation.L$2 = var8_12;
                        $continuation.L$3 = pkgChunk;
                        $continuation.L$4 = exception;
                        $continuation.I$0 = attempt;
                        $continuation.label = 2;
                        v5 = DelayKt.delay((long)(attempt * 200), (Continuation)$continuation);
                        if (v5 != var17_5) ** GOTO lbl27
                        return var17_5;
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$4;
                        pkgChunk = (List)$continuation.L$3;
                        var8_12 = (Iterator)$continuation.L$2;
                        destination$iv$iv = (Collection)$continuation.L$1;
                        $this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        ** GOTO lbl27
                    }
                }
                if (exception != null) {
                    $this.logger.error(exception.getStackTrace().toString());
                    $this.httpClient.close();
                    throw exception;
                }
                $this.httpClient.close();
                v0 = CollectionsKt.emptyList();
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RequestDto createRequestDto(@NotNull List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageChunk, (String)"packageChunk");
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDtos = (List)destination$iv$iv;
        return new HashesDto(packageDtos, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    @Override
    @Nullable
    public Object reportFalsePositive(@NotNull Package pkg, @NotNull Vulnerability vulnerability, @NotNull Continuation<? super Unit> $completion) {
        return VulnerabilitiesRepositoryServer.reportFalsePositive$suspendImpl(this, pkg, vulnerability, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object reportFalsePositive$suspendImpl(VulnerabilitiesRepositoryServer var0, Package var1_1, Vulnerability var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof reportFalsePositive.1)) ** GOTO lbl-1000
        var27_4 = var3_3;
        if ((var27_4.label & -2147483648) != 0) {
            var27_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerabilitiesRepositoryServer.reportFalsePositive$suspendImpl(this.this$0, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                falsePositiveReport = new FalsePositiveReport(vulnerability.getCve(), pkg.getSearchKey(), $this.clientData.getAnonymousToken());
                var6_8 = $this.httpClient;
                urlString$iv = $this.dbBaseUrl.getUrl() + $this.falsePositiveUrl;
                $i$f$post = false;
                $this$post$iv$iv = $this$post$iv;
                $i$f$post = false;
                var11_15 = $this$post$iv$iv;
                $this$post_u24lambda_u245$iv = var12_16 = new HttpRequestBuilder();
                $i$a$-post-BuildersKt$post$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                $this$reportFalsePositive_u24lambda_u242 = $this$post_u24lambda_u245$iv;
                $i$a$-post-VulnerabilitiesRepositoryServer$reportFalsePositive$response$1 = false;
                $this$setBody$iv = $this$reportFalsePositive_u24lambda_u242;
                $i$f$setBody = false;
                var19_23 = falsePositiveReport;
                if (var19_23 instanceof OutgoingContent) {
                    $this$setBody$iv.setBody((Object)falsePositiveReport);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    $this$setBody$iv.setBody((Object)falsePositiveReport);
                    $i$f$typeInfo = false;
                    kType$iv$iv = Reflection.typeOf(FalsePositiveReport.class);
                    reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                    $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(FalsePositiveReport.class), (KType)kType$iv$iv));
                }
                HttpMessagePropertiesKt.userAgent((HttpMessageBuilder)((HttpMessageBuilder)$this$reportFalsePositive_u24lambda_u242), (String)$this.userAgent);
                HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$reportFalsePositive_u24lambda_u242), (ContentType)ContentType.Application.INSTANCE.getJson());
                builder$iv$iv$iv = var12_16;
                $i$f$post = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                if (v0 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl65
            }
            case 1: {
                $i$f$post = false;
                $i$f$post = false;
                $i$f$post = false;
                $i$f$request = false;
                $this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl65:
                // 2 sources

                response = (HttpResponse)v0;
                if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)response.getStatus())) {
                    $this.logger.warn("error during reporting FP, errorCode: " + response.getStatus());
                }
                $this.httpClient.close();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getVulnerabilitiesFromServer(RequestDto var1_1, Continuation<? super List<VulnerablePackage>> var2_2) {
        if (!(var2_2 instanceof getVulnerabilitiesFromServer.1)) ** GOTO lbl-1000
        var26_3 = var2_2;
        if ((var26_3.label & -2147483648) != 0) {
            var26_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerabilitiesRepositoryServer.access$getVulnerabilitiesFromServer(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = this.httpClient;
                urlString$iv = this.dbBaseUrl.getUrl() + this.packagesUrlString;
                $i$f$post = false;
                $this$post$iv$iv = $this$post$iv;
                $i$f$post = false;
                var9_16 = $this$post$iv$iv;
                $this$post_u24lambda_u245$iv /* !! */  = var10_17 = new HttpRequestBuilder();
                $i$a$-post-BuildersKt$post$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv /* !! */ , (String)urlString$iv);
                $this$getVulnerabilitiesFromServer_u24lambda_u243 = $this$post_u24lambda_u245$iv /* !! */ ;
                $i$a$-post-VulnerabilitiesRepositoryServer$getVulnerabilitiesFromServer$dtos$1 = false;
                $this$setBody$iv = $this$getVulnerabilitiesFromServer_u24lambda_u243;
                $i$f$setBody = false;
                var17_24 = requestData;
                if (var17_24 == null) {
                    $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                    $i$f$typeInfo = false;
                    kType$iv$iv = Reflection.typeOf(RequestDto.class);
                    reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                    $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(RequestDto.class), (KType)kType$iv$iv));
                } else if (var17_24 instanceof OutgoingContent) {
                    $this$setBody$iv.setBody((Object)requestData);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    $this$setBody$iv.setBody((Object)requestData);
                    $i$f$typeInfo = false;
                    kType$iv$iv = Reflection.typeOf(RequestDto.class);
                    reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                    $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(RequestDto.class), (KType)kType$iv$iv));
                }
                HttpMessagePropertiesKt.userAgent((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u243), (String)this.userAgent);
                HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u243), (ContentType)ContentType.Application.INSTANCE.getJson());
                HttpRequestKt.headers((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u243), (Function1)((Function1)new Function1<HeadersBuilder, Unit>(this){
                    final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HeadersBuilder $this$headers) {
                        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                        String string = VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getJbaUserId();
                        if (string == null) {
                            string = VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getAnonymousToken();
                        }
                        $this$headers.append("uid", string);
                    }
                }));
                builder$iv$iv$iv = var10_17;
                $i$f$post = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                ** if (v0 != var27_5) goto lbl61
lbl60:
                // 1 sources

                return var27_5;
lbl61:
                // 1 sources

                ** GOTO lbl76
            }
            case 1: {
                $i$f$post = false;
                $i$f$post = false;
                $i$f$post = false;
                $i$f$request = false;
                this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl76:
                // 2 sources

                $this$body$iv = (HttpResponse)v0;
                $i$f$body = false;
                $i$f$typeInfo = false;
                kType$iv$iv = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(VulnerablePackageDto.class)));
                reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(List.class), (KType)kType$iv$iv), (Continuation)$continuation);
                ** if (v1 != var27_5) goto lbl86
lbl85:
                // 1 sources

                return var27_5;
lbl86:
                // 1 sources

                ** GOTO lbl94
            }
            case 2: {
                $i$f$body = false;
                this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl94:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.security.dto.VulnerablePackageDto>");
                    }
                    dtos = (List)v1;
                    $this$map$iv = dtos;
                    $i$f$map = false;
                    $i$f$typeInfo = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        $this$post_u24lambda_u245$iv /* !! */  = (VulnerablePackageDto)item$iv$iv;
                        var24_32 = destination$iv$iv;
                        $i$a$-map-VulnerabilitiesRepositoryServer$getVulnerabilitiesFromServer$2 = false;
                        var24_32.add(it.toVulnerablePackage());
                    }
                    var3_31 = (List)destination$iv$iv;
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected server error", (Throwable)e);
                    throw new AnalysisException("Fail to check packages on server", AnalysisExceptionScope.USER, null, 4, null);
                }
                return var3_31;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getVulnerabilitiesFromServer(VulnerabilitiesRepositoryServer $this, RequestDto requestData, Continuation $completion) {
        return $this.getVulnerabilitiesFromServer(requestData, (Continuation<? super List<VulnerablePackage>>)$completion);
    }

    public static final /* synthetic */ ClientData access$getClientData$p(VulnerabilitiesRepositoryServer $this) {
        return $this.clientData;
    }
}

