/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.GradleAssertionTestEventConverter;
import org.jetbrains.plugins.gradle.execution.test.runner.events.GradleFileComparisonEventPatcher;
import org.jetbrains.plugins.gradle.execution.test.runner.events.GradleXmlTestEventConverter;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterTestEventProcessor
extends AbstractTestEventProcessor {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.externalSystem.event-processing");

    public AfterTestEventProcessor(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(0);
        }
        ExternalSystemFinishEvent event = (ExternalSystemFinishEvent)testEvent;
        this.process((ExternalSystemFinishEvent<? extends TestOperationDescriptor>)event, false);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException, NumberFormatException {
        if (eventXml == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(1);
        }
        String testId = eventXml.getTestId();
        String testParentId = eventXml.getTestParentId();
        long eventTime = Long.parseLong(eventXml.getEventTestResultEndTime());
        TestOperationDescriptor testDescriptor = GradleXmlTestEventConverter.convertTestDescriptor(eventTime, eventXml);
        OperationResult testResult = GradleXmlTestEventConverter.convertOperationResult(eventXml);
        ExternalSystemFinishEventImpl event = new ExternalSystemFinishEventImpl(testId, testParentId, (OperationDescriptor)testDescriptor, testResult);
        this.process((ExternalSystemFinishEvent<? extends TestOperationDescriptor>)event, true);
    }

    private void process(@NotNull ExternalSystemFinishEvent<? extends TestOperationDescriptor> event, boolean isXml) {
        GradleFileComparisonEventPatcher patcher;
        ExternalSystemFinishEvent<? extends TestOperationDescriptor> patchedEvent;
        if (event == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(2);
        }
        if ((patchedEvent = (patcher = this.getExecutionConsole().getFileComparisonEventPatcher()).patchTestFinishEvent(event, isXml)) == null) {
            LOG.info("Skipped event because it is incomplete: " + event);
            return;
        }
        this.process(patchedEvent);
    }

    private void process(@NotNull ExternalSystemFinishEvent<? extends TestOperationDescriptor> event) {
        if (event == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(3);
        }
        String testId = event.getEventId();
        OperationResult testResult = event.getOperationResult();
        long startTime = testResult.getStartTime();
        long endTime = testResult.getEndTime();
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            LOG.error("Cannot find test proxy for: " + testId);
            return;
        }
        testProxy.setDuration(endTime - startTime);
        if (testResult instanceof SuccessResult) {
            testProxy.setFinished();
            this.getResultsViewer().onTestFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestFinished(testProxy);
        } else if (testResult instanceof SkippedResult) {
            testProxy.setTestIgnored(null, null);
            this.getResultsViewer().onTestIgnored(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestIgnored(testProxy);
            this.getResultsViewer().onTestFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestFinished(testProxy);
        } else if (testResult instanceof FailureResult) {
            FailureResult failureResult = (FailureResult)testResult;
            for (Failure failure : failureResult.getFailures()) {
                AfterTestEventProcessor.processFailureResult(testProxy, failure);
            }
            this.getResultsViewer().onTestFailed(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestFailed(testProxy);
            this.getResultsViewer().onTestFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestFinished(testProxy);
        } else {
            LOG.warn("Undefined test result: " + testResult.getClass().getName());
            this.getResultsViewer().onTestFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onTestFinished(testProxy);
        }
    }

    private static void processFailureResult(@NotNull SMTestProxy testProxy, @NotNull Failure failure) {
        if (testProxy == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(4);
        }
        if (failure == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(5);
        }
        if (failure instanceof TestFailure) {
            TestFailure testFailure = (TestFailure)failure;
            AfterTestEventProcessor.processTestFailureResult(testProxy, testFailure);
        } else {
            LOG.warn("Undefined test failure type: " + failure.getClass().getName());
            String message = (String)ObjectUtils.doIfNotNull((Object)failure, it -> it.getMessage());
            String description = (String)ObjectUtils.doIfNotNull((Object)failure, it -> it.getDescription());
            testProxy.setTestFailed(message, description, true);
        }
        for (Failure cause : failure.getCauses()) {
            AfterTestEventProcessor.processFailureResult(testProxy, cause);
        }
    }

    private static void processTestFailureResult(@NotNull SMTestProxy testProxy, @NotNull TestFailure failure) {
        if (testProxy == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(6);
        }
        if (failure == null) {
            AfterTestEventProcessor.$$$reportNull$$$0(7);
        }
        TestFailure convertedFailure = GradleAssertionTestEventConverter.convertTestFailure(failure);
        String message = convertedFailure.getMessage();
        String stackTrace = convertedFailure.getStackTrace();
        if (convertedFailure instanceof TestAssertionFailure) {
            TestAssertionFailure assertionFailure = (TestAssertionFailure)convertedFailure;
            String actualText = assertionFailure.getActualText();
            String expectedText = assertionFailure.getExpectedText();
            String actualFile = assertionFailure.getActualFile();
            String expectedFile = assertionFailure.getExpectedFile();
            testProxy.setTestComparisonFailed(message, stackTrace, actualText, expectedText, actualFile, expectedFile, true);
        } else {
            testProxy.setTestFailed(message, stackTrace, failure.isTestError());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testEvent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AfterTestEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processFailureResult";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processTestFailureResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

