/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.settings.pandoc.PandocExecutableDetector;
import org.intellij.plugins.markdown.settings.pandoc.PandocSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownDocxExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "exportFile", "", "project", "Lcom/intellij/openapi/project/Project;", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "validate", "file", "Companion", "MarkdownExportDocxTask", "intellij.markdown"})
public final class MarkdownDocxExportProvider
implements MarkdownExportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MarkdownFileActionFormat format = new MarkdownFileActionFormat("Microsoft Word", "docx");

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        new MarkdownExportDocxTask(project, mdFile, outputFile).queue();
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = PandocSettings.Companion.getInstance(project).getPathToPandoc();
        if (string == null) {
            string = PandocExecutableDetector.INSTANCE.detect(project);
        }
        String pandoc = string;
        return pandoc == null ? MarkdownBundle.message("markdown.settings.pandoc.executable.run.in.safe.mode", new Object[0]) : (((CharSequence)pandoc).length() == 0 ? MarkdownBundle.message("markdown.export.to.docx.failure.msg", new Object[0]) : null);
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        return Companion.getFormat();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownDocxExportProvider$Companion;", "", "()V", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownDocxExportProvider$MarkdownExportDocxTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownDocxExportProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "output", "Lcom/intellij/execution/process/ProcessOutput;", "getConvertMdToDocxCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "srcFile", "targetFile", "refFile", "onSuccess", "", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.markdown"})
    private final class MarkdownExportDocxTask
    extends Task.Modal {
        @NotNull
        private final VirtualFile mdFile;
        @NotNull
        private final String outputFile;
        private ProcessOutput output;

        public MarkdownExportDocxTask(@NotNull Project project, @NotNull VirtualFile mdFile, String outputFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Object[] objectArray = new Object[]{MarkdownDocxExportProvider.this.getFormatDescription().getFormatName()};
            super(project, MarkdownBundle.message("markdown.export.task", objectArray), true);
            this.mdFile = mdFile;
            this.outputFile = outputFile;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            String[] stringArray = new String[]{this.mdFile.getParent().getPath(), this.mdFile.getNameWithoutExtension() + "." + MarkdownDocxExportProvider.this.getFormatDescription().getExtension()};
            String string = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String refDocx = string;
            GeneralCommandLine cmd = this.getConvertMdToDocxCommandLine(this.mdFile, this.outputFile, refDocx);
            this.output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
        }

        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, this.getProject(), "markdown.export.failed", null, "[" + this.mdFile.getName() + "] " + error.getLocalizedMessage(), 4, null);
        }

        public void onSuccess() {
            ProcessOutput processOutput = this.output;
            if (processOutput == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                processOutput = null;
            }
            if (processOutput.getStderrLines().isEmpty()) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string = this.mdFile.getParent().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                MarkdownImportExportUtils.INSTANCE.refreshProjectDirectory(project, string);
                Project project2 = this.getProject();
                Object[] objectArray = new Object[]{this.mdFile.getName()};
                String string2 = MarkdownBundle.message("markdown.export.success.msg", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                MarkdownNotifications.showInfo$default(MarkdownNotifications.INSTANCE, project2, "markdown.export.success", null, string2, 4, null);
            } else {
                Project project = this.getProject();
                String string = this.mdFile.getName();
                ProcessOutput processOutput2 = this.output;
                if (processOutput2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    processOutput2 = null;
                }
                List list2 = processOutput2.getStderrLines();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStderrLines(...)");
                MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, project, "markdown.export.failed", null, "[" + string + "] " + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), 4, null);
            }
        }

        private final GeneralCommandLine getConvertMdToDocxCommandLine(VirtualFile srcFile, String targetFile, String refFile) {
            String string = PandocSettings.Companion.getInstance(this.getProject()).getPathToPandoc();
            if (string == null) {
                string = "pandoc";
            }
            String pandoc = string;
            Object[] objectArray = new String[8];
            objectArray[0] = pandoc;
            Intrinsics.checkNotNullExpressionValue((Object)srcFile.getPath(), (String)"getPath(...)");
            objectArray[2] = "-f";
            String string2 = MarkdownFileType.INSTANCE.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(locale), (String)"toLowerCase(...)");
            objectArray[4] = "-t";
            objectArray[5] = MarkdownDocxExportProvider.this.getFormatDescription().getExtension();
            objectArray[6] = "-o";
            objectArray[7] = targetFile;
            List commandLine = CollectionsKt.mutableListOf((Object[])objectArray);
            if (FileUtil.exists((String)refFile)) {
                commandLine.add("--reference-doc=" + refFile);
            }
            return new GeneralCommandLine(commandLine);
        }
    }
}

