/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.projectTree;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.projectTree.MarkdownFileNode;
import org.intellij.plugins.markdown.ui.projectTree.MarkdownViewNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J,\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J:\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownTreeStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createMarkdownViewNode", "Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownViewNode;", "markdownFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "children", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "findMarkdownFileNodeChildren", "isDocumentsGroupingEnabled", "", "file", "fileName", "", "modify", "parent", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownTreeStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownTreeStructureProvider.kt\norg/intellij/plugins/markdown/ui/projectTree/MarkdownTreeStructureProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1#2:85\n1603#3,9:75\n1855#3:84\n1856#3:86\n1612#3:87\n*S KotlinDebug\n*F\n+ 1 MarkdownTreeStructureProvider.kt\norg/intellij/plugins/markdown/ui/projectTree/MarkdownTreeStructureProvider\n*L\n59#1:85\n59#1:75,9\n59#1:84\n59#1:86\n59#1:87\n*E\n"})
public final class MarkdownTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final List<String> extensionsToFold;

    public MarkdownTreeStructureProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, @Nullable ViewSettings settings) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            Iterable iterable = children2;
            for (Object t : iterable) {
                AbstractTreeNode it = (AbstractTreeNode)t;
                boolean bl = false;
                if (!(it.getValue() instanceof MarkdownFile)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        if (v0 == null) {
            return children2;
        }
        List result2 = new ArrayList();
        List childrenToRemove = new ArrayList();
        for (AbstractTreeNode abstractTreeNode : children2) {
            VirtualFile childVirtualFile;
            MarkdownFile childValue;
            Object bl = abstractTreeNode.getValue();
            MarkdownFile markdownFile = childValue = bl instanceof MarkdownFile ? (MarkdownFile)bl : null;
            Object object = childVirtualFile = markdownFile != null ? markdownFile.getVirtualFile() : null;
            if (childVirtualFile != null && !(parent.getValue() instanceof MarkdownFileNode)) {
                Collection<AbstractTreeNode<?>> markdownChildren = this.findMarkdownFileNodeChildren(childVirtualFile, children2);
                if (markdownChildren.size() <= 1) {
                    result2.add(abstractTreeNode);
                    continue;
                }
                result2.add(this.createMarkdownViewNode(childVirtualFile, markdownChildren, settings));
                childrenToRemove.addAll(markdownChildren);
                continue;
            }
            result2.add(abstractTreeNode);
        }
        result2.removeAll(childrenToRemove);
        return result2;
    }

    private final Collection<AbstractTreeNode<?>> findMarkdownFileNodeChildren(VirtualFile markdownFile, Collection<AbstractTreeNode<?>> children2) {
        String string = markdownFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String fileName = string;
        return SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)children2), (Function1)new Function1<AbstractTreeNode<?>, Boolean>(this, fileName){
            final /* synthetic */ MarkdownTreeStructureProvider this$0;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$fileName = $fileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AbstractTreeNode<?> node) {
                boolean bl;
                VirtualFile file;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Object object = node.getValue();
                PsiFile psiFile = object instanceof PsiFile ? (PsiFile)object : null;
                VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    object = this.this$0;
                    String string = this.$fileName;
                    VirtualFile it = virtualFile2;
                    boolean bl2 = false;
                    bl = MarkdownTreeStructureProvider.access$isDocumentsGroupingEnabled((MarkdownTreeStructureProvider)object, it, string);
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final MarkdownViewNode createMarkdownViewNode(VirtualFile markdownFile, Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = children2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getValue();
            if ((object instanceof PsiFile ? (PsiFile)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodeChildren = (List)destination$iv$iv;
        String string = markdownFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        MarkdownFileNode markdownNode = new MarkdownFileNode(string, nodeChildren);
        return new MarkdownViewNode(this.project, markdownNode, settings, children2);
    }

    private final boolean isDocumentsGroupingEnabled(VirtualFile file, String fileName) {
        String string;
        Iterable iterable = extensionsToFold;
        String string2 = file.getExtension();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return CollectionsKt.contains((Iterable)iterable, (Object)string) && Intrinsics.areEqual((Object)file.getNameWithoutExtension(), (Object)fileName) && MarkdownSettings.Companion.getInstance(this.project).isFileGroupingEnabled();
    }

    public static final /* synthetic */ boolean access$isDocumentsGroupingEnabled(MarkdownTreeStructureProvider $this, VirtualFile file, String fileName) {
        return $this.isDocumentsGroupingEnabled(file, fileName);
    }

    static {
        Object[] objectArray = new String[]{"pdf", "docx", "html", "md"};
        extensionsToFold = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownTreeStructureProvider$Companion;", "", "()V", "extensionsToFold", "", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

