/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.inspections.AssignMnemonicFix;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateMnemonicInspection
extends BaseFormInspection {
    private static final ThreadLocal<HashMap<IRootContainer, MnemonicMap>> myContainerMnemonicMap = ThreadLocal.withInitial(HashMap::new);

    public DuplicateMnemonicInspection() {
        super("DuplicateMnemonic");
    }

    @Override
    public void startCheckForm(IRootContainer radRootContainer) {
        myContainerMnemonicMap.get().put(radRootContainer, new MnemonicMap());
    }

    @Override
    public void doneCheckForm(IRootContainer rootContainer) {
        myContainerMnemonicMap.get().remove(rootContainer);
    }

    @Override
    protected void checkComponentProperties(Module module2, @NotNull IComponent component, FormErrorCollector collector) {
        SupportCode.TextWithMnemonic twm;
        if (component == null) {
            DuplicateMnemonicInspection.$$$reportNull$$$0(0);
        }
        if ((twm = DuplicateMnemonicInspection.getTextWithMnemonic(module2, component)) != null) {
            this.checkTextWithMnemonic(module2, component, twm, collector);
        }
    }

    @Nullable
    static SupportCode.TextWithMnemonic getTextWithMnemonic(Module module2, IComponent component) {
        Object propValue;
        if (module2.isDisposed()) {
            return null;
        }
        IProperty prop = FormInspectionUtil.findProperty(component, "text");
        if (prop != null && (propValue = prop.getPropertyValue(component)) instanceof StringDescriptor) {
            StringDescriptor descriptor = (StringDescriptor)propValue;
            String value = component instanceof RadComponent ? StringDescriptorManager.getInstance(module2).resolve((RadComponent)component, descriptor) : StringDescriptorManager.getInstance(module2).resolve(descriptor, null);
            SupportCode.TextWithMnemonic twm = SupportCode.parseText((String)value);
            if (twm.myMnemonicIndex >= 0 && (FormInspectionUtil.isComponentClass(module2, component, JLabel.class) || FormInspectionUtil.isComponentClass(module2, component, AbstractButton.class))) {
                return twm;
            }
        }
        return null;
    }

    private void checkTextWithMnemonic(Module module2, @NotNull IComponent component, SupportCode.TextWithMnemonic twm, FormErrorCollector collector) {
        MnemonicKey key;
        if (component == null) {
            DuplicateMnemonicInspection.$$$reportNull$$$0(1);
        }
        IRootContainer root = FormEditingUtil.getRoot(component);
        MnemonicMap map = myContainerMnemonicMap.get().get(root);
        if (map.containsKey(key = DuplicateMnemonicInspection.buildMnemonicKey(twm, component))) {
            IProperty prop = FormInspectionUtil.findProperty(component, "text");
            IComponent oldComponent = (IComponent)map.get(key);
            collector.addError(this.getID(), component, prop, UIDesignerBundle.message("inspection.duplicate.mnemonics.message", FormInspectionUtil.getText(module2, oldComponent), FormInspectionUtil.getText(module2, component)), (editor, component1) -> new AssignMnemonicFix(editor, component1, UIDesignerBundle.message("inspection.duplicate.mnemonics.quickfix", new Object[0])));
        } else {
            map.put(key, component);
        }
    }

    private static MnemonicKey buildMnemonicKey(SupportCode.TextWithMnemonic twm, IComponent component) {
        ArrayList<Integer> exclusiveContainerStack = new ArrayList<Integer>();
        IComponent child = component;
        for (IContainer parent = component.getParentContainer(); parent != null; parent = parent.getParentContainer()) {
            if (parent.areChildrenExclusive()) {
                exclusiveContainerStack.add(0, parent.indexOfComponent(child));
            }
            child = parent;
        }
        return new MnemonicKey(twm.getMnemonicChar(), exclusiveContainerStack);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/uiDesigner/inspections/DuplicateMnemonicInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkComponentProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTextWithMnemonic";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MnemonicMap
    extends HashMap<MnemonicKey, IComponent> {
        private MnemonicMap() {
        }
    }

    private static class MnemonicKey {
        private final char myMnemonicChar;
        private final List<Integer> myExclusiveContainerStack;

        MnemonicKey(char mnemonicChar, List<Integer> exclusiveContainerStack) {
            this.myMnemonicChar = mnemonicChar;
            this.myExclusiveContainerStack = exclusiveContainerStack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MnemonicKey that = (MnemonicKey)o;
            if (this.myMnemonicChar != that.myMnemonicChar) {
                return false;
            }
            return this.myExclusiveContainerStack.equals(that.myExclusiveContainerStack);
        }

        public int hashCode() {
            int result = this.myMnemonicChar;
            result = 31 * result + this.myExclusiveContainerStack.hashCode();
            return result;
        }
    }
}

