/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormEditorErrorCollector
extends FormErrorCollector {
    private final GuiEditor myEditor;
    @NotNull
    private final RadComponent myComponent;
    private List<ErrorInfo> myResults;
    private final InspectionProfile myProfile;
    private final PsiFile myFormPsiFile;

    FormEditorErrorCollector(GuiEditor editor, @NotNull RadComponent component) {
        if (component == null) {
            FormEditorErrorCollector.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myComponent = component;
        this.myFormPsiFile = PsiManager.getInstance((Project)editor.getProject()).findFile(editor.getFile());
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)editor.getProject());
        this.myProfile = profileManager.getCurrentProfile();
    }

    public ErrorInfo[] result() {
        return this.myResults == null ? null : this.myResults.toArray(ErrorInfo.EMPTY_ARRAY);
    }

    @Override
    public void addError(@NotNull String inspectionId, @NotNull IComponent component, @Nullable IProperty prop, @NotNull String errorMessage, EditorQuickFixProvider ... editorQuickFixProviders) {
        if (inspectionId == null) {
            FormEditorErrorCollector.$$$reportNull$$$0(1);
        }
        if (component == null) {
            FormEditorErrorCollector.$$$reportNull$$$0(2);
        }
        if (errorMessage == null) {
            FormEditorErrorCollector.$$$reportNull$$$0(3);
        }
        if (editorQuickFixProviders == null) {
            FormEditorErrorCollector.$$$reportNull$$$0(4);
        }
        if (this.myResults == null) {
            this.myResults = new ArrayList<ErrorInfo>();
        }
        ArrayList<QuickFix> quickFixes = new ArrayList<QuickFix>();
        for (EditorQuickFixProvider provider : editorQuickFixProviders) {
            if (provider == null) continue;
            quickFixes.add(provider.createQuickFix(this.myEditor, this.myComponent));
        }
        ErrorInfo errorInfo = new ErrorInfo(this.myComponent, prop == null ? null : prop.getName(), errorMessage, this.myProfile.getErrorLevel(HighlightDisplayKey.find((String)inspectionId), (PsiElement)this.myFormPsiFile), quickFixes.toArray(QuickFix.EMPTY_ARRAY));
        errorInfo.setInspectionId(inspectionId);
        this.myResults.add(errorInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorQuickFixProviders";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/inspections/FormEditorErrorCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

