/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public final class IntEnumEditor
extends PropertyEditor<Integer> {
    private JComboBox myCbx;
    private final Pair[] myPairs;

    public IntEnumEditor(Pair @NotNull [] pairs) {
        if (pairs == null) {
            IntEnumEditor.$$$reportNull$$$0(0);
        }
        this.myPairs = pairs;
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.getCbx());
        SwingUtilities.updateComponentTreeUI((JComponent)((Object)this.getCbx().getRenderer()));
    }

    @Override
    public Integer getValue() throws Exception {
        Object selectedItem = this.getCbx().getSelectedItem();
        Pair pair = (Pair)selectedItem;
        return pair.myValue;
    }

    @Override
    public JComponent getComponent(RadComponent ignored, Integer value, InplaceContext inplaceContext) {
        if (value == null) {
            this.getCbx().setSelectedItem(null);
            return this.getCbx();
        }
        ComboBoxModel model = this.getCbx().getModel();
        for (int i = model.getSize() - 1; i >= 0; --i) {
            Pair pair = (Pair)model.getElementAt(i);
            if (pair.myValue != value) continue;
            this.getCbx().setSelectedIndex(i);
            return this.getCbx();
        }
        throw new IllegalArgumentException("unknown value: " + value);
    }

    private JComboBox getCbx() {
        if (this.myCbx == null) {
            this.myCbx = new JComboBox<Pair>(this.myPairs);
            this.myCbx.setBorder(BorderFactory.createEmptyBorder());
            this.myCbx.addPopupMenuListener(new MyPopupMenuListener());
        }
        return this.myCbx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/uiDesigner/propertyInspector/editors/IntEnumEditor", "<init>"));
    }

    public static final class Pair {
        public final int myValue;
        public final String myText;

        public Pair(int value, @NotNull String text) {
            if (text == null) {
                Pair.$$$reportNull$$$0(0);
            }
            this.myValue = value;
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/uiDesigner/propertyInspector/editors/IntEnumEditor$Pair", "<init>"));
        }
    }

    private final class MyPopupMenuListener
    implements PopupMenuListener {
        private boolean myCancelled;

        private MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.myCancelled = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!this.myCancelled) {
                IntEnumEditor.this.fireValueCommitted(true, false);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.myCancelled = true;
        }
    }
}

