/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadBorderLayoutManager
extends RadLayoutManager {
    @Override
    public String getName() {
        return "BorderLayout";
    }

    @Override
    public LayoutManager createLayout() {
        return new BorderLayout();
    }

    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        BorderLayout layout = (BorderLayout)radContainer.getLayout();
        writer.addAttribute("hgap", layout.getHgap());
        writer.addAttribute("vgap", layout.getVgap());
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        if (component.getCustomLayoutConstraints() == null) {
            if (container.getDelegee().getComponentCount() == 0) {
                component.setCustomLayoutConstraints("Center");
            } else {
                throw new RuntimeException("can't add component without constraints to container with BorderLayout");
            }
        }
        container.getDelegee().add(component.getDelegee(), component.getCustomLayoutConstraints(), index);
    }

    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        writer.addAttribute("border-constraint", (String)child.getCustomLayoutConstraints());
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, Point location) {
        return new MyDropLocation(container, RadBorderLayoutManager.getQuadrantAt(container, location));
    }

    private static String getQuadrantAt(RadContainer container, Point location) {
        if (location == null) {
            return "Center";
        }
        Dimension size = container.getDelegee().getSize();
        if (location.x < size.width / 3) {
            return "West";
        }
        if (location.y < size.height / 3) {
            return "North";
        }
        if (location.x > size.width * 2 / 3) {
            return "East";
        }
        if (location.y > size.height * 2 / 3) {
            return "South";
        }
        return "Center";
    }

    @Override
    public void changeContainerLayout(RadContainer container) throws IncorrectOperationException {
        ArrayList<RadComponent> componentsInBorder = new ArrayList<RadComponent>();
        boolean borderHorz = true;
        if (container.getComponentCount() == 1) {
            componentsInBorder.add(container.getComponent(0));
        } else if (container.getLayoutManager().isIndexed()) {
            for (RadComponent c : container.getComponents()) {
                if (c instanceof RadHSpacer || c instanceof RadVSpacer) continue;
                componentsInBorder.add(c);
            }
        } else if (container.getLayoutManager().isGrid()) {
            if (container.getGridRowCount() == 1) {
                RadBorderLayoutManager.copyGridLine(container, componentsInBorder, true);
            } else if (container.getGridColumnCount() == 1) {
                RadBorderLayoutManager.copyGridLine(container, componentsInBorder, false);
                borderHorz = false;
            }
        }
        if (container.getComponentCount() > 0 && componentsInBorder.isEmpty() || componentsInBorder.size() > 3) {
            throw new IncorrectOperationException("Component layout is too complex to convert to BorderLayout");
        }
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            container.removeComponent(container.getComponent(i));
        }
        super.changeContainerLayout(container);
        if (componentsInBorder.size() == 1) {
            ((RadComponent)componentsInBorder.get(0)).setCustomLayoutConstraints("Center");
        } else if (componentsInBorder.size() > 1) {
            ((RadComponent)componentsInBorder.get(0)).setCustomLayoutConstraints(borderHorz ? "West" : "North");
            ((RadComponent)componentsInBorder.get(1)).setCustomLayoutConstraints("Center");
            if (componentsInBorder.size() > 2) {
                ((RadComponent)componentsInBorder.get(2)).setCustomLayoutConstraints(borderHorz ? "East" : "South");
            }
        }
        for (RadComponent c : componentsInBorder) {
            container.addComponent(c);
        }
    }

    private static void copyGridLine(RadContainer container, ArrayList<? super RadComponent> componentsInBorder, boolean isRow) {
        int cell = 0;
        while (cell < container.getGridCellCount(!isRow)) {
            RadComponent c = container.getComponentAtGrid(isRow, 0, cell);
            if (c == null) {
                ++cell;
                continue;
            }
            if (!(c instanceof RadHSpacer) && !(c instanceof RadVSpacer)) {
                componentsInBorder.add(c);
            }
            cell += c.getConstraints().getSpan(!isRow);
        }
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return new Property[]{HGapProperty.getInstance(project), VGapProperty.getInstance(project)};
    }

    @Override
    public Property[] getComponentProperties(Project project, RadComponent component) {
        return new Property[]{BorderSideProperty.INSTANCE};
    }

    @Override
    public boolean canMoveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        if (rowSpanDelta != 0 || colSpanDelta != 0) {
            return false;
        }
        String side = (String)c.getCustomLayoutConstraints();
        String adjSide = RadBorderLayoutManager.getAdjacentSide(side, rowDelta, colDelta);
        return adjSide != null && c.getParent().findComponentWithConstraints(adjSide) == null;
    }

    @Override
    public void moveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        String side = (String)c.getCustomLayoutConstraints();
        String adjSide = RadBorderLayoutManager.getAdjacentSide(side, rowDelta, colDelta);
        if (adjSide != null) {
            c.changeCustomLayoutConstraints(adjSide);
        }
    }

    @Nullable
    private static String getAdjacentSide(String side, int rowDelta, int colDelta) {
        if (rowDelta == -1 && colDelta == 0) {
            return RadBorderLayoutManager.getAdjacentSide(side, "North", "South");
        }
        if (rowDelta == 1 && colDelta == 0) {
            return RadBorderLayoutManager.getAdjacentSide(side, "South", "North");
        }
        if (rowDelta == 0 && colDelta == -1) {
            return RadBorderLayoutManager.getAdjacentSide(side, "West", "East");
        }
        if (rowDelta == 0 && colDelta == 1) {
            return RadBorderLayoutManager.getAdjacentSide(side, "East", "West");
        }
        return null;
    }

    @Nullable
    private static String getAdjacentSide(String side, String toEdge, String fromEdge) {
        if (side.equals(toEdge)) {
            return null;
        }
        if (side.equals(fromEdge)) {
            return "Center";
        }
        return toEdge;
    }

    private static class MyDropLocation
    implements ComponentDropLocation {
        private final RadContainer myContainer;
        private final String myQuadrant;

        MyDropLocation(RadContainer container, String quadrant) {
            this.myQuadrant = quadrant;
            this.myContainer = container;
        }

        @Override
        public RadContainer getContainer() {
            return this.myContainer;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1 && ((BorderLayout)this.myContainer.getLayout()).getLayoutComponent(this.myQuadrant) == null;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            Dimension initialSize = dragObject.getInitialSize(this.myContainer);
            feedbackLayer.putFeedback(this.myContainer.getDelegee(), this.getFeedbackRect(this.myQuadrant, initialSize), this.myContainer.getDisplayName() + " (" + StringUtil.toLowerCase((String)this.myQuadrant) + ")");
        }

        private Rectangle getFeedbackRect(String quadrant, Dimension initialSize) {
            int initialHeight;
            Dimension size = this.myContainer.getDelegee().getSize();
            int initialWidth = initialSize.width > 0 && initialSize.width < size.width ? initialSize.width : size.width / 3;
            int n = initialHeight = initialSize.height > 0 && initialSize.height < size.height ? initialSize.height : size.height / 3;
            if (quadrant.equals("West")) {
                int deltaN = this.getHeightAtConstraint("North");
                int deltaS = this.getHeightAtConstraint("South");
                return new Rectangle(0, deltaN, initialWidth, size.height - deltaN - deltaS);
            }
            if (quadrant.equals("North")) {
                return new Rectangle(0, 0, size.width, initialHeight);
            }
            if (quadrant.equals("East")) {
                int deltaN = this.getHeightAtConstraint("North");
                int deltaS = this.getHeightAtConstraint("South");
                return new Rectangle(size.width - initialWidth, deltaN, initialWidth, size.height - deltaN - deltaS);
            }
            if (quadrant.equals("South")) {
                return new Rectangle(0, size.height - initialHeight, size.width, initialHeight);
            }
            return new Rectangle(size.width / 3, size.height / 3, size.width / 3, size.height / 3);
        }

        private int getHeightAtConstraint(String constraint) {
            BorderLayout layout = (BorderLayout)this.myContainer.getLayout();
            Component c = layout.getLayoutComponent(this.myContainer.getDelegee(), constraint);
            if (c == null) {
                return 0;
            }
            return c.getBounds().height;
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            components[0].setCustomLayoutConstraints(this.myQuadrant);
            this.myContainer.addComponent(components[0]);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            String side;
            switch (direction) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LEFT: {
                    String string = RadBorderLayoutManager.getAdjacentSide(this.myQuadrant, 0, -1);
                    break;
                }
                case UP: {
                    String string = RadBorderLayoutManager.getAdjacentSide(this.myQuadrant, -1, 0);
                    break;
                }
                case RIGHT: {
                    String string = RadBorderLayoutManager.getAdjacentSide(this.myQuadrant, 0, 1);
                    break;
                }
                case DOWN: {
                    String string = side = RadBorderLayoutManager.getAdjacentSide(this.myQuadrant, 1, 0);
                }
            }
            if (side != null) {
                return new MyDropLocation(this.myContainer, side);
            }
            return null;
        }
    }

    private static class BorderSideProperty
    extends Property<RadComponent, String> {
        private LabelPropertyRenderer<String> myRenderer = null;
        private BorderSideEditor myEditor = null;
        public static final BorderSideProperty INSTANCE = new BorderSideProperty();

        BorderSideProperty() {
            super(null, "Border Side");
        }

        @Override
        public String getValue(RadComponent component) {
            return (String)component.getCustomLayoutConstraints();
        }

        @Override
        protected void setValueImpl(RadComponent component, String value) throws Exception {
            if (!value.equals(component.getCustomLayoutConstraints())) {
                if (component.getParent().findComponentWithConstraints(value) != null) {
                    throw new Exception("There is already another component at location " + value);
                }
                component.changeCustomLayoutConstraints(value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<String> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new LabelPropertyRenderer();
            }
            LabelPropertyRenderer<String> labelPropertyRenderer = this.myRenderer;
            if (labelPropertyRenderer == null) {
                BorderSideProperty.$$$reportNull$$$0(0);
            }
            return labelPropertyRenderer;
        }

        @Override
        public PropertyEditor<String> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new BorderSideEditor();
            }
            return this.myEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadBorderLayoutManager$BorderSideProperty", "getRenderer"));
        }
    }

    private static class BorderSideEditor
    extends ComboBoxPropertyEditor<String> {
        BorderSideEditor() {
            @NlsSafe String[] sides = new String[]{"Center", "North", "South", "West", "East", "First", "Last", "Before", "After"};
            this.myCbx.setModel(new DefaultComboBoxModel<String>(sides));
        }

        @Override
        public JComponent getComponent(RadComponent component, @NlsSafe String value, InplaceContext inplaceContext) {
            this.myCbx.setSelectedItem((Object)value);
            return this.myCbx;
        }
    }
}

