/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.webSymbols.attributes;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.html.webSymbols.HtmlDescriptorUtils;
import com.intellij.html.webSymbols.WebSymbolsFrameworkHtmlSupport;
import com.intellij.html.webSymbols.WebSymbolsHtmlQueryConfigurator;
import com.intellij.html.webSymbols.attributes.WebSymbolAttributeNameCompletionProvider;
import com.intellij.html.webSymbols.attributes.WebSymbolHtmlAttributeInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.completion.AsteriskAwarePrefixMatcher;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.completion.WebSymbolsCompletionProviderBase;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/html/webSymbols/attributes/WebSymbolAttributeNameCompletionProvider;", "Lcom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase;", "Lcom/intellij/psi/xml/XmlAttribute;", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "position", "", "name", "", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "context", "getContext", "Lcom/intellij/psi/PsiElement;", "intellij.xml.impl"})
public final class WebSymbolAttributeNameCompletionProvider
extends WebSymbolsCompletionProviderBase<XmlAttribute> {
    @Override
    @Nullable
    protected XmlAttribute getContext(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttribute.class);
    }

    @Override
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, int position, @NotNull String name, @NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull XmlAttribute context) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlTag xmlTag = context.getParent();
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher().cloneWithPrefix(name);
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet patchedResultSet = completionResultSet;
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Set providedAttributes2 = SequencesKt.toMutableSet((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])xmlAttributeArray), (Function1)addCompletions.providedAttributes.1.INSTANCE));
        Predicate<String> attributesFilter = WebSymbolsFrameworkHtmlSupport.Companion.get(queryExecutor.getFramework()).getAttributeNameCodeCompletionFilter(tag);
        Set filteredOutStandardSymbols2 = SequencesKt.toMutableSet((Sequence)SequencesKt.map(HtmlDescriptorUtils.getStandardHtmlAttributeDescriptors(tag), (Function1)addCompletions.filteredOutStandardSymbols.1.INSTANCE));
        WebSymbolsCompletionProviderBase.Companion.processCompletionQueryResults$default(WebSymbolsCompletionProviderBase.Companion, queryExecutor, patchedResultSet, WebSymbol.Companion.getHTML_ATTRIBUTES(), name, position, context, null, providedAttributes2, (Function1)new Function1<WebSymbolCodeCompletionItem, Boolean>((Set<String>)filteredOutStandardSymbols2, name, attributesFilter){
            final /* synthetic */ Set<String> $filteredOutStandardSymbols;
            final /* synthetic */ String $name;
            final /* synthetic */ Predicate<String> $attributesFilter;
            {
                this.$filteredOutStandardSymbols = $filteredOutStandardSymbols;
                this.$name = $name;
                this.$attributesFilter = $attributesFilter;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull WebSymbolCodeCompletionItem item) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (item.getSymbol() instanceof WebSymbolsHtmlQueryConfigurator.StandardHtmlSymbol && item.getOffset() == 0) {
                    WebSymbol webSymbol = item.getSymbol();
                    if (Intrinsics.areEqual((Object)(webSymbol != null ? webSymbol.getName() : null), (Object)item.getName())) {
                        this.$filteredOutStandardSymbols.remove(item.getName());
                        bl = false;
                        return bl;
                    }
                }
                if (item.getOffset() <= this.$name.length()) {
                    String string2 = this.$name.substring(0, item.getOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    if (this.$attributesFilter.test(string2 + item.getName())) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }, (Function1)new Function1<WebSymbolCodeCompletionItem, Unit>(parameters, patchedResultSet, context, queryExecutor, name){
            final /* synthetic */ CompletionParameters $parameters;
            final /* synthetic */ CompletionResultSet $patchedResultSet;
            final /* synthetic */ XmlAttribute $context;
            final /* synthetic */ WebSymbolsQueryExecutor $queryExecutor;
            final /* synthetic */ String $name;
            {
                this.$parameters = $parameters;
                this.$patchedResultSet = $patchedResultSet;
                this.$context = $context;
                this.$queryExecutor = $queryExecutor;
                this.$name = $name;
                super(1);
            }

            public final void invoke(@NotNull WebSymbolCodeCompletionItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                WebSymbolCodeCompletionItem.addToResult$default(WebSymbolCodeCompletionItem.withInsertHandlerAdded$default(item, (arg_0, arg_1) -> addCompletions.2.invoke$lambda$0(this.$context, this.$queryExecutor, this.$name, item, arg_0, arg_1), null, 2, null), this.$parameters, this.$patchedResultSet, 0.0, 4, null);
            }

            private static final void invoke$lambda$0(XmlAttribute $context, WebSymbolsQueryExecutor $queryExecutor, String $name, WebSymbolCodeCompletionItem $item, InsertionContext insertionContext, LookupElement lookupItem) {
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                Intrinsics.checkNotNullParameter((Object)$queryExecutor, (String)"$queryExecutor");
                Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
                Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
                Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"insertionContext");
                Intrinsics.checkNotNullParameter((Object)lookupItem, (String)"lookupItem");
                WebSymbolsQueryExecutor freshRegistry = WebSymbolsQueryExecutorFactory.Companion.create($context, $queryExecutor.allowResolve());
                String string2 = $name.substring(0, $item.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String fullName = string2 + $item.getName();
                WebSymbol webSymbol = WebSymbolUtils.asSingleSymbol$default(WebSymbolsQueryExecutor.runNameMatchQuery$default(freshRegistry, "html", "attributes", fullName, false, false, false, null, 120, null), false, 1, null);
                if (webSymbol == null) {
                    return;
                }
                WebSymbol match2 = webSymbol;
                PsiFile psiFile = insertionContext.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                WebSymbolHtmlAttributeInfo info = WebSymbolHtmlAttributeInfo.Companion.create(fullName, freshRegistry, match2, (PsiElement)psiFile);
                if (info.acceptsValue() && !info.acceptsNoValue()) {
                    XmlAttributeInsertHandler.INSTANCE.handleInsert(insertionContext, lookupItem);
                }
            }
        }, 64, null);
        providedAttributes2.addAll(filteredOutStandardSymbols2);
        result2.runRemainingContributors(parameters, arg_0 -> WebSymbolAttributeNameCompletionProvider.addCompletions$lambda$0((Function1)new Function1<CompletionResult, Unit>(name, (Set<String>)providedAttributes2, attributesFilter, result2){
            final /* synthetic */ String $name;
            final /* synthetic */ Set<String> $providedAttributes;
            final /* synthetic */ Predicate<String> $attributesFilter;
            final /* synthetic */ CompletionResultSet $result;
            {
                this.$name = $name;
                this.$providedAttributes = $providedAttributes;
                this.$attributesFilter = $attributesFilter;
                this.$result = $result;
                super(1);
            }

            public final void invoke(CompletionResult toPass) {
                String string2 = toPass.getPrefixMatcher().getPrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPrefix(...)");
                String attrName = StringsKt.removeSuffix((String)this.$name, (CharSequence)string2) + toPass.getLookupElement().getLookupString();
                if (!this.$providedAttributes.contains(attrName) && this.$attributesFilter.test(attrName)) {
                    LookupElement element = toPass.getLookupElement();
                    PrefixMatcher prefixMatcher = toPass.getPrefixMatcher();
                    Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
                    this.$result.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher)).withRelevanceSorter(toPass.getSorter()).addElement(element);
                }
            }
        }, arg_0));
    }

    private static final void addCompletions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

