/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.json.JsonBundle;
import com.intellij.json.intentions.JsonSortPropertiesIntention;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00130\u0007\u00a2\u0006\u000e\b\b\u0012\n\b\t\u0012\u0006\b\n0\n8\u000bH\u0016J\u0019\u0010\f\u001a\u00130\u0007\u00a2\u0006\u000e\b\b\u0012\n\b\t\u0012\u0006\b\n0\n8\u000bH\u0016J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "reformat", "obj", "Lcom/intellij/json/psi/JsonObject;", "startInWriteAction", "Session", "intellij.json"})
public class JsonSortPropertiesIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction,
LightEditCompatible,
DumbAware {
    @NotNull
    public String getText() {
        String string2 = JsonBundle.message("json.intention.sort.properties", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = JsonBundle.message("json.intention.sort.properties", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new Session(editor, element).hasUnsortedObjects();
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)JsonBundle.message("file.is.readonly", new Object[0]), (String)JsonBundle.message("cannot.sort.properties", new Object[0]), null);
            return;
        }
        Session session = new Session(editor, element);
        if (session.getRootObj() != null) {
            session.sort();
            this.reformat(project2, editor, session.getRootObj());
        }
    }

    private final void reformat(Project project2, Editor editor, JsonObject obj) {
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)obj);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        JsonObject jsonObject = (JsonObject)pointer.getElement();
        if (jsonObject == null) {
            return;
        }
        JsonObject element = jsonObject;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformatText(element.getContainingFile(), (Collection)SetsKt.setOf((Object)element.getTextRange()));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002J&\u0010\u001b\u001a\u00020\u00192\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention$Session;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "contextElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)V", "objects", "", "Lcom/intellij/json/psi/JsonObject;", "rootObj", "getRootObj", "()Lcom/intellij/json/psi/JsonObject;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "advance", "", "properties", "", "Lcom/intellij/json/psi/JsonProperty;", "size", "cycleStart", "item", "collectObjects", "cycleSortProperties", "", "obj", "exchange", "", "pos", "findRootObject", "hasUnsortedObjects", "", "isSorted", "sort", "intellij.json"})
    @SourceDebugExtension(value={"SMAP\nJsonSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$Session\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,156:1\n800#2,11:157\n1747#2,3:168\n1855#2,2:171\n1224#3,2:173\n*S KotlinDebug\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$Session\n*L\n86#1:157,11\n98#1:168,3\n101#1:171,2\n112#1:173,2\n*E\n"})
    private static final class Session {
        @NotNull
        private final PsiElement contextElement;
        @NotNull
        private final SelectionModel selectionModel;
        @Nullable
        private final JsonObject rootObj;
        @NotNull
        private final Set<JsonObject> objects;

        public Session(@NotNull Editor editor, @NotNull PsiElement contextElement) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
            this.contextElement = contextElement;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            this.selectionModel = selectionModel;
            this.rootObj = this.findRootObject();
            this.objects = this.rootObj != null ? this.collectObjects(this.rootObj) : SetsKt.emptySet();
        }

        @Nullable
        public final JsonObject getRootObj() {
            return this.rootObj;
        }

        private final Set<JsonObject> collectObjects(JsonObject rootObj) {
            Set result2 = new LinkedHashSet();
            if (this.selectionModel.hasSelection()) {
                new JsonRecursiveElementVisitor(this, result2){
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ Set<JsonObject> $result;
                    {
                        this.this$0 = $receiver;
                        this.$result = $result;
                    }

                    public void visitObject(@NotNull JsonObject o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        super.visitObject(o);
                        TextRange textRange = o.getTextRange();
                        boolean bl = textRange != null ? textRange.intersects(Session.access$getSelectionModel$p(this.this$0).getSelectionStart(), Session.access$getSelectionModel$p(this.this$0).getSelectionEnd()) : false;
                        if (bl) {
                            this.$result.add(o);
                        }
                    }
                }.visitObject(rootObj);
            }
            result2.add(rootObj);
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final JsonObject findRootObject() {
            JsonObject initObj;
            JsonObject jsonObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.contextElement, JsonObject.class);
            if (jsonObject == null) {
                Session $this$findRootObject_u24lambda_u240 = this;
                boolean bl = false;
                PsiFile psiFile = $this$findRootObject_u24lambda_u240.contextElement.getContainingFile();
                JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
                if (jsonFile == null) {
                    jsonObject = null;
                } else {
                    void $this$filterIsInstanceTo$iv$iv;
                    JsonFile jsonFile2 = jsonFile;
                    List<JsonValue> list2 = jsonFile2.getAllTopLevelValues();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllTopLevelValues(...)");
                    Iterable $this$filterIsInstance$iv = list2;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsonObject)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (JsonObject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                }
            }
            if ((initObj = jsonObject) == null || !this.selectionModel.hasSelection()) {
                return initObj;
            }
            JsonObject obj = initObj;
            while (true) {
                TextRange textRange = obj.getTextRange();
                boolean bl = textRange != null ? !textRange.containsRange(this.selectionModel.getSelectionStart(), this.selectionModel.getSelectionEnd()) : false;
                if (!bl || (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)obj, JsonObject.class) == null) break;
            }
            return obj;
        }

        public final boolean hasUnsortedObjects() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.objects;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JsonObject it = (JsonObject)element$iv;
                        boolean bl2 = false;
                        if (!(!this.isSorted(it))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void sort() {
            Iterable $this$forEach$iv = this.objects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject it = (JsonObject)element$iv;
                boolean bl = false;
                if (this.isSorted(it)) continue;
                this.cycleSortProperties(it);
            }
        }

        private final boolean isSorted(JsonObject obj) {
            boolean bl;
            block1: {
                List<JsonProperty> list2 = obj.getPropertyList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getPropertyList(...)");
                Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)isSorted.1.INSTANCE));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    String l = (String)pair.component1();
                    String r = (String)pair.component2();
                    Intrinsics.checkNotNull((Object)r);
                    if (l.compareTo(r) <= 0) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        private final void cycleSortProperties(JsonObject obj) {
            List<JsonProperty> list2 = obj.getPropertyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getPropertyList(...)");
            List<JsonProperty> properties2 = list2;
            int size = properties2.size();
            for (int cycleStart = 0; cycleStart < size; ++cycleStart) {
                JsonProperty item = properties2.get(cycleStart);
                int pos = this.advance(properties2, size, cycleStart, item);
                if (pos == -1) continue;
                if (pos != cycleStart) {
                    this.exchange(properties2, pos, cycleStart);
                }
                while (pos != cycleStart && (pos = this.advance(properties2, size, cycleStart, properties2.get(cycleStart))) != -1) {
                    if (pos == cycleStart) continue;
                    this.exchange(properties2, pos, cycleStart);
                }
            }
        }

        private final int advance(List<? extends JsonProperty> properties2, int size, int cycleStart, JsonProperty item) {
            int pos = cycleStart;
            String string2 = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String itemName = string2;
            for (int i = cycleStart + 1; i < size; ++i) {
                if (properties2.get(i).getName().compareTo(itemName) >= 0) continue;
                ++pos;
            }
            if (pos == cycleStart) {
                return -1;
            }
            while (Intrinsics.areEqual((Object)itemName, (Object)properties2.get(pos).getName())) {
                ++pos;
            }
            return pos;
        }

        private final void exchange(List<JsonProperty> properties2, int pos, int item) {
            JsonProperty propertyAtPos = properties2.get(pos);
            JsonProperty itemProperty = properties2.get(item);
            PsiElement psiElement = propertyAtPos.getParent().addBefore((PsiElement)itemProperty, (PsiElement)propertyAtPos);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            properties2.set(pos, (JsonProperty)psiElement);
            PsiElement psiElement2 = itemProperty.getParent().addBefore((PsiElement)propertyAtPos, (PsiElement)itemProperty);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            properties2.set(item, (JsonProperty)psiElement2);
            propertyAtPos.delete();
            itemProperty.delete();
        }

        public static final /* synthetic */ SelectionModel access$getSelectionModel$p(Session $this) {
            return $this.selectionModel;
        }
    }
}

