/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlRefCountHolder {
    private static final Key<CachedValue<XmlRefCountHolder>> xmlRefCountHolderKey = Key.create((String)"xml ref count holder");
    private static final UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object>(){

        protected CachedValue<XmlRefCountHolder> compute(XmlFile file, Object p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                XmlRefCountHolder holder = new XmlRefCountHolder();
                Language language = file.getViewProvider().getBaseLanguage();
                PsiFile psiFile = file.getViewProvider().getPsi(language);
                assert (psiFile != null);
                psiFile.accept((PsiElementVisitor)new IdGatheringRecursiveVisitor(holder));
                return new CachedValueProvider.Result((Object)holder, new Object[]{file});
            }, false);
        }
    };
    private final Map<String, List<Pair<XmlAttributeValue, Boolean>>> myId2AttributeListMap = new HashMap<String, List<Pair<XmlAttributeValue, Boolean>>>();
    private final Set<XmlAttributeValue> myPossiblyDuplicateIds = new HashSet<XmlAttributeValue>();
    private final List<XmlAttributeValue> myIdReferences = new ArrayList<XmlAttributeValue>();
    private final Set<String> myAdditionallyDeclaredIds = new HashSet<String>();
    private final Set<PsiElement> myDoNotValidateParentsList = new HashSet<PsiElement>();
    private final Set<String> myUsedPrefixes = new HashSet<String>();
    private final Set<String> myUsedNamespaces = new HashSet<String>();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("[\\w_][\\w_.]*:");

    @Nullable
    public static XmlRefCountHolder getRefCountHolder(@NotNull XmlFile file) {
        if (file == null) {
            XmlRefCountHolder.$$$reportNull$$$0(0);
        }
        return (XmlRefCountHolder)((CachedValue)CACHE.get(xmlRefCountHolderKey, (UserDataHolder)file, null)).getValue();
    }

    private XmlRefCountHolder() {
    }

    public boolean isDuplicateIdAttributeValue(@NotNull XmlAttributeValue value) {
        if (value == null) {
            XmlRefCountHolder.$$$reportNull$$$0(1);
        }
        return this.myPossiblyDuplicateIds.contains(value);
    }

    public boolean isValidatable(@Nullable PsiElement element) {
        return !this.myDoNotValidateParentsList.contains(element);
    }

    public boolean hasIdDeclaration(@NotNull String idRef) {
        if (idRef == null) {
            XmlRefCountHolder.$$$reportNull$$$0(2);
        }
        return this.myId2AttributeListMap.get(idRef) != null || this.myAdditionallyDeclaredIds.contains(idRef);
    }

    public boolean isIdReferenceValue(@NotNull XmlAttributeValue value) {
        if (value == null) {
            XmlRefCountHolder.$$$reportNull$$$0(3);
        }
        return this.myIdReferences.contains(value);
    }

    private void registerId(@NotNull String id, @NotNull XmlAttributeValue attributeValue2, boolean soft) {
        List<Pair<XmlAttributeValue, Boolean>> list2;
        if (id == null) {
            XmlRefCountHolder.$$$reportNull$$$0(4);
        }
        if (attributeValue2 == null) {
            XmlRefCountHolder.$$$reportNull$$$0(5);
        }
        if ((list2 = this.myId2AttributeListMap.get(id)) == null) {
            list2 = new ArrayList<Pair<XmlAttributeValue, Boolean>>();
            this.myId2AttributeListMap.put(id, list2);
        } else if (!soft) {
            boolean html = HtmlUtil.isHtmlFile(attributeValue2);
            boolean html5 = HtmlUtil.isHtml5Context(attributeValue2);
            List notSoft = ContainerUtil.mapNotNull(list2, (Function)((NullableFunction)pair -> {
                if (html5 && !"id".equalsIgnoreCase(((XmlAttribute)((XmlAttributeValue)pair.first).getParent()).getName())) {
                    return null;
                }
                if (html && ((XmlAttributeValue)pair.first).getParent().getParent() == attributeValue2.getParent().getParent()) {
                    return null;
                }
                return (Boolean)pair.second != false ? null : (XmlAttributeValue)pair.first;
            }));
            if (!notSoft.isEmpty()) {
                this.myPossiblyDuplicateIds.addAll(notSoft);
                this.myPossiblyDuplicateIds.add(attributeValue2);
            }
        }
        list2.add((Pair<XmlAttributeValue, Boolean>)new Pair((Object)attributeValue2, (Object)soft));
    }

    private void registerAdditionalId(@NotNull String id) {
        if (id == null) {
            XmlRefCountHolder.$$$reportNull$$$0(6);
        }
        this.myAdditionallyDeclaredIds.add(id);
    }

    private void registerIdReference(@NotNull XmlAttributeValue value) {
        if (value == null) {
            XmlRefCountHolder.$$$reportNull$$$0(7);
        }
        this.myIdReferences.add(value);
    }

    private void registerOuterLanguageElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            XmlRefCountHolder.$$$reportNull$$$0(8);
        }
        if ((parent = element.getParent()) instanceof XmlText) {
            parent = parent.getParent();
        }
        this.myDoNotValidateParentsList.add(parent);
    }

    public boolean isInUse(String prefix) {
        return this.myUsedPrefixes.contains(prefix);
    }

    public boolean isUsedNamespace(String ns) {
        return this.myUsedNamespaces.contains(ns);
    }

    private void addUsedPrefix(String prefix) {
        this.myUsedPrefixes.add(prefix);
    }

    private void addUsedNamespace(String ns) {
        this.myUsedNamespaces.add(ns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idRef";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/util/XmlRefCountHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefCountHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDuplicateIdAttributeValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasIdDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdReferenceValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAdditionalId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerIdReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOuterLanguageElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class IdGatheringRecursiveVisitor
    extends XmlRecursiveElementWalkingVisitor {
        private final XmlRefCountHolder myHolder;

        private IdGatheringRecursiveVisitor(@NotNull XmlRefCountHolder holder) {
            if (holder == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(0);
            }
            super(true);
            this.myHolder = holder;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(1);
            }
            if (element instanceof OuterLanguageElement) {
                this.visitOuterLanguageElement(element);
            }
            super.visitElement(element);
        }

        private void visitOuterLanguageElement(@NotNull PsiElement element) {
            PsiReference[] references;
            if (element == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(2);
            }
            this.myHolder.registerOuterLanguageElement(element);
            for (PsiReference reference : references = element.getReferences()) {
                PsiElement resolve2;
                if (!(reference instanceof PossiblePrefixReference) || !((PossiblePrefixReference)reference).isPrefixReference() || !((resolve2 = reference.resolve()) instanceof SchemaPrefix)) continue;
                this.myHolder.addUsedPrefix(((SchemaPrefix)resolve2).getName());
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(3);
            }
            this.doVisitAnyComment(comment);
            super.visitComment(comment);
        }

        @Override
        public void visitXmlComment(@NotNull XmlComment comment) {
            if (comment == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(4);
            }
            this.doVisitAnyComment(comment);
            super.visitXmlComment(comment);
        }

        private void doVisitAnyComment(PsiComment comment) {
            String id = XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
            if (id != null) {
                this.myHolder.registerAdditionalId(id);
            }
        }

        @Override
        public void visitXmlTag(@NotNull XmlTag tag) {
            if (tag == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(5);
            }
            this.myHolder.addUsedPrefix(tag.getNamespacePrefix());
            this.myHolder.addUsedNamespace(tag.getNamespace());
            String text2 = tag.getValue().getTrimmedText();
            this.detectPrefix(text2, tag);
            super.visitXmlTag(tag);
        }

        @Override
        public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
            if (attribute == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(6);
            }
            if (!attribute.isNamespaceDeclaration()) {
                this.myHolder.addUsedPrefix(attribute.getNamespacePrefix());
            }
            this.myHolder.addUsedNamespace(attribute.getNamespace());
            super.visitXmlAttribute(attribute);
        }

        @Override
        public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
            PsiElement element;
            if (value == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(7);
            }
            if (!((element = value.getParent()) instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag tag = attribute.getParent();
            if (tag == null) {
                return;
            }
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor == null) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
            if (attributeDescriptor != null) {
                if (attributeDescriptor.hasIdType()) {
                    this.updateMap(attribute, value, false);
                } else {
                    PsiReference[] references;
                    for (PsiReference r : references = value.getReferences()) {
                        SchemaPrefix prefix;
                        if (r instanceof IdReferenceProvider.GlobalAttributeValueSelfReference) {
                            this.updateMap(attribute, value, r.isSoft());
                            continue;
                        }
                        if (!(r instanceof SchemaPrefixReference) || (prefix = ((SchemaPrefixReference)r).resolve()) == null) continue;
                        this.myHolder.addUsedPrefix(prefix.getName());
                    }
                }
                if (attributeDescriptor.hasIdRefType() && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                    this.myHolder.registerIdReference(value);
                }
            }
            String s = value.getValue();
            this.detectPrefix(s, tag);
            super.visitXmlAttributeValue(value);
        }

        private void detectPrefix(String s, XmlTag tag) {
            if (s != null && !(tag instanceof HtmlTag) && s.length() < 1000) {
                Matcher matcher = PREFIX_PATTERN.matcher(s);
                while (matcher.find()) {
                    String group = matcher.group();
                    this.myHolder.addUsedPrefix(group.substring(0, group.length() - 1));
                }
            }
        }

        private void updateMap(@NotNull XmlAttribute attribute, @NotNull XmlAttributeValue value, boolean soft) {
            String id;
            if (attribute == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(8);
            }
            if (value == null) {
                IdGatheringRecursiveVisitor.$$$reportNull$$$0(9);
            }
            if (XmlUtil.isSimpleValue(id = XmlHighlightVisitor.getUnquotedValue(value, attribute.getParent()), value) && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                this.myHolder.registerId(id, value, soft);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOuterLanguageElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlComment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlTag";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlAttribute";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlAttributeValue";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateMap";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

