/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import java.util.HashMap;
import java.util.Map;

class RefChecker
extends AbstractVisitor {
    private final SchemaInfo schema;
    private final ErrorReporter er;
    private final Map refMap = new HashMap();
    private int currentDepth = 0;

    private RefChecker(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        this.schema = schemaInfo;
        this.er = errorReporter;
    }

    static void check(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        schemaInfo.getGrammar().componentsAccept(new RefChecker(schemaInfo, errorReporter));
    }

    public Object visitDiv(DivComponent divComponent) {
        divComponent.componentsAccept(this);
        return null;
    }

    public Object visitDefine(DefineComponent defineComponent) {
        String string2 = defineComponent.getName();
        if (string2 == DefineComponent.START || this.refMap.get(string2) == null) {
            defineComponent.getBody().accept(this);
        }
        return null;
    }

    public Object visitInclude(IncludeComponent includeComponent) {
        this.schema.getSchema(includeComponent.getHref()).componentsAccept(this);
        return null;
    }

    public Object visitElement(ElementPattern elementPattern) {
        ++this.currentDepth;
        elementPattern.getChild().accept(this);
        --this.currentDepth;
        return null;
    }

    public Object visitUnary(UnaryPattern unaryPattern) {
        return unaryPattern.getChild().accept(this);
    }

    public Object visitComposite(CompositePattern compositePattern) {
        compositePattern.childrenAccept(this);
        return null;
    }

    public Object visitRef(RefPattern refPattern) {
        Ref ref = (Ref)this.refMap.get(refPattern.getName());
        if (ref == null) {
            ref = new Ref(this.currentDepth);
            this.refMap.put(refPattern.getName(), ref);
            Pattern pattern2 = this.schema.getBody(refPattern);
            if (pattern2 == null) {
                this.er.error("undefined_reference", refPattern.getName(), refPattern.getSourceLocation());
            } else {
                this.schema.getBody(refPattern).accept(this);
            }
            ref.checkRecursionDepth = -1;
        } else if (this.currentDepth == ref.checkRecursionDepth) {
            this.er.error("recursive_reference", refPattern.getName(), refPattern.getSourceLocation());
        }
        return null;
    }

    public Object visitExternalRef(ExternalRefPattern externalRefPattern) {
        this.er.error("external_ref_not_supported", externalRefPattern.getSourceLocation());
        return null;
    }

    public Object visitGrammar(GrammarPattern grammarPattern) {
        this.er.error("nested_grammar_not_supported", grammarPattern.getSourceLocation());
        return null;
    }

    public Object visitParentRef(ParentRefPattern parentRefPattern) {
        this.er.error("parent_ref_no_grammar", parentRefPattern.getSourceLocation());
        return null;
    }

    private static class Ref {
        int checkRecursionDepth;

        Ref(int n) {
            this.checkRecursionDepth = n;
        }
    }
}

