/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final @NlsActions.ActionText String myTitle;
    private final String myGroupStart;

    GroupSurrounder(@NlsActions.ActionText String title, String groupStart) {
        this.myTitle = title;
        this.myGroupStart = groupStart;
    }

    public String getTemplateDescription() {
        return this.myTitle;
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            GroupSurrounder.$$$reportNull$$$0(0);
        }
        return elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, PsiElement @NotNull [] elements) {
        if (project2 == null) {
            GroupSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GroupSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            GroupSurrounder.$$$reportNull$$$0(3);
        }
        assert (elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent());
        PsiElement e = elements[0];
        ASTNode node = e.getNode();
        assert (node != null);
        ASTNode parent = node.getTreeParent();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            if (element instanceof RegExpElementImpl) {
                s.append(((RegExpElementImpl)element).getUnescapedText());
            } else {
                s.append(element.getText());
            }
            if (i <= 0) continue;
            ASTNode child = element.getNode();
            assert (child != null);
            parent.removeChild(child);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        PsiFile f = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s));
        RegExpPattern pattern2 = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
        assert (pattern2 != null);
        RegExpAtom element = pattern2.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e)) {
            Document doc2 = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(doc2);
            TextRange tr = e.getTextRange();
            doc2.replaceString(tr.getStartOffset(), tr.getEndOffset(), (CharSequence)StringUtil.escapeStringCharacters((String)element.getText()));
            return TextRange.from((int)e.getTextRange().getEndOffset(), (int)0);
        }
        PsiElement n = e.replace((PsiElement)element);
        return TextRange.from((int)n.getTextRange().getEndOffset(), (int)0);
    }

    private static boolean isInsideStringLiteral(PsiElement context) {
        while (context != null) {
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return true;
            }
            context = context.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s) {
        return this.myGroupStart + s + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/surroundWith/GroupSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

