/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.editor.Document;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\r\u001a\u00020\tJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/debugger/sourcemap/MappingList;", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "(Ljava/util/List;)V", "comparator", "Ljava/util/Comparator;", "size", "", "getSize", "()I", "get", "line", "column", "getByIndex", "index", "getEndOffset", "mapping", "lineStartOffset", "document", "Lcom/intellij/openapi/editor/Document;", "getMappingsInLine", "", "getNext", "getNextOnTheSameLine", "skipIfColumnEquals", "", "indexOf", "processMappingsInLine", "entryProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public abstract class MappingList
implements Mappings {
    @NotNull
    private final Comparator<MappingEntry> comparator;
    @NotNull
    private final List<MappingEntry> mappings;

    public MappingList(@NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> MappingList.comparator$lambda$0((Function1)new Function1<MappingEntry, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull MappingEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MappingList)this.receiver).getLine(p0);
            }
        }, arg_0)).thenComparing(arg_0 -> MappingList.comparator$lambda$1((Function1)new Function1<MappingEntry, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull MappingEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MappingList)this.receiver).getColumn(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparing(...)");
        this.comparator = comparator2;
        this.mappings = this instanceof GeneratedMappingList ? mappings : CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)mappings, this.comparator));
    }

    public final int getSize() {
        return this.mappings.size();
    }

    @Override
    public int indexOf(int line, int column) {
        int middle2 = CollectionsKt.binarySearch$default(this.mappings, (int)0, (int)0, (Function1)((Function1)new Function1<MappingEntry, Integer>(this, line, column){
            final /* synthetic */ MappingList this$0;
            final /* synthetic */ int $line;
            final /* synthetic */ int $column;
            {
                this.this$0 = $receiver;
                this.$line = $line;
                this.$column = $column;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull MappingEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int compareLines = Intrinsics.compare((int)this.this$0.getLine(it), (int)this.$line);
                return compareLines != 0 ? compareLines : Intrinsics.compare((int)this.this$0.getColumn(it), (int)this.$column);
            }
        }), (int)3, null);
        if (middle2 == -1) {
            middle2 = 0;
        } else if (middle2 < -1) {
            middle2 = -middle2 - 2;
        }
        if (this.getLine(this.mappings.get(middle2)) < line && middle2 < this.mappings.size()) {
            int lastOfEquivalent;
            for (lastOfEquivalent = middle2; lastOfEquivalent < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastOfEquivalent)) == this.getLine(this.mappings.get(lastOfEquivalent + 1)) && this.getColumn(this.mappings.get(lastOfEquivalent)) == this.getColumn(this.mappings.get(lastOfEquivalent + 1)); ++lastOfEquivalent) {
            }
            if (lastOfEquivalent == this.mappings.size() - 1) {
                return -1;
            }
            middle2 = lastOfEquivalent + 1;
        }
        while (middle2 > 0 && this.getLine(this.mappings.get(middle2)) == this.getLine(this.mappings.get(middle2 - 1)) && this.getColumn(this.mappings.get(middle2)) == this.getColumn(this.mappings.get(middle2 - 1))) {
            --middle2;
        }
        return line == this.getLine(this.mappings.get(middle2)) ? middle2 : -1;
    }

    @Override
    @Nullable
    public MappingEntry get(int line, int column) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)this.indexOf(line, column));
    }

    private final MappingEntry getNext(int index) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)(index + 1));
    }

    @Override
    @Nullable
    public MappingEntry getNext(@NotNull MappingEntry mapping) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        int index = CollectionsKt.binarySearch$default(this.mappings, (Object)mapping, this.comparator, (int)0, (int)0, (int)12, null);
        if (index < 0) {
            return null;
        }
        MappingEntry result2 = null;
        do {
            n = ++index;
            ++index;
        } while (mapping == (result2 = (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)n)));
        return result2;
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(int index, boolean skipIfColumnEquals) {
        MappingEntry mappingEntry = this.getNext(index);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry nextMapping = mappingEntry;
        MappingEntry mapping = this.getByIndex(index);
        if (this.getLine(nextMapping) != this.getLine(mapping)) {
            return null;
        }
        if (skipIfColumnEquals) {
            int i = index;
            while (this.getColumn(nextMapping) == this.getColumn(mapping)) {
                if (this.getNextOnTheSameLine(++i, false) != null) continue;
                return null;
            }
        }
        return nextMapping;
    }

    public final int getEndOffset(@NotNull MappingEntry mapping, int lineStartOffset, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        MappingEntry nextMapping = Mappings.getNextOnTheSameLine$default(this, Collections.binarySearch(this.mappings, mapping, this.comparator), false, 2, null);
        return nextMapping == null ? document2.getLineEndOffset(this.getLine(mapping)) : lineStartOffset + this.getColumn(nextMapping);
    }

    @Override
    @NotNull
    public MappingEntry getByIndex(int index) {
        return this.mappings.get(index);
    }

    @NotNull
    public final Iterable<MappingEntry> getMappingsInLine(int line) {
        int lastIndex;
        int firstIndex;
        int low = 0;
        int high = this.mappings.size() - 1;
        int middle2 = -1;
        while (low <= high) {
            middle2 = low + high >>> 1;
            MappingEntry mapping = this.mappings.get(middle2);
            int mappingLine = this.getLine(mapping);
            if (line == mappingLine) break;
            if (line > mappingLine) {
                low = middle2 + 1;
                continue;
            }
            high = middle2 - 1;
        }
        if (middle2 == -1) {
            return CollectionsKt.emptyList();
        }
        for (firstIndex = middle2; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
        }
        for (lastIndex = middle2; lastIndex < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastIndex + 1)) == line; ++lastIndex) {
        }
        return this.mappings.subList(firstIndex, lastIndex + 1);
    }

    public final boolean processMappingsInLine(int line, @NotNull MappingsProcessorInLine entryProcessor) {
        Intrinsics.checkNotNullParameter((Object)entryProcessor, (String)"entryProcessor");
        Iterable<MappingEntry> mappingsInLine = this.getMappingsInLine(line);
        return entryProcessor.processIterable(mappingsInLine);
    }

    private static final Integer comparator$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer comparator$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }
}

