/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.digested;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.rngom.ast.builder.Annotations;
import org.kohsuke.rngom.ast.builder.BuildException;
import org.kohsuke.rngom.ast.builder.CommentList;
import org.kohsuke.rngom.ast.builder.Div;
import org.kohsuke.rngom.ast.builder.Grammar;
import org.kohsuke.rngom.ast.builder.GrammarSection;
import org.kohsuke.rngom.ast.builder.Include;
import org.kohsuke.rngom.ast.builder.Scope;
import org.kohsuke.rngom.ast.om.Location;
import org.kohsuke.rngom.ast.om.ParsedElementAnnotation;
import org.kohsuke.rngom.ast.om.ParsedPattern;
import org.kohsuke.rngom.ast.util.LocatorImpl;
import org.kohsuke.rngom.digested.Annotation;
import org.kohsuke.rngom.digested.DAnnotation;
import org.kohsuke.rngom.digested.DDefine;
import org.kohsuke.rngom.digested.DGrammarPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DRefPattern;
import org.kohsuke.rngom.digested.DSchemaBuilderImpl;
import org.kohsuke.rngom.digested.ElementWrapper;
import org.kohsuke.rngom.digested.IncludeImpl;
import org.w3c.dom.Element;

class GrammarBuilderImpl
implements Grammar,
Div {
    protected final DGrammarPattern grammar;
    protected final Scope parent;
    protected final DSchemaBuilderImpl sb;
    private List<Element> additionalElementAnnotations;

    public GrammarBuilderImpl(DGrammarPattern p, Scope parent, DSchemaBuilderImpl sb) {
        this.grammar = p;
        this.parent = parent;
        this.sb = sb;
    }

    public ParsedPattern endGrammar(Location loc, Annotations anno) throws BuildException {
        if (anno != null) {
            this.grammar.annotation = ((Annotation)anno).getResult();
        }
        if (this.additionalElementAnnotations != null) {
            if (this.grammar.annotation == null) {
                this.grammar.annotation = new DAnnotation();
            }
            if (this.grammar.annotation.contents == null) {
                this.grammar.annotation.contents = new ArrayList<Element>();
            }
            this.grammar.annotation.contents.addAll(this.additionalElementAnnotations);
        }
        return this.grammar;
    }

    public void endDiv(Location loc, Annotations anno) throws BuildException {
    }

    @Override
    public void define(String name, GrammarSection.Combine combine, ParsedPattern pattern2, Location loc, Annotations anno) throws BuildException {
        if (name == "\u0000#start\u0000") {
            this.grammar.start = (DPattern)pattern2;
        } else {
            DDefine d = this.grammar.getOrAdd(name);
            if (d.getPattern() == null) {
                d.setPattern((DPattern)pattern2);
                d.setCombine(combine);
            } else if (combine == COMBINE_CHOICE) {
                d.setPattern(this.sb.makeChoice(Arrays.asList((DPattern)pattern2, d.getPattern()), (LocatorImpl)null, (Annotation)null));
            } else if (combine == COMBINE_INTERLEAVE) {
                d.setPattern(this.sb.makeInterleave(Arrays.asList((DPattern)pattern2, d.getPattern()), (LocatorImpl)null, (Annotation)null));
            } else {
                combine = d.getCombine();
                d.setCombine(null);
                if (combine == COMBINE_CHOICE) {
                    d.setPattern(this.sb.makeChoice(Arrays.asList((DPattern)pattern2, d.getPattern()), (LocatorImpl)null, (Annotation)null));
                } else if (combine == COMBINE_INTERLEAVE) {
                    d.setPattern(this.sb.makeInterleave(Arrays.asList((DPattern)pattern2, d.getPattern()), (LocatorImpl)null, (Annotation)null));
                }
            }
            if (anno != null) {
                d.annotation = ((Annotation)anno).getResult();
            }
        }
    }

    @Override
    public void topLevelAnnotation(ParsedElementAnnotation ea) throws BuildException {
        if (this.additionalElementAnnotations == null) {
            this.additionalElementAnnotations = new ArrayList<Element>();
        }
        this.additionalElementAnnotations.add(((ElementWrapper)ea).element);
    }

    @Override
    public void topLevelComment(CommentList comments) throws BuildException {
    }

    @Override
    public Div makeDiv() {
        return this;
    }

    @Override
    public Include makeInclude() {
        return new IncludeImpl(this.grammar, this.parent, this.sb);
    }

    @Override
    public ParsedPattern makeParentRef(String name, Location loc, Annotations anno) throws BuildException {
        return this.parent != null ? this.parent.makeRef(name, loc, anno) : DSchemaBuilderImpl.wrap(new DRefPattern(new DDefine(name)), (LocatorImpl)loc, (Annotation)anno);
    }

    @Override
    public ParsedPattern makeRef(String name, Location loc, Annotations anno) throws BuildException {
        return DSchemaBuilderImpl.wrap(new DRefPattern(this.grammar.getOrAdd(name)), (LocatorImpl)loc, (Annotation)anno);
    }
}

