/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/theoryinpractice/testng/configuration/TestNGRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "intellij.testng"})
@SourceDebugExtension(value={"SMAP\nTestNGRunConfigurationImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestNGRunConfigurationImporter.kt\ncom/theoryinpractice/testng/configuration/TestNGRunConfigurationImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n288#2,2:80\n*S KotlinDebug\n*F\n+ 1 TestNGRunConfigurationImporter.kt\ncom/theoryinpractice/testng/configuration/TestNGRunConfigurationImporter\n*L\n26#1:80,2\n*E\n"})
public final class TestNGRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, Object> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            if (!(runConfiguration instanceof TestNGConfiguration)) {
                throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
            }
            Object[] objectArray = new String[]{"package", "class", "method", "group", "suite", "pattern"};
            List allowedTypes = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$firstOrNull$iv = cfg.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(allowedTypes.contains(it) && cfg.get(it) != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        String testKind = v0;
        TestData data = ((TestNGConfiguration)runConfiguration).data;
        if (testKind != null) {
            ObjectUtils.consumeIfCast((Object)cfg.get(testKind), String.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$1((Function1)new Function1<String, Unit>(data, testKind){
                final /* synthetic */ TestData $data;
                final /* synthetic */ String $testKind;
                {
                    this.$data = $data;
                    this.$testKind = $testKind;
                    super(1);
                }

                public final void invoke(String testKindValue) {
                    TestData testData = this.$data;
                    testData.TEST_OBJECT = switch (this.$testKind) {
                        case "package" -> {
                            String var3_3 = TestType.PACKAGE.type;
                            TestData var4_9 = this.$data;
                            String var5_15 = var3_3;
                            TestData var9_21 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$1 = false;
                            var4_9.PACKAGE_NAME = testKindValue;
                            testData = var9_21;
                            yield var3_3;
                        }
                        case "class" -> {
                            String var3_4 = TestType.CLASS.type;
                            TestData var4_10 = this.$data;
                            String it = var3_4;
                            TestData var9_22 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$2 = false;
                            var4_10.MAIN_CLASS_NAME = testKindValue;
                            testData = var9_22;
                            yield var3_4;
                        }
                        case "method" -> {
                            String var3_5 = TestType.METHOD.type;
                            TestData var4_11 = this.$data;
                            String it = var3_5;
                            TestData var9_23 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$3 = false;
                            Intrinsics.checkNotNull((Object)testKindValue);
                            String className = StringsKt.substringBefore$default((String)testKindValue, (char)'#', null, (int)2, null);
                            String methodName = StringsKt.substringAfter$default((String)testKindValue, (char)'#', null, (int)2, null);
                            var4_11.MAIN_CLASS_NAME = className;
                            var4_11.METHOD_NAME = methodName;
                            testData = var9_23;
                            yield var3_5;
                        }
                        case "group" -> {
                            String var3_6 = TestType.GROUP.type;
                            TestData var4_12 = this.$data;
                            String it = var3_6;
                            TestData var9_24 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$4 = false;
                            var4_12.GROUP_NAME = testKindValue;
                            testData = var9_24;
                            yield var3_6;
                        }
                        case "suite" -> {
                            String var3_7 = TestType.SUITE.type;
                            TestData var4_13 = this.$data;
                            String it = var3_7;
                            TestData var9_25 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$5 = false;
                            var4_13.SUITE_NAME = testKindValue;
                            testData = var9_25;
                            yield var3_7;
                        }
                        case "pattern" -> {
                            String var3_8 = TestType.PATTERN.type;
                            TestData var4_14 = this.$data;
                            String it = var3_8;
                            TestData var9_26 = testData;
                            boolean $i$a$-also-TestNGRunConfigurationImporter$process$1$6 = false;
                            Intrinsics.checkNotNull((Object)testKindValue);
                            char[] var7_34 = new char[]{','};
                            var4_14.setPatterns(new LinkedHashSet<String>(StringsKt.split$default((CharSequence)testKindValue, (char[])var7_34, (boolean)false, (int)0, (int)6, null)));
                            testData = var9_26;
                            yield var3_8;
                        }
                        default -> this.$data.TEST_OBJECT;
                    };
                }
            }, arg_0));
        }
        ObjectUtils.consumeIfCast((Object)cfg.get("vmParameters"), String.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$2((Function1)new Function1<String, Unit>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(String it) {
                ((TestNGConfiguration)this.$runConfiguration).setVMParameters(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("workingDirectory"), String.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$3((Function1)new Function1<String, Unit>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(String it) {
                ((TestNGConfiguration)this.$runConfiguration).setWorkingDirectory(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("passParentEnvs"), Boolean.TYPE, arg_0 -> TestNGRunConfigurationImporter.process$lambda$4((Function1)new Function1<Boolean, Unit>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(Boolean it) {
                TestNGConfiguration testNGConfiguration = (TestNGConfiguration)this.$runConfiguration;
                Intrinsics.checkNotNull((Object)it);
                testNGConfiguration.setPassParentEnvs(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("envs"), Map.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$5((Function1)new Function1<Map<?, ?>, Unit>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(Map<?, ?> it) {
                TestNGConfiguration testNGConfiguration = (TestNGConfiguration)this.$runConfiguration;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                testNGConfiguration.setEnvs(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("moduleName"), String.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$6((Function1)new Function1<String, Unit>(modelsProvider, runConfiguration){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$modelsProvider = $modelsProvider;
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(String it) {
                Module module = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module != null) {
                    ((TestNGConfiguration)this.$runConfiguration).setModule(module);
                }
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("shortenCommandLine"), String.class, arg_0 -> TestNGRunConfigurationImporter.process$lambda$7((Function1)new Function1<String, Unit>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;
            {
                this.$runConfiguration = $runConfiguration;
                super(1);
            }

            public final void invoke(String it) {
                try {
                    TestNGConfiguration testNGConfiguration = (TestNGConfiguration)this.$runConfiguration;
                    Intrinsics.checkNotNull((Object)it);
                    testNGConfiguration.setShortenCommandLine(ShortenCommandLine.valueOf((String)it));
                }
                catch (IllegalArgumentException e) {
                    TestNGRunConfigurationImporter.Companion.getLOG().warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
                }
            }
        }, arg_0));
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"testng", (Object)typeName);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((TestNGConfigurationType)ConfigurationTypeUtil.findConfigurationType(TestNGConfigurationType.class)).getConfigurationFactories()[0];
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(TestNGRunConfigurationImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/theoryinpractice/testng/configuration/TestNGRunConfigurationImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.testng"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

