/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinPropertySetterParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "()V", "leftParenthesis", "Lcom/intellij/lang/ASTNode;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLeftParenthesis", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)Lcom/intellij/lang/ASTNode;", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.base.code-insight.minimal"})
public final class KotlinPropertySetterParametersFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement psiElement) {
        KtParameter parameter;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtPropertyAccessor)) {
            return;
        }
        if (!((KtPropertyAccessor)psiElement).isSetter()) {
            return;
        }
        KtParameter ktParameter = parameter = ((KtPropertyAccessor)psiElement).getParameter();
        CharSequence charSequence = ktParameter != null ? ktParameter.getText() : null;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((KtPropertyAccessor)psiElement).getRightParenthesis() != null) {
            return;
        }
        PsiElement psiElement2 = ((KtPropertyAccessor)psiElement).getNamePlaceholder();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNamePlaceholder(...)");
        if (PsiUtilsKt.getEndOffset((PsiElement)psiElement2) == PsiUtilsKt.getEndOffset((PsiElement)psiElement)) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiElement psiElement3 = ((KtPropertyAccessor)psiElement).getLeftParenthesis();
        if (psiElement3 == null || (psiElement3 = psiElement3.getNode()) == null) {
            return;
        }
        int parameterOffset = psiElement3.getStartOffset() + 1;
        KtParameter ktParameter2 = parameter;
        CharSequence charSequence2 = ktParameter2 != null ? ktParameter2.getText() : null;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            if (((KtPropertyAccessor)psiElement).getRightParenthesis() == null) {
                doc.insertString(parameterOffset, (CharSequence)"value)");
            } else {
                doc.insertString(parameterOffset, (CharSequence)"value");
            }
        } else if (((KtPropertyAccessor)psiElement).getRightParenthesis() == null) {
            KtParameter ktParameter3 = parameter;
            Intrinsics.checkNotNull((Object)ktParameter3);
            doc.insertString(parameterOffset + ktParameter3.getText().length(), (CharSequence)")");
        }
    }

    private final ASTNode getLeftParenthesis(KtPropertyAccessor $this$leftParenthesis) {
        return $this$leftParenthesis.getNode().findChildByType((IElementType)KtTokens.LPAR);
    }
}

