/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCodeStylePropertyAccessorKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCodeStylePropertyAccessor;", "Lcom/intellij/application/options/codeStyle/properties/CodeStylePropertyAccessor;", "", "Lcom/intellij/application/options/codeStyle/properties/CodeStyleChoiceList;", "kotlinCodeStyle", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "(Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;)V", "get", "getChoices", "", "getPropertyName", "parseString", "string", "set", "", "extVal", "valueToString", "value", "kotlin.formatter.minimal"})
public final class KotlinCodeStylePropertyAccessor
extends CodeStylePropertyAccessor<String>
implements CodeStyleChoiceList {
    @NotNull
    private final KotlinCodeStyleSettings kotlinCodeStyle;

    public KotlinCodeStylePropertyAccessor(@NotNull KotlinCodeStyleSettings kotlinCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinCodeStyle), (String)"kotlinCodeStyle");
        this.kotlinCodeStyle = kotlinCodeStyle;
    }

    public boolean set(@NotNull String extVal) {
        Intrinsics.checkNotNullParameter((Object)extVal, (String)"extVal");
        CodeStyleSettings codeStyleSettings = this.kotlinCodeStyle.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getContainer(...)");
        return KotlinCodeStylePropertyAccessorKt.access$applyKotlinCodeStyle(extVal, codeStyleSettings);
    }

    @Nullable
    public String get() {
        CodeStyleSettings codeStyleSettings = this.kotlinCodeStyle.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getContainer(...)");
        return CodeStyleUtilsKt.kotlinCodeStyleDefaults(codeStyleSettings);
    }

    @NotNull
    protected String parseString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return string;
    }

    @NotNull
    protected String valueToString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @NotNull
    public List<String> getChoices() {
        Object[] objectArray = new String[]{"KOTLIN_OFFICIAL", "KOTLIN_OLD_DEFAULTS"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPropertyName() {
        return "code_style_defaults";
    }
}

