/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/Visitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "setRange", "visitNamedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinPreFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPreFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/Visitor\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,72:1\n177#2:73\n56#3,11:74\n20#3,2:85\n1247#4,2:87\n*S KotlinDebug\n*F\n+ 1 KotlinPreFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/Visitor\n*L\n37#1:73\n43#1:74,11\n43#1:85,2\n23#1:87,2\n*E\n"})
final class Visitor
extends KtTreeVisitorVoid {
    @NotNull
    private TextRange range;

    public Visitor(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    public final void setRange(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.range = textRange;
    }

    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.range.contains(declaration.getTextRange())) {
            return;
        }
        PsiElement psiElement = declaration.getParent();
        KtClassBody ktClassBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
        if (ktClassBody == null) {
            return;
        }
        KtClassBody classBody = ktClassBody;
        PsiElement psiElement2 = classBody.getParent();
        KtClass ktClass = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
        if (ktClass == null) {
            return;
        }
        KtClass klass = ktClass;
        if (!klass.isEnum()) {
            return;
        }
        int delta = 0;
        Project project = klass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (declaration instanceof KtEnumEntry) {
            PsiElement comma = psiFactory.createComma();
            PsiElement $this$nextSiblingOfSameType$iv = (PsiElement)declaration;
            boolean $i$f$nextSiblingOfSameType = false;
            KtEnumEntry nextEntry = (KtEnumEntry)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfSameType$iv, KtEnumEntry.class);
            if (nextEntry != null) {
                PsiElement psiElement3 = (PsiElement)declaration;
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COMMA");
                if (!Visitor.visitNamedDeclaration$containsToken(psiElement3, (IElementType)ktSingleValueToken)) {
                    declaration.add(comma);
                    delta += comma.getTextLength();
                }
            }
        } else {
            int n;
            Object v5;
            block19: {
                Iterable $this$lastIsInstanceOrNull$iv = klass.getDeclarations();
                boolean $i$f$lastIsInstanceOrNull = false;
                if ($this$lastIsInstanceOrNull$iv instanceof List) {
                    int $i$f$nextSiblingOfSameType = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                    if (0 <= $i$f$nextSiblingOfSameType) {
                        do {
                            int i$iv;
                            Object element$iv;
                            if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = $i$f$nextSiblingOfSameType--)) instanceof KtEnumEntry)) continue;
                            v5 = element$iv;
                            break block19;
                        } while (0 <= $i$f$nextSiblingOfSameType);
                    }
                    v5 = null;
                } else {
                    Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                        v5 = element$iv$iv;
                        break block19;
                    }
                    v5 = null;
                }
            }
            KtEnumEntry lastEntry = v5;
            if (lastEntry != null) {
                PsiElement psiElement4;
                PsiElement psiElement5 = (PsiElement)lastEntry;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"SEMICOLON");
                if (Visitor.visitNamedDeclaration$containsToken(psiElement5, (IElementType)ktSingleValueToken) || Intrinsics.areEqual((Object)((psiElement4 = lastEntry.getNextSibling()) != null && (psiElement4 = psiElement4.getNode()) != null ? psiElement4.getElementType() : null), (Object)KtTokens.SEMICOLON)) {
                    return;
                }
            }
            if (lastEntry == null) {
                PsiElement psiElement6 = (PsiElement)classBody;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"SEMICOLON");
                if (Visitor.visitNamedDeclaration$containsToken(psiElement6, (IElementType)ktSingleValueToken)) {
                    return;
                }
            }
            PsiElement semicolon = psiFactory.createSemicolon();
            if (lastEntry != null) {
                lastEntry.add(semicolon);
                n = semicolon.getTextLength();
            } else {
                PsiElement newLine = psiFactory.createNewLine();
                classBody.addAfter(semicolon, classBody.getLBrace());
                classBody.addAfter(psiFactory.createNewLine(), classBody.getLBrace());
                n = semicolon.getTextLength() + newLine.getTextLength();
            }
            delta += n;
        }
        this.range = new TextRange(this.range.getStartOffset(), this.range.getEndOffset() + delta);
    }

    private static final boolean visitNamedDeclaration$containsToken(PsiElement $this$visitNamedDeclaration_u24containsToken, IElementType type) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)$this$visitNamedDeclaration_u24containsToken);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)type)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

