/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.utils;

import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0004"}, d2={"findGradleBuildFile", "Ljava/io/File;", "dirPath", "findGradleSettingsFile", "intellij.android.gradle.dsl"})
@JvmName(name="BuildScriptUtil")
public final class BuildScriptUtil {
    @NotNull
    public static final File findGradleBuildFile(@NotNull File dirPath) {
        File gradleDeclarativeBuildFile;
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        File groovyBuildFile = new File(dirPath, "build.gradle");
        if (groovyBuildFile.isFile()) {
            return groovyBuildFile;
        }
        File kotlinBuildFile = new File(dirPath, "build.gradle.kts");
        if (kotlinBuildFile.isFile()) {
            return kotlinBuildFile;
        }
        if (Registry.is((String)"android.gradle.declarative.plugin.studio.support", (boolean)false) && (gradleDeclarativeBuildFile = new File(dirPath, "build.gradle.dcl")).isFile()) {
            return gradleDeclarativeBuildFile;
        }
        return groovyBuildFile;
    }

    @NotNull
    public static final File findGradleSettingsFile(@NotNull File dirPath) {
        File gradleDeclarativeSettingsFile;
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        File groovySettingsFile = new File(dirPath, "settings.gradle");
        if (groovySettingsFile.isFile()) {
            return groovySettingsFile;
        }
        File kotlinSettingsFile = new File(dirPath, "settings.gradle.kts");
        if (kotlinSettingsFile.isFile()) {
            return kotlinSettingsFile;
        }
        if (Registry.is((String)"android.gradle.declarative.plugin.studio.support", (boolean)false) && (gradleDeclarativeSettingsFile = new File(dirPath, "settings.gradle.dcl")).isFile()) {
            return gradleDeclarativeSettingsFile;
        }
        return groovySettingsFile;
    }
}

