/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.statistics.SettingsSyncEventsStatistics;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "(Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;)V", "scheduleUpdateFromServer", "Lcom/intellij/settingsSync/UpdateResult;", "Companion", "intellij.settingsSync"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsSyncUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncUpdateChecker.kt\ncom/intellij/settingsSync/SettingsSyncUpdateChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n13#2:42\n*S KotlinDebug\n*F\n+ 1 SettingsSyncUpdateChecker.kt\ncom/intellij/settingsSync/SettingsSyncUpdateChecker\n*L\n12#1:42\n*E\n"})
public final class SettingsSyncUpdateChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsSyncRemoteCommunicator remoteCommunicator;
    @NotNull
    private static final Logger LOG;

    public SettingsSyncUpdateChecker(@NotNull SettingsSyncRemoteCommunicator remoteCommunicator) {
        Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
        this.remoteCommunicator = remoteCommunicator;
    }

    @RequiresBackgroundThread
    @NotNull
    public final UpdateResult scheduleUpdateFromServer() {
        UpdateResult updateResult = this.remoteCommunicator.receiveUpdates();
        UpdateResult updateResult2 = updateResult;
        if (updateResult2 instanceof UpdateResult.Success) {
            SettingsSnapshot snapshot = ((UpdateResult.Success)updateResult).getSettingsSnapshot();
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.CloudChange(snapshot, ((UpdateResult.Success)updateResult).getServerVersionId(), null, 4, null));
        } else if (updateResult2 instanceof UpdateResult.FileDeletedFromServer) {
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.DeletedOnCloud.INSTANCE);
            SettingsSyncEventsStatistics.INSTANCE.getDISABLED_AUTOMATICALLY().log((Object)SettingsSyncEventsStatistics.AutomaticDisableReason.REMOVED_FROM_SERVER);
        } else if (updateResult2 instanceof UpdateResult.NoFileOnServer) {
            LOG.info("Settings update requested, but there was no file on the server.");
        } else if (updateResult2 instanceof UpdateResult.Error) {
            LOG.warn("Settings update requested, but failed with error: " + ((UpdateResult.Error)updateResult).getMessage());
            SettingsSyncStatusTracker.Companion.getInstance().updateOnError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]) + ": " + ((UpdateResult.Error)updateResult).getMessage());
        }
        return updateResult;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncUpdateChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/SettingsSyncUpdateChecker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

