/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/GrReplaceWithQualifiedExpressionFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "getName", "intellij.groovy"})
public final class GrReplaceWithQualifiedExpressionFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.rename", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("intention.name.replace.with.qualified.expression", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof GrMethodCall)) {
            return;
        }
        PsiMethod psiMethod = ((GrMethodCall)element).resolveMethod();
        if (psiMethod == null || (psiMethod = psiMethod.getContainingClass()) == null) {
            return;
        }
        PsiMethod container = psiMethod;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        GrExpression grExpression = factory.createExpressionFromText(container.getName() + "." + ((GrMethodCall)element).getInvokedExpression().getText(), element);
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"createExpressionFromText(...)");
        GrExpression newInvoked = grExpression;
        ((GrMethodCall)element).getInvokedExpression().replace(newInvoked);
    }
}

