/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public final class GroovyFallthroughInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.fallthrough.in.switch.statement", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*thro?u");

        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            if (switchStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.visitSwitchElement(switchStatement);
        }

        @Override
        public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
            if (switchExpression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitSwitchElement(switchExpression);
        }

        public void visitSwitchElement(@NotNull GrSwitchElement switchElement) {
            if (switchElement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (switchElement instanceof GrSwitchStatement) {
                super.visitSwitchStatement((GrSwitchStatement)switchElement);
            } else if (switchElement instanceof GrSwitchExpression) {
                super.visitSwitchExpression((GrSwitchExpression)switchElement);
            }
            Object[] caseSections = switchElement.getCaseSections();
            if (ContainerUtil.exists((Object[])caseSections, section -> section.getArrow() != null)) {
                return;
            }
            for (int i2 = 1; i2 < caseSections.length; ++i2) {
                Object caseSection = caseSections[i2];
                if (Visitor.isCommented((GrCaseSection)caseSection)) continue;
                Object previousCaseSection = caseSections[i2 - 1];
                GrStatement[] statements2 = previousCaseSection.getStatements();
                if (statements2.length == 0) {
                    this.registerError(caseSection.getFirstChild());
                    continue;
                }
                GrStatement lastStatement = statements2[statements2.length - 1];
                if (!ControlFlowUtils.statementMayCompleteNormally(lastStatement)) continue;
                this.registerError(caseSection.getFirstChild());
            }
        }

        private static boolean isCommented(GrCaseSection caseClause) {
            PsiElement element = PsiUtilKt.skipWhiteSpacesAndNewLines(caseClause, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)PsiTreeUtil::prevLeaf));
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchElement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

