/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.configSlurper;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyMapContentProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMapProperty;

public final class GroovyMapValueTypeEnhancer
extends GrReferenceTypeEnhancer {
    @Override
    public PsiType getReferenceType(GrReferenceExpression ref2, @Nullable PsiElement resolved) {
        PsiElement qResolved;
        if (!(resolved instanceof GroovyMapProperty)) {
            return null;
        }
        GrExpression qualifierExpression = ref2.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        PsiType mapType = qualifierExpression.getType();
        if (!InheritanceUtil.isInheritor((PsiType)mapType, (String)"java.util.Map")) {
            return null;
        }
        if (qualifierExpression instanceof GrReferenceExpression) {
            qResolved = ((GrReferenceExpression)qualifierExpression).resolve();
        } else if (qualifierExpression instanceof GrMethodCall) {
            qResolved = ((GrMethodCall)qualifierExpression).resolveMethod();
        } else {
            return null;
        }
        String key = ref2.getReferenceName();
        if (key == null) {
            return null;
        }
        for (GroovyMapContentProvider provider2 : (GroovyMapContentProvider[])GroovyMapContentProvider.EP_NAME.getExtensions()) {
            PsiType type2 = provider2.getValueType(qualifierExpression, qResolved, key);
            if (type2 == null) continue;
            return type2;
        }
        if (mapType instanceof GrMapType) {
            return ((GrMapType)mapType).getTypeByStringKey(key);
        }
        return null;
    }
}

