/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class ConvertMethodToClosureIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertMethodToClosureIntention.class);

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrMethod method;
        if (element == null) {
            ConvertMethodToClosureIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConvertMethodToClosureIntention.$$$reportNull$$$0(1);
        }
        MultiMap conflicts = new MultiMap();
        if (element.getParent() instanceof GrMethod) {
            method = (GrMethod)element.getParent();
        } else {
            PsiReference ref2 = element.getReference();
            LOG.assertTrue(ref2 != null);
            PsiElement resolved = ref2.resolve();
            LOG.assertTrue(resolved instanceof GrMethod);
            method = (GrMethod)resolved;
        }
        PsiClass containingClass = method.getContainingClass();
        String methodName = method.getName();
        PsiField field2 = containingClass.findFieldByName(methodName, true);
        if (field2 != null) {
            conflicts.putValue((Object)field2, (Object)GroovyBundle.message("field.already.exists", methodName));
        }
        Collection references = MethodReferencesSearch.search((PsiMethod)method).findAll();
        HashSet<GrReferenceExpression> usagesToConvert = new HashSet<GrReferenceExpression>(references.size());
        for (PsiReference ref3 : references) {
            PsiElement psiElement = ref3.getElement();
            if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(psiElement.getLanguage())) {
                conflicts.putValue((Object)psiElement, (Object)GroovyBundle.message("method.is.used.outside.of.groovy", new Object[0]));
                continue;
            }
            if (PsiUtil.isMethodUsage(psiElement) || !(psiElement instanceof GrReferenceExpression) || !((GrReferenceExpression)psiElement).hasMemberPointer()) continue;
            usagesToConvert.add((GrReferenceExpression)psiElement);
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, () -> ConvertMethodToClosureIntention.execute(method, usagesToConvert));
            conflictsDialog.show();
            if (conflictsDialog.getExitCode() != 0) {
                return;
            }
        }
        ConvertMethodToClosureIntention.execute(method, usagesToConvert);
    }

    private static void execute(GrMethod method, Collection<GrReferenceExpression> usagesToConvert) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        StringBuilder builder = new StringBuilder(method.getTextLength());
        String modifiers = method.getModifierList().getText();
        if (modifiers.trim().isEmpty()) {
            modifiers = "def";
        }
        builder.append(modifiers).append(' ');
        builder.append(method.getName()).append("={");
        GrParameterList parameterList = method.getParameterList();
        builder.append(parameterList.getParametersRange().shiftLeft(parameterList.getTextRange().getStartOffset()).subSequence((CharSequence)parameterList.getText()));
        builder.append(" ->");
        GrOpenBlock block = method.getBlock();
        builder.append(block.getText().substring(1));
        GrVariableDeclaration variableDeclaration = GroovyPsiElementFactory.getInstance(method.getProject()).createFieldDeclarationFromText(builder.toString());
        method.replace(variableDeclaration);
        for (GrReferenceExpression element : usagesToConvert) {
            PsiElement qualifier = element.getQualifier();
            StringBuilder text = new StringBuilder(qualifier.getText());
            element.setQualifier(null);
            text.append('.').append(element.getText());
            element.replace(factory.createExpressionFromText(text.toString()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertMethodToClosureIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrMethod method;
            if (element == null) {
                MyPredicate.$$$reportNull$$$0(0);
            }
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            PsiReference ref2 = element.getReference();
            if (ref2 != null) {
                PsiElement resolved = ref2.resolve();
                if (!(resolved instanceof GrMethod)) {
                    return false;
                }
                method = (GrMethod)resolved;
            } else {
                PsiElement parent2 = element.getParent();
                if (!(parent2 instanceof GrMethod)) {
                    return false;
                }
                if (((GrMethod)parent2).getNameIdentifierGroovy() != element) {
                    return false;
                }
                method = (GrMethod)parent2;
            }
            return !method.isConstructor() && StringUtil.isJavaIdentifier((String)method.getName()) && method.hasBlock() && method.getParent() instanceof GrTypeDefinitionBody;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertMethodToClosureIntention$MyPredicate", "satisfiedBy"));
        }
    }
}

