/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrParameterStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class GrParameterImpl
extends GrVariableBaseImpl<GrParameterStub>
implements GrParameter {
    public GrParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrParameterImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrParameterImpl(GrParameterStub stub) {
        super(stub, GroovyStubElementTypes.PARAMETER);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrParameterImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitParameter(this);
    }

    public String toString() {
        return "Parameter";
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        PsiType declaredType = this.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        if (this.isVarArgs()) {
            PsiClassType type2 = TypesUtil.getJavaLangObject(this);
            return new PsiEllipsisType((PsiType)type2);
        }
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrForInClause) {
            GrExpression iteratedExpression = ((GrForInClause)parent2).getIteratedExpression();
            if (iteratedExpression == null) {
                return null;
            }
            PsiType result2 = ClosureParameterEnhancer.findTypeForIteration(iteratedExpression, (PsiElement)this);
            if (result2 != null) {
                return result2;
            }
        } else {
            if (parent2 instanceof GrTraditionalForClause) {
                return super.getTypeGroovy();
            }
            if (parent2 instanceof GrCatchClause) {
                return TypesUtil.createTypeByFQClassName("java.lang.Exception", this);
            }
        }
        return GrVariableEnhancer.getEnhancedType(this);
    }

    @Override
    public PsiType getDeclaredType() {
        PsiType type2 = super.getDeclaredType();
        if (this.isVarArgs()) {
            if (type2 == null) {
                type2 = TypesUtil.getJavaLangObject(this);
            }
            return new PsiEllipsisType(type2);
        }
        return type2;
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (this.isMainMethodFirstUntypedParameter()) {
            PsiType psiType = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement("java.lang.String[]", this).getType();
            if (psiType == null) {
                GrParameterImpl.$$$reportNull$$$0(2);
            }
            return psiType;
        }
        PsiType psiType = super.getType();
        if (psiType == null) {
            GrParameterImpl.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    private boolean isMainMethodFirstUntypedParameter() {
        if (this.getTypeElementGroovy() != null) {
            return false;
        }
        PsiElement psiElement = this.getParent();
        if (!(psiElement instanceof GrParameterList)) {
            return false;
        }
        GrParameterList parameterList = (GrParameterList)psiElement;
        if (this.isOptional()) {
            return false;
        }
        PsiElement psiElement2 = parameterList.getParent();
        if (!(psiElement2 instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)psiElement2;
        return PsiImplUtil.isMainMethod(method);
    }

    @Override
    public void setType(@Nullable PsiType type2) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type2 == null) {
            if (typeElement != null) {
                typeElement.delete();
            }
            return;
        }
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            GrModifierList modifierList = this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(newTypeElement, modifierList);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public boolean isOptional() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.hasInitializer(stub.getFlags());
        }
        return this.getInitializerGroovy() != null;
    }

    @Override
    @Nullable
    public PsiElement getEllipsisDots() {
        return this.findChildByType(GroovyTokenTypes.mTRIPLE_DOT);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrDocCommentOwner owner;
        GrDocComment comment;
        if (!this.isPhysical()) {
            PsiFile file = this.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null) {
                return new LocalSearchScope(context);
            }
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                GrParameterImpl.$$$reportNull$$$0(4);
            }
            return searchScope;
        }
        PsiElement scope = this.getDeclarationScope();
        if (scope instanceof GrDocCommentOwner && (comment = (owner = (GrDocCommentOwner)scope).getDocComment()) != null) {
            return new LocalSearchScope(new PsiElement[]{scope, comment});
        }
        return new LocalSearchScope(scope);
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)this.getRequiredStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
        if (grModifierList == null) {
            GrParameterImpl.$$$reportNull$$$0(5);
        }
        return grModifierList;
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = Objects.requireNonNull((GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrParametersOwner.class));
        if (psiElement == null) {
            GrParameterImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public boolean isVarArgs() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.isVarRags(stub.getFlags());
        }
        PsiElement dots = this.getEllipsisDots();
        return dots != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

