/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public final class GroovyInlineMethodUtil {
    private GroovyInlineMethodUtil() {
    }

    @NotNull
    public static InlineHandler.Settings inlineMethodSettings(GrMethod method, Editor editor, boolean invokedOnReference) {
        Project project = method.getProject();
        if (method.isConstructor()) {
            String message = GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.constructors", GroovyInlineMethodUtil.getRefactoringName());
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            if (settings == null) {
                GroovyInlineMethodUtil.$$$reportNull$$$0(0);
            }
            return settings;
        }
        if (invokedOnReference) {
            String message;
            PsiElement psiElement;
            PsiReference reference;
            PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
            if (reference == null) {
                InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                if (settings == null) {
                    GroovyInlineMethodUtil.$$$reportNull$$$0(1);
                }
                return settings;
            }
            PsiElement element = reference.getElement();
            if (!(element instanceof GrExpression) || !((psiElement = element.getParent()) instanceof GrCallExpression)) {
                message = GroovyRefactoringBundle.message("refactoring.is.available.only.for.method.calls", GroovyInlineMethodUtil.getRefactoringName());
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                if (settings == null) {
                    GroovyInlineMethodUtil.$$$reportNull$$$0(2);
                }
                return settings;
            }
            GrCallExpression call = (GrCallExpression)psiElement;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, GrParameter.class) != null) {
                message = GroovyRefactoringBundle.message("refactoring.is.not.supported.in.parameter.initializers", GroovyInlineMethodUtil.getRefactoringName());
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                if (settings == null) {
                    GroovyInlineMethodUtil.$$$reportNull$$$0(3);
                }
                return settings;
            }
            GroovyRefactoringUtil.highlightOccurrences(project, editor, new GrExpression[]{call});
            if (GroovyInlineMethodUtil.hasBadReturns(method) && !GroovyInlineMethodUtil.isTailMethodCall(call)) {
                message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", GroovyInlineMethodUtil.getRefactoringName());
                GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
                InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                if (settings == null) {
                    GroovyInlineMethodUtil.$$$reportNull$$$0(4);
                }
                return settings;
            }
        } else if (GroovyInlineMethodUtil.hasBadReturns(method)) {
            String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", GroovyInlineMethodUtil.getRefactoringName());
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            if (settings == null) {
                GroovyInlineMethodUtil.$$$reportNull$$$0(5);
            }
            return settings;
        }
        if (method.getBlock() == null) {
            String message = method.hasModifierProperty("abstract") ? GroovyRefactoringBundle.message("refactoring.cannot.be.applied.to.abstract.methods", GroovyInlineMethodUtil.getRefactoringName()) : GroovyRefactoringBundle.message("refactoring.cannot.be.applied.no.sources.attached", GroovyInlineMethodUtil.getRefactoringName());
            GroovyInlineMethodUtil.showErrorMessage(message, project, editor);
            InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            if (settings == null) {
                GroovyInlineMethodUtil.$$$reportNull$$$0(6);
            }
            return settings;
        }
        return GroovyInlineMethodUtil.inlineMethodDialogResult(method, project, invokedOnReference);
    }

    static boolean isTailMethodCall(GrCallExpression call) {
        GrMethod method;
        GrStatement stmt = call;
        PsiElement parent2 = call.getParent();
        if (parent2 instanceof GrReturnStatement) {
            stmt = (GrReturnStatement)parent2;
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof GrOpenBlock && parent2.getParent() instanceof GrMethod) {
            GrStatement[] statements2 = ((GrOpenBlock)parent2).getStatements();
            return statements2.length > 0 && stmt == statements2[statements2.length - 1];
        }
        if (parent2 instanceof GrClosableBlock) {
            GrStatement[] statements3 = ((GrClosableBlock)parent2).getStatements();
            return statements3.length > 0 && stmt == statements3[statements3.length - 1];
        }
        if (stmt instanceof GrReturnStatement && (method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)stmt, GrMethod.class)) != null) {
            List<GrStatement> returnStatements = ControlFlowUtils.collectReturns(method.getBlock());
            return returnStatements.contains(stmt) && !GroovyInlineMethodUtil.hasBadReturns(method);
        }
        return false;
    }

    @NotNull
    private static InlineHandler.Settings inlineMethodDialogResult(GrMethod method, Project project, boolean invokedOnReference) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            final InlineMethodDialog dialog = new InlineMethodDialog(project, method, invokedOnReference, GroovyInlineMethodUtil.checkMethodForRecursion(method));
            if (!dialog.showAndGet()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
                InlineHandler.Settings settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                if (settings == null) {
                    GroovyInlineMethodUtil.$$$reportNull$$$0(7);
                }
                return settings;
            }
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return dialog.isInlineThisOnly();
                }
            };
        }
        return new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return true;
            }
        };
    }

    private static boolean hasBadReturns(GrMethod method) {
        List<GrStatement> returnStatements = ControlFlowUtils.collectReturns(method.getBlock());
        GrOpenBlock block = method.getBlock();
        if (block == null || returnStatements.isEmpty()) {
            return false;
        }
        boolean checked = GroovyInlineMethodUtil.checkTailOpenBlock(block, returnStatements);
        return !checked || !returnStatements.isEmpty();
    }

    public static boolean checkTailIfStatement(GrIfStatement ifStatement, Collection<GrStatement> returnStatements) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return false;
        }
        boolean tb = false;
        boolean eb = false;
        if (thenBranch instanceof GrReturnStatement) {
            tb = returnStatements.remove(thenBranch);
        } else if (thenBranch instanceof GrBlockStatement) {
            tb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)thenBranch).getBlock(), returnStatements);
        }
        if (elseBranch instanceof GrReturnStatement) {
            eb = returnStatements.remove(elseBranch);
        } else if (elseBranch instanceof GrBlockStatement) {
            eb = GroovyInlineMethodUtil.checkTailOpenBlock(((GrBlockStatement)elseBranch).getBlock(), returnStatements);
        }
        return tb && eb;
    }

    private static boolean checkTailOpenBlock(GrOpenBlock block, Collection<GrStatement> returnStatements) {
        if (block == null) {
            return false;
        }
        GrStatement[] statements2 = block.getStatements();
        if (statements2.length == 0) {
            return false;
        }
        GrStatement last = statements2[statements2.length - 1];
        if (returnStatements.contains(last)) {
            returnStatements.remove(last);
            return true;
        }
        if (last instanceof GrIfStatement) {
            return GroovyInlineMethodUtil.checkTailIfStatement((GrIfStatement)last, returnStatements);
        }
        return false;
    }

    private static void showErrorMessage(@NlsContexts.DialogMessage String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)GroovyInlineMethodUtil.getRefactoringName(), (String)"refactoring.inlineMethod");
    }

    public static Collection<ReferenceExpressionInfo> collectReferenceInfo(GrMethod method) {
        ArrayList<ReferenceExpressionInfo> list = new ArrayList<ReferenceExpressionInfo>();
        GroovyInlineMethodUtil.collectReferenceInfoImpl(list, method, method);
        return list;
    }

    private static void collectReferenceInfoImpl(Collection<ReferenceExpressionInfo> infos, PsiElement elem, GrMethod method) {
        PsiElement declaration;
        GrReferenceExpression expr;
        PsiReference ref2;
        if (elem instanceof GrReferenceExpression && (ref2 = (expr = (GrReferenceExpression)elem).getReference()) != null && (declaration = ref2.resolve()) instanceof GrMember) {
            GrMember member = (GrMember)declaration;
            int offsetInMethod = expr.getTextRange().getStartOffset() - method.getTextRange().getStartOffset();
            infos.add(new ReferenceExpressionInfo(expr, offsetInMethod, member, member.getContainingClass()));
        }
        for (PsiElement element : elem.getChildren()) {
            GroovyInlineMethodUtil.collectReferenceInfoImpl(infos, element, method);
        }
    }

    public static boolean isSimpleReference(GrExpression qualifier) {
        if (!(qualifier instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qual = ((GrReferenceExpression)qualifier).getQualifierExpression();
        return qual == null || GroovyInlineMethodUtil.isSimpleReference(qual);
    }

    static void addQualifiersToInnerReferences(GrMethod method, Collection<? extends ReferenceExpressionInfo> infos, @NotNull GrExpression qualifier) throws IncorrectOperationException {
        if (qualifier == null) {
            GroovyInlineMethodUtil.$$$reportNull$$$0(8);
        }
        HashSet<GrReferenceExpression> exprs = new HashSet<GrReferenceExpression>();
        for (ReferenceExpressionInfo referenceExpressionInfo : infos) {
            GrReferenceExpression refExpr;
            PsiElement psiElement;
            PsiReference ref2 = method.findReferenceAt(referenceExpressionInfo.offsetInMethod);
            if (ref2 == null || !((psiElement = ref2.getElement()) instanceof GrReferenceExpression) || (refExpr = (GrReferenceExpression)psiElement).getQualifierExpression() != null) continue;
            exprs.add(refExpr);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(qualifier.getProject());
        for (GrReferenceExpression expr : exprs) {
            GrExpression qual = factory.createExpressionFromText(qualifier.getText());
            expr.setQualifier(qual);
        }
    }

    private static boolean checkMethodForRecursion(GrMethod method) {
        return GroovyInlineMethodUtil.checkCalls(method.getBlock(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethod refMethod;
        if (scope instanceof GrMethodCall && method.equals(refMethod = ((GrMethodCall)scope).resolveMethod())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!GroovyInlineMethodUtil.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static void replaceParametersWithArguments(GrCallExpression call, GrMethod method) throws IncorrectOperationException {
        GrParameter[] parameters2 = method.getParameters();
        if (parameters2.length == 0) {
            return;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (argumentList == null) {
            GroovyInlineMethodUtil.setDefaultValuesToParameters(method, null, call);
            return;
        }
        Project project = call.getProject();
        GroovyResolveResult resolveResult2 = call.advancedResolve();
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, resolveResult2.getSubstitutor());
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] infos = GrClosureSignatureUtil.mapParametersToArguments(signature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), call, true, false);
        if (infos == null) {
            return;
        }
        for (int i2 = 0; i2 < infos.length; ++i2) {
            GrParameter parameter = parameters2[i2];
            GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = infos[i2];
            GrExpression arg = GroovyInlineMethodUtil.inferArg(signature, parameters2, parameter, argInfo, project);
            if (arg == null) continue;
            GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, arg, parameter);
        }
    }

    @Nullable
    private static GrExpression inferArg(GrSignature signature, GrParameter[] parameters2, GrParameter parameter, GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo, Project project) {
        if (argInfo == null) {
            return null;
        }
        List arguments2 = argInfo.args;
        if (argInfo.isMultiArg) {
            PsiType type2 = parameter.getDeclaredType();
            return GroovyRefactoringUtil.generateArgFromMultiArg(signature.getSubstitutor(), arguments2, type2, project);
        }
        if (arguments2.size() == 1) {
            GrExpression expr;
            PsiElement arg = (PsiElement)arguments2.iterator().next();
            if (GroovyInlineMethodUtil.isVararg(parameter, parameters2) && arg instanceof GrSafeCastExpression && (expr = ((GrSafeCastExpression)arg).getOperand()) instanceof GrListOrMap && !((GrListOrMap)expr).isMap()) {
                return (GrListOrMap)expr;
            }
            return (GrExpression)arg;
        }
        return parameter.getInitializerGroovy();
    }

    private static boolean isVararg(GrParameter p, GrParameter[] parameters2) {
        return parameters2[parameters2.length - 1] == p && p.getType() instanceof PsiArrayType;
    }

    private static void setDefaultValuesToParameters(GrMethod method, @Nullable Collection<String> nameFilter, GrCallExpression call) throws IncorrectOperationException {
        GrParameter[] parameters2;
        if (nameFilter == null) {
            nameFilter = new ArrayList<String>();
            for (GrParameter parameter : method.getParameters()) {
                nameFilter.add(parameter.getName());
            }
        }
        for (GrParameter parameter : parameters2 = method.getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null || !nameFilter.contains(parameter.getName())) continue;
            GroovyInlineMethodUtil.replaceAllOccurrencesWithExpression(method, call, initializer, parameter);
        }
    }

    private static void replaceAllOccurrencesWithExpression(GrMethod method, GrCallExpression call, GrExpression oldExpression, GrParameter parameter) {
        Collection refs = ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)method), (boolean)false).findAll();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(call.getProject());
        GrExpression expression = elementFactory.createExpressionFromText(oldExpression.getText());
        if (GroovyRefactoringUtil.hasSideEffect(expression) && refs.size() > 1 || !GroovyInlineMethodUtil.hasUnresolvableWriteAccess(refs, oldExpression)) {
            String oldName = parameter.getName();
            String newName = InlineMethodConflictSolver.suggestNewName(oldName, method, call, new String[0]);
            expression = elementFactory.createExpressionFromText(newName);
            GrOpenBlock body = method.getBlock();
            GrStatement[] statements2 = body.getStatements();
            GrStatement anchor = null;
            if (statements2.length > 0) {
                anchor = statements2[0];
            }
            body.addStatementBefore(elementFactory.createStatementFromText(GroovyInlineMethodUtil.createVariableDefinitionText(parameter, oldExpression, newName)), anchor);
        }
        for (PsiReference ref2 : refs) {
            PsiElement element = ref2.getElement();
            if (!(element instanceof GrReferenceExpression)) continue;
            ((GrReferenceExpression)element).replaceWithExpression(expression, true);
        }
    }

    private static String createVariableDefinitionText(GrParameter parameter, GrExpression expression, String varName) {
        GrTypeElement typeElement;
        StringBuilder buffer = new StringBuilder();
        GrModifierList modifierList = parameter.getModifierList();
        buffer.append(modifierList.getText().trim());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        if ((typeElement = parameter.getTypeElementGroovy()) != null) {
            buffer.append(typeElement.getText()).append(' ');
        }
        if (buffer.length() == 0) {
            buffer.append("def ");
        }
        buffer.append(varName).append(" = ").append(expression.getText());
        return buffer.toString();
    }

    private static boolean containsWriteAccess(Collection<PsiReference> refs) {
        for (PsiReference ref2 : refs) {
            PsiElement element = ref2.getElement();
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == element) {
                return true;
            }
            if (!(parent2 instanceof GrUnaryExpression)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnresolvableWriteAccess(Collection<PsiReference> refs, GrExpression expression) {
        if (GroovyInlineMethodUtil.containsWriteAccess(refs)) {
            boolean isFinal;
            PsiElement resolved;
            if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof GrVariable && !(resolved instanceof PsiField) && !(isFinal = ((GrVariable)resolved).hasModifierProperty("final"))) {
                PsiReference lastRef = Collections.max(ReferencesSearch.search((PsiElement)resolved).findAll(), Comparator.comparingInt(o -> o.getElement().getTextRange().getStartOffset()));
                return lastRef.getElement() == expression;
            }
            return false;
        }
        return true;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getRefactoringName() {
        return GroovyRefactoringBundle.message("inline.method.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineMethodSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineMethodDialogResult";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineMethodUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addQualifiersToInnerReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8 -> new IllegalArgumentException(string);
        };
    }

    static class InlineMethodDialog
    extends InlineOptionsDialog {
        private final boolean myAllowInlineThisOnly;
        private final PsiMethod myMethod;

        InlineMethodDialog(Project project, PsiMethod method, boolean invokedOnReference, boolean allowInlineThisOnly) {
            super(project, true, (PsiElement)method);
            this.myMethod = method;
            this.myAllowInlineThisOnly = allowInlineThisOnly;
            this.myInvokedOnReference = invokedOnReference;
            this.setTitle(GroovyInlineMethodUtil.getRefactoringName());
            this.init();
        }

        protected String getBorderTitle() {
            return GroovyRefactoringBundle.message("inline.method.border.title", new Object[0]);
        }

        protected String getNameLabelText() {
            return GroovyRefactoringBundle.message("inline.method.label", GroovyRefactoringUtil.getMethodSignature(this.myMethod));
        }

        protected String getInlineAllText() {
            return this.myMethod.isWritable() ? GroovyRefactoringBundle.message("all.invocations.and.remove.the.method", new Object[0]) : GroovyRefactoringBundle.message("all.invocations.in.project", new Object[0]);
        }

        protected String getInlineThisText() {
            return GroovyRefactoringBundle.message("this.invocation.only.and.keep.the.method", new Object[0]);
        }

        protected boolean isInlineThis() {
            return false;
        }

        protected void doAction() {
            if (this.getOKAction().isEnabled()) {
                this.close(0);
            }
        }

        protected String getHelpId() {
            return "refactoring.inlineMethod";
        }

        protected boolean canInlineThisOnly() {
            return this.myAllowInlineThisOnly;
        }
    }

    static class ReferenceExpressionInfo {
        public final PsiMember declaration;
        public final GrReferenceExpression expression;
        public final int offsetInMethod;
        public final PsiClass containingClass;

        @Nullable
        @Nls
        public String getPresentation() {
            return this.declaration.getName();
        }

        public boolean isStatic() {
            return this.declaration.hasModifierProperty("static");
        }

        ReferenceExpressionInfo(GrReferenceExpression expression, int offsetInMethod, PsiMember declaration, PsiClass containingClass) {
            this.expression = expression;
            this.offsetInMethod = offsetInMethod;
            this.declaration = declaration;
            this.containingClass = containingClass;
        }
    }
}

