/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.GradleDependencyResolver;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.CopySpecWalker;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarConfigurationImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ear.EarResourceImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JU\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004H\u0016JE\u0010\u001d\u001a\u00020\b2\u000b\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001e2\u000b\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001e2\u000b\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001e2\u0014\u0010\u001f\u001a\u00100 j\u0007`!\u00a2\u0006\u0002\b\u001e\u00a2\u0006\u0002\b\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/EarModelBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "()V", "APP_DIR_PROPERTY", "", "is82OrBetter", "", "addPath", "", "buildDirPath", "earResources", "", "Lorg/jetbrains/plugins/gradle/model/ear/EarConfiguration$EarResource;", "earRelativePath", "fileRelativePath", "file", "Ljava/io/File;", "earConfigurations", "", "Lorg/gradle/api/artifacts/Configuration;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;[Lorg/gradle/api/artifacts/Configuration;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "canBuild", "reportErrorMessage", "Lorg/jetbrains/annotations/NotNull;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
public final class EarModelBuilderImpl
extends AbstractModelBuilderService {
    @NotNull
    private final String APP_DIR_PROPERTY;
    private final boolean is82OrBetter = GradleVersionUtil.isCurrentGradleAtLeast((String)"8.2");

    public EarModelBuilderImpl() {
        this.APP_DIR_PROPERTY = "appDirName";
    }

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)EarConfiguration.class.getName(), (Object)modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EarPlugin earPlugin = (EarPlugin)project.getPlugins().findPlugin(EarPlugin.class);
        if (earPlugin == null) {
            return null;
        }
        ArrayList<EarModelImpl> earModels = new ArrayList<EarModelImpl>();
        Configuration deployConfiguration = (Configuration)project.getConfigurations().findByName("deploy");
        Configuration earlibConfiguration = (Configuration)project.getConfigurations().findByName("earlib");
        GradleDependencyResolver dependencyResolver = new GradleDependencyResolver(context, project, GradleDependencyDownloadPolicy.NONE);
        Collection<ExternalDependency> collection = dependencyResolver.resolveDependencies(deployConfiguration);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveDependencies(...)");
        Collection<ExternalDependency> deployDependencies = collection;
        Collection<ExternalDependency> collection2 = dependencyResolver.resolveDependencies(earlibConfiguration);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"resolveDependencies(...)");
        Collection<ExternalDependency> earlibDependencies = collection2;
        String buildDirPath = GradleProjectUtil.getBuildDirectory(project).getAbsolutePath();
        for (Task task : project.getTasks()) {
            if (!(task instanceof Ear)) continue;
            String appDirName = null;
            if (this.is82OrBetter) {
                Object appDirectoryLocation = GradleReflectionUtil.reflectiveGetProperty((Object)task, (String)"getAppDirectory", Object.class);
                String string = ((File)GradleReflectionUtil.reflectiveCall((Object)appDirectoryLocation, (String)"getAsFile", File.class)).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                appDirName = string;
            } else {
                appDirName = !project.hasProperty(this.APP_DIR_PROPERTY) ? "src/main/application" : String.valueOf(project.property(this.APP_DIR_PROPERTY));
            }
            String string = GradleTaskUtil.getTaskArchiveFileName((AbstractArchiveTask)task);
            Intrinsics.checkNotNull((Object)string);
            EarModelImpl earModel = new EarModelImpl(string, appDirName, ((Ear)task).getLibDirName());
            ArrayList<EarConfiguration.EarResource> earResources = new ArrayList<EarConfiguration.EarResource>();
            Ear earTask = (Ear)task;
            try {
                CopySpecWalker.walk((CopySpec)earTask.getRootSpec(), new CopySpecWalker.Visitor(this, buildDirPath, earResources, earTask, deployConfiguration, earlibConfiguration){
                    final /* synthetic */ EarModelBuilderImpl this$0;
                    final /* synthetic */ String $buildDirPath;
                    final /* synthetic */ ArrayList<EarConfiguration.EarResource> $earResources;
                    final /* synthetic */ Ear $earTask;
                    final /* synthetic */ Configuration $deployConfiguration;
                    final /* synthetic */ Configuration $earlibConfiguration;
                    {
                        this.this$0 = $receiver;
                        this.$buildDirPath = $buildDirPath;
                        this.$earResources = $earResources;
                        this.$earTask = $earTask;
                        this.$deployConfiguration = $deployConfiguration;
                        this.$earlibConfiguration = $earlibConfiguration;
                    }

                    public void visitSourcePath(@NotNull String relativePath, @NotNull String path) {
                        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        File file = new File(path);
                        String string = this.$buildDirPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$buildDirPath");
                        Configuration[] configurationArray = new Configuration[]{this.$deployConfiguration, this.$earlibConfiguration};
                        EarModelBuilderImpl.access$addPath(this.this$0, string, this.$earResources, relativePath, "", file.isAbsolute() ? file : new File(this.$earTask.getProject().getProjectDir(), path), configurationArray);
                    }

                    public void visitDir(@NotNull String relativePath, @NotNull FileVisitDetails dirDetails) {
                        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                        Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
                        String string = this.$buildDirPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$buildDirPath");
                        List list = this.$earResources;
                        String string2 = dirDetails.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        File file = dirDetails.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        Configuration[] configurationArray = new Configuration[]{this.$deployConfiguration, this.$earlibConfiguration};
                        EarModelBuilderImpl.access$addPath(this.this$0, string, list, relativePath, string2, file, configurationArray);
                    }

                    public void visitFile(@NotNull String relativePath, @NotNull FileVisitDetails fileDetails) {
                        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                        Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
                        String string = this.$buildDirPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$buildDirPath");
                        List list = this.$earResources;
                        String string2 = fileDetails.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        File file = fileDetails.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        Configuration[] configurationArray = new Configuration[]{this.$deployConfiguration, this.$earlibConfiguration};
                        EarModelBuilderImpl.access$addPath(this.this$0, string, list, relativePath, string2, file, configurationArray);
                    }
                });
            }
            catch (Exception e) {
                this.reportErrorMessage(modelName, project, context, e);
            }
            earModel.setResources((List<EarConfiguration.EarResource>)earResources);
            DeploymentDescriptor deploymentDescriptor = earTask.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                StringWriter writer = new StringWriter();
                deploymentDescriptor.writeTo((Writer)writer);
                earModel.setDeploymentDescriptor(writer.toString());
            }
            earModel.setArchivePath(GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)earTask));
            Manifest manifest = earTask.getManifest();
            if (manifest instanceof ManifestInternal) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ((ManifestInternal)manifest).writeTo((OutputStream)outputStream);
                String contentCharset = ((ManifestInternal)manifest).getContentCharset();
                earModel.setManifestContent(outputStream.toString(contentCharset));
            }
            earModels.add(earModel);
        }
        return new EarConfigurationImpl((List<? extends EarConfiguration.EarModel>)earModels, deployDependencies, earlibDependencies);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.earConfigurationModel.group").withKind(Message.Kind.WARNING).withTitle("JEE project import failure").withText("Ear Artifacts may not be configured properly").withException(exception).reportMessage(project);
    }

    private final void addPath(String buildDirPath, List<EarConfiguration.EarResource> earResources, String earRelativePath, String fileRelativePath, File file, Configuration ... earConfigurations) {
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (StringsKt.startsWith$default((String)string, (String)buildDirPath, (boolean)false, (int)2, null)) {
            return;
        }
        for (Configuration conf : earConfigurations) {
            Object object = conf;
            boolean bl = object != null && (object = object.getFiles()) != null ? object.contains(file) : false;
            if (!bl) continue;
            return;
        }
        String string2 = earRelativePath;
        if (string2 == null) {
            string2 = "";
        }
        EarResourceImpl earResource = new EarResourceImpl(string2, fileRelativePath, file);
        earResources.add(earResource);
    }

    public static final /* synthetic */ void access$addPath(EarModelBuilderImpl $this, String buildDirPath, List earResources, String earRelativePath, String fileRelativePath, File file, Configuration ... earConfigurations) {
        $this.addPath(buildDirPath, earResources, earRelativePath, fileRelativePath, file, earConfigurations);
    }
}

