/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.util.DiffChangedRangeProvider;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.find.FindModel;
import com.intellij.find.impl.livePreview.EditorSearchAreaProvider;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/diff/impl/SearchInDiffChangesProvider;", "Lcom/intellij/find/impl/livePreview/EditorSearchAreaProvider;", "()V", "getSearchArea", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchArea;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findModel", "Lcom/intellij/find/FindModel;", "isEnabled", "", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nSearchInDiffChangesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchInDiffChangesProvider.kt\ncom/intellij/openapi/diff/impl/SearchInDiffChangesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1864#2,3:41\n*S KotlinDebug\n*F\n+ 1 SearchInDiffChangesProvider.kt\ncom/intellij/openapi/diff/impl/SearchInDiffChangesProvider\n*L\n33#1:41,3\n*E\n"})
public final class SearchInDiffChangesProvider
implements EditorSearchAreaProvider {
    public boolean isEnabled(@NotNull Editor editor, @NotNull FindModel findModel) {
        UserDataHolder[] userDataHolderArray;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        if (editor.isDisposed()) {
            return false;
        }
        if (findModel.isReplaceState()) {
            return false;
        }
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null || (editorEx = editorEx.getDataContext()) == null) {
            return false;
        }
        EditorEx dataContext = editorEx;
        DiffContext diffContext = (DiffContext)dataContext.getData(DiffDataKeys.DIFF_CONTEXT);
        DiffChangedRangeProvider changedRangeProvider = (DiffChangedRangeProvider)dataContext.getData(DiffDataKeys.EDITOR_CHANGED_RANGE_PROVIDER);
        return diffContext != null && changedRangeProvider != null && DiffUtil.isUserDataFlagSet((Key)DiffUserDataKeys.ENABLE_SEARCH_IN_CHANGES, (UserDataHolder[])(userDataHolderArray = new UserDataHolder[]{diffContext}));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SearchResults.SearchArea getSearchArea(@NotNull Editor editor, @NotNull FindModel findModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null || (editorEx = editorEx.getDataContext()) == null) {
            return null;
        }
        EditorEx dataContext = editorEx;
        DiffChangedRangeProvider diffChangedRangeProvider = (DiffChangedRangeProvider)dataContext.getData(DiffDataKeys.EDITOR_CHANGED_RANGE_PROVIDER);
        if (diffChangedRangeProvider == null) {
            return null;
        }
        DiffChangedRangeProvider changedRangeProvider = diffChangedRangeProvider;
        List list = changedRangeProvider.getChangedRanges(editor);
        if (list == null) {
            return null;
        }
        List changedRanges = list;
        int[] starts = new int[changedRanges.size()];
        int[] ends = new int[changedRanges.size()];
        Iterable $this$forEachIndexed$iv = changedRanges;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void range;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextRange textRange = (TextRange)item$iv;
            int index = n;
            boolean bl = false;
            starts[index] = range.getStartOffset();
            ends[index] = range.getEndOffset();
        }
        return SearchResults.SearchArea.create((int[])starts, (int[])ends);
    }
}

