/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class AffectedPathSet {
    private final Set<CharSequence> myDirectParents;
    private final Set<CharSequence> myAllPaths;

    AffectedPathSet(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            AffectedPathSet.$$$reportNull$$$0(0);
        }
        this.myDirectParents = CollectionFactory.createCharSequenceSet((boolean)SystemInfoRt.isFileSystemCaseSensitive);
        this.myAllPaths = CollectionFactory.createCharSequenceSet((boolean)SystemInfoRt.isFileSystemCaseSensitive);
        for (FilePath path2 : paths) {
            this.add(path2);
        }
    }

    private void add(@NotNull FilePath filePath) {
        boolean wasAdded;
        CharSequence parent;
        if (filePath == null) {
            AffectedPathSet.$$$reportNull$$$0(1);
        }
        if ((parent = PathUtilRt.getParentPathSequence((CharSequence)new CharSequenceSubSequence((CharSequence)filePath.getPath()))).isEmpty()) {
            return;
        }
        this.myDirectParents.add(parent);
        while (!parent.isEmpty() && (wasAdded = this.myAllPaths.add(parent))) {
            parent = PathUtilRt.getParentPathSequence((CharSequence)parent);
        }
    }

    @NotNull
    public ThreeState haveChangesUnder(@NotNull FilePath filePath) {
        String path2;
        if (filePath == null) {
            AffectedPathSet.$$$reportNull$$$0(2);
        }
        if (this.myDirectParents.contains(path2 = filePath.getPath())) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                AffectedPathSet.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if (this.myAllPaths.contains(path2)) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AffectedPathSet.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            AffectedPathSet.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/AffectedPathSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/AffectedPathSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

