/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RUN_CONFIGURATIONS_DIRECTORY", "", "checkConfigurationVcsIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "project", "Lcom/intellij/openapi/project/Project;", "configurationFileName", "checkProjectNotDefault", "", "configurationNameToFileName", "configurationName", "getCheckerForFile", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "removeConfigurationFromVcsIgnore", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImplKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RUN_CONFIGURATIONS_DIRECTORY = "runConfigurations";

    private static final void removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            Path path2 = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            Intrinsics.checkNotNull((Object)path2);
            VirtualFile virtualFile2 = VfsUtil.findFile((Path)path2, (boolean)true);
            virtualFile = virtualFile2;
            Intrinsics.checkNotNull((Object)virtualFile2);
        } else {
            VirtualFile virtualFile3 = project.getProjectFile();
            virtualFile = virtualFile3;
            Intrinsics.checkNotNull((Object)virtualFile3);
        }
        VirtualFile virtualFile4 = virtualFile;
        Intrinsics.checkNotNull((Object)virtualFile4);
        VirtualFile projectFileOrConfigDir = virtualFile4;
        VirtualFile virtualFile5 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFileOrConfigDir);
        if (virtualFile5 == null) {
            return;
        }
        VirtualFile projectVcsRoot = virtualFile5;
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectVcsRoot);
        if (vcs == null) {
            LOG.debug("Cannot get VCS for root " + projectVcsRoot.getPath());
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        IgnoredCheckResult checkResult = VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationName);
        if (checkResult instanceof Ignored) {
            File ignoreFile2 = ((Ignored)checkResult).getIgnoreFile();
            FileUtil.appendToFile((File)ignoreFile2, (String)ignoreContentProvider.buildUnignoreContent(((Ignored)checkResult).getMatchedPattern()));
        }
    }

    private static final IgnoredCheckResult checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        IProjectStore stateStore = ProjectKt.getStateStore((Project)project);
        Path dotIdea = stateStore.getDirectoryStorePath();
        if (dotIdea != null) {
            FilePath filePath = VcsContextFactory.getInstance().createFilePath(dotIdea, true);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
            FilePath dotIdeaVcsPath = filePath;
            VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)dotIdeaVcsPath);
            if (virtualFile == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            VirtualFile vcsRootForIgnore = virtualFile;
            String filePattern = PathsKt.getInvariantSeparatorsPathString((Path)dotIdea) + "/runConfigurations/" + configurationFileName + "*.xml";
            VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, dotIdeaVcsPath);
            IgnoredCheckResult ignoredCheckResult = vcsIgnoreChecker != null ? vcsIgnoreChecker.isFilePatternIgnored(vcsRootForIgnore, filePattern) : null;
            return ignoredCheckResult == null ? (IgnoredCheckResult)NotIgnored.INSTANCE : ignoredCheckResult;
        }
        Path path2 = stateStore.getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getProjectFilePath(...)");
        Path projectFile = path2;
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(projectFile, false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
        FilePath projectFileVcsPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)projectFileVcsPath);
        if (virtualFile == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        VirtualFile vcsRootForIgnore = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, projectFileVcsPath);
        IgnoredCheckResult ignoredCheckResult = vcsIgnoreChecker != null ? vcsIgnoreChecker.isIgnored(vcsRootForIgnore, projectFile) : null;
        return ignoredCheckResult == null ? (IgnoredCheckResult)NotIgnored.INSTANCE : ignoredCheckResult;
    }

    private static final VcsIgnoreChecker getCheckerForFile(Project project, FilePath filePath) {
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        return (VcsIgnoreChecker)VcsIgnoreManagerImpl.Companion.getEP_NAME().findFirstSafe(arg_0 -> VcsIgnoreManagerImplKt.getCheckerForFile$lambda$0((Function1)new Function1<VcsIgnoreChecker, Boolean>(vcs){
            final /* synthetic */ AbstractVcs $vcs;
            {
                this.$vcs = $vcs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VcsIgnoreChecker checker) {
                Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
                return Intrinsics.areEqual((Object)checker.getSupportedVcs(), (Object)this.$vcs.getKeyInstanceMethod());
            }
        }, arg_0));
    }

    private static final String configurationNameToFileName(String configurationName) {
        return (String)Scheme_implKt.getOLD_NAME_CONVERTER().invoke((Object)configurationName);
    }

    private static final void checkProjectNotDefault(Project project) {
        if (project.isDefault()) {
            throw new UnsupportedOperationException(VcsBundle.message((String)"changes.error.default.project.not.supported", (Object[])new Object[0]));
        }
    }

    private static final boolean getCheckerForFile$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$checkProjectNotDefault(Project project) {
        VcsIgnoreManagerImplKt.checkProjectNotDefault(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ VcsIgnoreChecker access$getCheckerForFile(Project project, FilePath filePath) {
        return VcsIgnoreManagerImplKt.getCheckerForFile(project, filePath);
    }

    public static final /* synthetic */ String access$configurationNameToFileName(String configurationName) {
        return VcsIgnoreManagerImplKt.configurationNameToFileName(configurationName);
    }

    public static final /* synthetic */ IgnoredCheckResult access$checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        return VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationFileName);
    }

    public static final /* synthetic */ void access$removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VcsIgnoreManagerImplKt.removeConfigurationFromVcsIgnore(project, configurationName);
    }

    static {
        Logger logger = Logger.getInstance(VcsIgnoreManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

