/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "update", "Manager", "intellij.platform.vcs.impl"})
public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (Intrinsics.areEqual((Object)"ActionPlace.VcsQuickListPopupAction", (Object)e.getPlace()) || Intrinsics.areEqual((Object)"ChangesViewPopup", (Object)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
        if (e.isFromActionToolbar() && e.getPresentation().getIcon() == null) {
            e.getPresentation().setIcon(AllIcons.General.Add);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list = Manager.INSTANCE.getUnversionedFiles(e, project2).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List unversionedFiles = list;
        Manager.INSTANCE.performUnversionedFilesAddition$intellij_platform_vcs_impl(project2, unversionedFiles, (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY), null);
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        return project != null && Manager.INSTANCE.getUnversionedFiles(e, project).isNotEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J`\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000e0\n\u0018\u00010\r2\u001e\u0010\u000f\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0011\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u0010H\u0007J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J`\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000e0\n\u0018\u00010\r2\u001e\u0010\u000f\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0011\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u0010H\u0007J@\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000e0\n\u0018\u00010\rH\u0007J\u001b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\nH\u0002J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0'H\u0002J\u001e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0002J \u0010+\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J@\u00100\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u00101\u001a\u0004\u0018\u00010\b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000e0\n\u0018\u00010\rH\u0002JF\u00103\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000e0\n0\r2\b\u00101\u001a\u0004\u0018\u00010\b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u00105\u001a\u00020\u0004H\u0002JM\u00106\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u00107\u001a\u0004\u0018\u0001082\u001e\u0010\u000f\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0011\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b9J2\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002JF\u0010:\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u00102\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0;2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0002\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction$Manager;", "", "()V", "addUnversionedFilesToVcs", "", "project", "Lcom/intellij/openapi/project/Project;", "targetChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "changesConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/vcs/changes/Change;", "additionalTask", "Lcom/intellij/util/PairConsumer;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "Lcom/intellij/openapi/vcs/VcsException;", "addUnversionedFilesToVcsInBackground", "", "addUnversionedFilesToVcsInSync", "createErrorMessage", "", "Lorg/jetbrains/annotations/Nls;", "exceptions", "getUnversionedDescendantsRecursively", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "items", "getUnversionedFiles", "Lcom/intellij/util/containers/JBIterable;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getUnversionedParents", "", "hasAncestorIn", "file", "roots", "isFileUnversioned", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "moveAddedChangesTo", "targetList", "allProcessedFiles", "notifyChangesConsumer", "newChanges", "rereadChanges", "performUnversionedFilesAddition", "browser", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "performUnversionedFilesAddition$intellij_platform_vcs_impl", "performUnversionedFilesAdditionForVcs", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nScheduleForAdditionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduleForAdditionAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction$Manager\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,340:1\n46#2,6:341\n24#2,6:347\n766#3:353\n857#3,2:354\n13#4:356\n1247#5,2:357\n*S KotlinDebug\n*F\n+ 1 ScheduleForAdditionAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction$Manager\n*L\n140#1:341,6\n186#1:347,6\n227#1:353\n227#1:354,2\n260#1:356\n309#1:357,2\n*E\n"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final void performUnversionedFilesAddition$intellij_platform_vcs_impl(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @Nullable ChangesBrowserBase browser, @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            if (files2.isEmpty() && additionalTask == null) {
                return;
            }
            LocalChangeList localChangeList = browser instanceof CommitDialogChangesBrowser ? ((CommitDialogChangesBrowser)browser).getSelectedChangeList() : ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            Intrinsics.checkNotNull((Object)localChangeList);
            LocalChangeList targetChangeList = localChangeList;
            Consumer changesConsumer = browser instanceof CommitDialogChangesBrowser ? arg_0 -> Manager.performUnversionedFilesAddition$lambda$0(browser, arg_0) : null;
            FileDocumentManager.getInstance().saveAllDocuments();
            if (Intrinsics.areEqual((Object)ModalityState.current(), (Object)ModalityState.nonModal())) {
                Manager.addUnversionedFilesToVcsInBackground(project, targetChangeList, files2, (Consumer<? super List<? extends Change>>)changesConsumer, additionalTask);
            } else {
                Manager.addUnversionedFilesToVcs(project, targetChangeList, files2, (Consumer<? super List<? extends Change>>)changesConsumer, additionalTask);
            }
        }

        @NotNull
        public final JBIterable<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            return this.getUnversionedFiles(dataContext, project);
        }

        @NotNull
        public final JBIterable<VirtualFile> getUnversionedFiles(@NotNull DataContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            JBIterable jBIterable = JBIterable.from((Iterable)((Iterable)context.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable filePaths = jBIterable;
            if (filePaths.isNotEmpty()) {
                JBIterable jBIterable2 = filePaths.map(arg_0 -> Manager.getUnversionedFiles$lambda$1(getUnversionedFiles.1.INSTANCE, arg_0)).filterNotNull();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filterNotNull(...)");
                return jBIterable2;
            }
            if (!ArrayUtil.isEmpty((Object[])((Object[])context.getData(VcsDataKeys.CHANGES)))) {
                JBIterable jBIterable3 = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
                return jBIterable3;
            }
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            JBIterable jBIterable4 = JBIterable.from((Iterable)((Iterable)context.getData(VcsDataKeys.VIRTUAL_FILES))).filter(arg_0 -> Manager.getUnversionedFiles$lambda$2((Function1)new Function1<VirtualFile, Boolean>(vcsManager2, changeListManager2){
                final /* synthetic */ ProjectLevelVcsManager $vcsManager;
                final /* synthetic */ ChangeListManager $changeListManager;
                {
                    this.$vcsManager = $vcsManager;
                    this.$changeListManager = $changeListManager;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    ProjectLevelVcsManager projectLevelVcsManager = this.$vcsManager;
                    Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"$vcsManager");
                    return Manager.access$isFileUnversioned(Manager.INSTANCE, file, projectLevelVcsManager, this.$changeListManager);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
            return jBIterable4;
        }

        private final boolean isFileUnversioned(VirtualFile file, ProjectLevelVcsManager vcsManager2, ChangeListManager changeListManager) {
            AbstractVcs vcs = vcsManager2.getVcsFor(file);
            FileStatus fileStatus = changeListManager.getStatus(file);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus fileStatus2 = fileStatus;
            return fileStatus2 == FileStatus.UNKNOWN || fileStatus2 != FileStatus.IGNORED && vcs != null && !vcs.areDirectoriesVersionedItems() && file.isDirectory();
        }

        @JvmStatic
        public static final boolean addUnversionedFilesToVcs(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull List<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            return Manager.addUnversionedFilesToVcs(project, targetChangeList, files2, null, null);
        }

        @JvmStatic
        public static final void addUnversionedFilesToVcsInBackground(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull List<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Manager.addUnversionedFilesToVcsInBackground(project, targetChangeList, files2, null, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public static final void addUnversionedFilesToVcsInBackground(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull List<? extends VirtualFile> files2, @Nullable Consumer<? super List<? extends Change>> changesConsumer, @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
            void title$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            String string = VcsBundle.message((String)"progress.title.adding.files.to.vcs", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, (String)title$iv, cancellable$iv, project, files2, additionalTask, targetChangeList, changesConsumer){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ List $files$inlined;
                final /* synthetic */ PairConsumer $additionalTask$inlined;
                final /* synthetic */ LocalChangeList $targetChangeList$inlined;
                final /* synthetic */ Consumer $changesConsumer$inlined;
                {
                    this.$project$inlined = project;
                    this.$files$inlined = list;
                    this.$additionalTask$inlined = pairConsumer;
                    this.$targetChangeList$inlined = localChangeList;
                    this.$changesConsumer$inlined = consumer;
                    super($project, $title, $cancellable);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator indicator2 = indicator;
                    boolean bl2 = false;
                    List exceptions = new ArrayList<E>();
                    try {
                        Set allProcessedFiles = Manager.access$performUnversionedFilesAddition(Manager.INSTANCE, this.$project$inlined, this.$files$inlined, exceptions);
                        if (this.$additionalTask$inlined != null) {
                            this.$additionalTask$inlined.consume((Object)indicator2, (Object)exceptions);
                        }
                        Manager.access$moveAddedChangesTo(Manager.INSTANCE, this.$project$inlined, this.$targetChangeList$inlined, allProcessedFiles, this.$changesConsumer$inlined);
                        if (((Collection)exceptions).isEmpty()) return;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        if (!(!((Collection)exceptions).isEmpty())) throw throwable;
                        VcsNotifier.getInstance(this.$project$inlined).notifyError("vcs.add.unversioned.error", VcsBundle.message((String)"error.adding.files.notification.title", (Object[])new Object[0]), Manager.access$createErrorMessage(Manager.INSTANCE, exceptions));
                        throw throwable;
                    }
                    if (!bl) return;
                    VcsNotifier.getInstance(this.$project$inlined).notifyError("vcs.add.unversioned.error", VcsBundle.message((String)"error.adding.files.notification.title", (Object[])new Object[0]), Manager.access$createErrorMessage(Manager.INSTANCE, exceptions));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @RequiresBackgroundThread
        public static final boolean addUnversionedFilesToVcsInSync(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull List<? extends VirtualFile> files2, @Nullable Consumer<? super List<? extends Change>> changesConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            List exceptions = new ArrayList();
            try {
                Set<VirtualFile> allProcessedFiles = INSTANCE.performUnversionedFilesAddition(project, files2, exceptions);
                INSTANCE.moveAddedChangesTo(project, targetChangeList, allProcessedFiles, changesConsumer);
                if (!(!((Collection)exceptions).isEmpty())) return exceptions.isEmpty();
            }
            catch (Throwable throwable) {
                if (!(!((Collection)exceptions).isEmpty())) throw throwable;
                VcsNotifier.getInstance(project).notifyError("vcs.add.unversioned.error", VcsBundle.message((String)"error.adding.files.notification.title", (Object[])new Object[0]), INSTANCE.createErrorMessage(exceptions));
                throw throwable;
            }
            VcsNotifier.getInstance(project).notifyError("vcs.add.unversioned.error", VcsBundle.message((String)"error.adding.files.notification.title", (Object[])new Object[0]), INSTANCE.createErrorMessage(exceptions));
            return exceptions.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public static final boolean addUnversionedFilesToVcs(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull List<? extends VirtualFile> files2, @Nullable Consumer<? super List<? extends Change>> changesConsumer, @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
            void title$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            List exceptions = new ArrayList();
            String string = VcsBundle.message((String)"progress.title.adding.files.to.vcs", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            boolean cancellable$iv = true;
            boolean $i$f$runModalTask = false;
            ProgressManager.getInstance().run((Task)new Task.Modal(project, (String)title$iv, cancellable$iv, project, files2, exceptions, additionalTask, targetChangeList, changesConsumer){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ List $files$inlined;
                final /* synthetic */ List $exceptions$inlined;
                final /* synthetic */ PairConsumer $additionalTask$inlined;
                final /* synthetic */ LocalChangeList $targetChangeList$inlined;
                final /* synthetic */ Consumer $changesConsumer$inlined;
                {
                    this.$project$inlined = project;
                    this.$files$inlined = list;
                    this.$exceptions$inlined = list2;
                    this.$additionalTask$inlined = pairConsumer;
                    this.$targetChangeList$inlined = localChangeList;
                    this.$changesConsumer$inlined = consumer;
                    super($project, $title, $cancellable);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator indicator2 = indicator;
                    boolean bl = false;
                    Set allProcessedFiles = Manager.access$performUnversionedFilesAddition(Manager.INSTANCE, this.$project$inlined, this.$files$inlined, this.$exceptions$inlined);
                    if (this.$additionalTask$inlined != null) {
                        this.$additionalTask$inlined.consume((Object)indicator2, (Object)this.$exceptions$inlined);
                    }
                    Manager.access$moveAddedChangesTo(Manager.INSTANCE, this.$project$inlined, this.$targetChangeList$inlined, allProcessedFiles, this.$changesConsumer$inlined);
                }
            });
            if (!((Collection)exceptions).isEmpty()) {
                Messages.showErrorDialog((Project)project, (String)INSTANCE.createErrorMessage(exceptions), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
            }
            return exceptions.isEmpty();
        }

        private final Set<VirtualFile> performUnversionedFilesAddition(Project project, List<? extends VirtualFile> files2, List<VcsException> exceptions) {
            Set allProcessedFiles = new LinkedHashSet();
            ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)files2, (arg_0, arg_1) -> Manager.performUnversionedFilesAddition$lambda$5(project, allProcessedFiles, exceptions, arg_0, arg_1));
            VcsFileUtil.markFilesDirty(project, allProcessedFiles);
            return allProcessedFiles;
        }

        /*
         * WARNING - void declaration
         */
        private final void moveAddedChangesTo(Project project, LocalChangeList targetList, Set<? extends VirtualFile> allProcessedFiles, Consumer<? super List<? extends Change>> changesConsumer) {
            boolean changesMoved;
            void $this$filterTo$iv$iv;
            boolean syncUpdateRequired;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            boolean moveRequired = targetList != null && !targetList.isDefault() && !((Collection)allProcessedFiles).isEmpty() && changeListManager2.areChangeListsEnabled();
            boolean bl = syncUpdateRequired = changesConsumer != null;
            if (!moveRequired && !syncUpdateRequired) {
                return;
            }
            ChangeListManagerEx.getInstanceEx(project).waitForUpdate();
            Collection collection = changeListManager2.getDefaultChangeList().getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Change change = (Change)element$iv$iv;
                boolean bl2 = false;
                FilePath filePath = ChangesUtil.getAfterPath((Change)change);
                Object file = filePath != null ? filePath.getVirtualFile() : null;
                if (!(file != null && allProcessedFiles.contains(file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newChanges = (List)destination$iv$iv;
            boolean bl3 = moveRequired && !((Collection)newChanges).isEmpty() ? true : (changesMoved = false);
            if (changesMoved) {
                LocalChangeList localChangeList = targetList;
                Intrinsics.checkNotNull((Object)localChangeList);
                changeListManager2.moveChangesTo(localChangeList, newChanges);
            }
            if (changesConsumer != null) {
                ApplicationManager.getApplication().invokeAndWait(() -> Manager.moveAddedChangesTo$lambda$7(project, changesConsumer, targetList, newChanges, changesMoved));
            }
        }

        private final void notifyChangesConsumer(Project project, Consumer<? super List<? extends Change>> changesConsumer, LocalChangeList targetList, List<? extends Change> newChanges, boolean rereadChanges) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            List changes = null;
            if (rereadChanges) {
                LocalChangeList localChangeList = targetList;
                Intrinsics.checkNotNull((Object)localChangeList);
                LocalChangeList newList = changeListManager2.getChangeList(localChangeList.getId());
                if (newList != null) {
                    Collection collection = newList.getChanges();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                    changes = CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)collection, (Iterable)CollectionsKt.toSet((Iterable)newChanges)));
                } else {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ScheduleForAdditionAction.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Changelist not found after moving new changes: " + targetList);
                    changes = newChanges;
                }
            } else {
                changes = newChanges;
            }
            changesConsumer.consume(changes);
        }

        private final void performUnversionedFilesAdditionForVcs(Project project, AbstractVcs vcs, List<? extends VirtualFile> items, Set<? super VirtualFile> allProcessedFiles, List<? super VcsException> exceptions) {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null) {
                return;
            }
            CheckinEnvironment environment = checkinEnvironment;
            Set<VirtualFile> descendants = this.getUnversionedDescendantsRecursively(project, vcs, items);
            Set<VirtualFile> parents = this.getUnversionedParents(project, vcs, (Collection<? extends VirtualFile>)items);
            List exs = environment.scheduleUnversionedFilesForAddition(CollectionsKt.toList((Iterable)descendants));
            if (exs != null) {
                exceptions.addAll(exs);
            }
            allProcessedFiles.addAll((Collection<? super VirtualFile>)descendants);
            allProcessedFiles.addAll((Collection<? super VirtualFile>)parents);
        }

        private final Set<VirtualFile> getUnversionedDescendantsRecursively(Project project, AbstractVcs vcs, List<? extends VirtualFile> items) {
            Set roots = CollectionsKt.toSet((Iterable)items);
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
            List<FilePath> list = ChangeListManagerImpl.getInstanceImpl(project).getUnversionedFilesPaths();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFilesPaths(...)");
            List<FilePath> unversionedPaths = list;
            Set result2 = new LinkedHashSet();
            for (FilePath path2 : unversionedPaths) {
                VirtualFile file;
                if (!Intrinsics.areEqual((Object)vcsManager2.getVcsFor(path2), (Object)vcs) || path2.getVirtualFile() == null || !this.hasAncestorIn(file, roots)) continue;
                ((Collection)result2).add(file);
            }
            return result2;
        }

        private final boolean hasAncestorIn(VirtualFile file, Set<? extends VirtualFile> roots) {
            boolean bl;
            block1: {
                Sequence $this$any$iv = SequencesKt.generateSequence((Object)file, (Function1)hasAncestorIn.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!roots.contains(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final Set<VirtualFile> getUnversionedParents(Project project, AbstractVcs vcs, Collection<? extends VirtualFile> items) {
            if (!vcs.areDirectoriesVersionedItems()) {
                return SetsKt.emptySet();
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Set result2 = new LinkedHashSet();
            for (VirtualFile virtualFile : items) {
                for (VirtualFile parent = virtualFile.getParent(); parent != null && changeListManager2.getStatus(parent) == FileStatus.UNKNOWN; parent = parent.getParent()) {
                    result2.add(parent);
                }
            }
            return result2;
        }

        private final String createErrorMessage(List<? extends VcsException> exceptions) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException vcsException : exceptions) {
                message.append("\n").append(vcsException.getMessage());
            }
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final void performUnversionedFilesAddition$lambda$0(ChangesBrowserBase $browser, List changes) {
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            ((CommitDialogChangesBrowser)$browser).getViewer().includeChanges(changes);
        }

        private static final VirtualFile getUnversionedFiles$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (VirtualFile)$tmp0.invoke(p0);
        }

        private static final boolean getUnversionedFiles$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void performUnversionedFilesAddition$lambda$5(Project $project, Set $allProcessedFiles, List $exceptions, AbstractVcs vcs, List vcsFiles) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$allProcessedFiles, (String)"$allProcessedFiles");
            Intrinsics.checkNotNullParameter((Object)$exceptions, (String)"$exceptions");
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            Intrinsics.checkNotNullParameter((Object)vcsFiles, (String)"vcsFiles");
            INSTANCE.performUnversionedFilesAdditionForVcs($project, vcs, vcsFiles, $allProcessedFiles, $exceptions);
        }

        private static final void moveAddedChangesTo$lambda$7(Project $project, Consumer $changesConsumer, LocalChangeList $targetList, List $newChanges, boolean $changesMoved) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$newChanges, (String)"$newChanges");
            INSTANCE.notifyChangesConsumer($project, (Consumer<? super List<? extends Change>>)$changesConsumer, $targetList, $newChanges, $changesMoved);
        }

        public static final /* synthetic */ boolean access$isFileUnversioned(Manager $this, VirtualFile file, ProjectLevelVcsManager vcsManager2, ChangeListManager changeListManager) {
            return $this.isFileUnversioned(file, vcsManager2, changeListManager);
        }

        public static final /* synthetic */ Set access$performUnversionedFilesAddition(Manager $this, Project project, List files2, List exceptions) {
            return $this.performUnversionedFilesAddition(project, files2, exceptions);
        }

        public static final /* synthetic */ void access$moveAddedChangesTo(Manager $this, Project project, LocalChangeList targetList, Set allProcessedFiles, Consumer changesConsumer) {
            $this.moveAddedChangesTo(project, targetList, allProcessedFiles, (Consumer<? super List<? extends Change>>)changesConsumer);
        }

        public static final /* synthetic */ String access$createErrorMessage(Manager $this, List exceptions) {
            return $this.createErrorMessage(exceptions);
        }
    }
}

