/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListDetailsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists == null || changeLists.length == 0) {
            return;
        }
        ChangeListDetailsAction.showDetailsPopup(project, (CommittedChangeList)changeLists[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(1);
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabled(e.getProject() != null && changeLists != null && changeLists.length == 1 && changeLists[0] instanceof CommittedChangeList);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public static void showDetailsPopup(@NotNull Project project, @NotNull CommittedChangeList changeList) {
        if (project == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(3);
        }
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(4);
        }
        String htmlFormat = "<html><head>%s</head><body>%s</body></html>";
        String details = String.format(htmlFormat, UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont()), ChangeListDetailsAction.getDetails(project, changeList));
        JEditorPane editorPane = new JEditorPane("text/html", details);
        editorPane.setEditable(false);
        editorPane.setBackground(HintUtil.getInformationColor());
        editorPane.select(0, 0);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)editorPane), (JComponent)editorPane).setDimensionServiceKey(project, "changelist.details.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(VcsBundle.message((String)"changelist.details.title", (Object[])new Object[0])).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
    }

    @Nls
    @NotNull
    private static String getDetails(@NotNull Project project, @NotNull CommittedChangeList changeList) {
        if (project == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(5);
        }
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{ChangeListDetailsAction.getNumber(changeList), ChangeListDetailsAction.getCommitterAndDate(changeList), ChangeListDetailsAction.getCustomDetails(changeList), IssueLinkHtmlRenderer.formatTextWithLinks(project, changeList.getComment())}), (String)"<br/>");
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @Nullable
    private static String getNumber(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(8);
        }
        return Optional.ofNullable(changeList.getVcs()).map(AbstractVcs::getCachingCommittedChangesProvider).map(CachingCommittedChangesProvider::getChangelistTitle).map(changeListTitle -> changeListTitle + " #" + changeList.getNumber()).orElse(null);
    }

    @Nls
    @NotNull
    private static String getCommitterAndDate(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(9);
        }
        @NonNls String committer = "<b>" + changeList.getCommitterName() + "</b>";
        String string = VcsBundle.message((String)"changelist.details.committed.format", (Object[])new Object[]{committer, DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate())});
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nls
    @Nullable
    private static String getCustomDetails(@NotNull CommittedChangeList changeList) {
        AbstractVcs vcs;
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(11);
        }
        if ((vcs = changeList.getVcs()) != null && vcs.getCachingCommittedChangesProvider() != null) {
            CommittedChangeList originalChangeList = ReceivedChangeList.unwrap(changeList);
            List customColumns = ContainerUtil.filter((Object[])vcs.getCachingCommittedChangesProvider().getColumns(), ChangeListColumn::isCustom);
            if (customColumns.isEmpty()) {
                return null;
            }
            return new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map((Collection)customColumns, column -> HtmlChunk.text((String)(column.getTitle() + ": " + ChangeListDetailsAction.toString(column.getValue((ChangeList)originalChangeList)))))).toString();
        }
        return null;
    }

    @Nls
    @NotNull
    private static String toString(@Nullable Object value) {
        String result2 = value != null ? value.toString() : "";
        String string = result2.isEmpty() ? VcsBundle.message((String)"changes.none", (Object[])new Object[0]) : result2;
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/ChangeListDetailsAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/ChangeListDetailsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterAndDate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showDetailsPopup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitterAndDate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 10, 12 -> new IllegalStateException(string);
        };
    }
}

