/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CodeProcessorCheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CodeProcessorCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createCodeProcessor", "Lcom/intellij/codeInsight/actions/AbstractLayoutCodeProcessor;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "getProgressMessage", "", "isEnabled", "", "Companion", "intellij.platform.vcs.impl"})
public final class RearrangeBeforeCheckinHandler
extends CodeProcessorCheckinHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NlsSafe
    @NotNull
    public static final String COMMAND_NAME;

    public RearrangeBeforeCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        Project project = this.getProject();
        CheckinHandler checkinHandler = this;
        String string = VcsBundle.message((String)"checkbox.checkin.options.rearrange.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return BooleanCommitOption.Companion.create(project, checkinHandler, true, string, (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this.getSettings()){

            @Nullable
            public Object get() {
                return ((VcsConfiguration)this.receiver).REARRANGE_BEFORE_PROJECT_COMMIT;
            }

            public void set(@Nullable Object value) {
                ((VcsConfiguration)this.receiver).REARRANGE_BEFORE_PROJECT_COMMIT = (Boolean)value;
            }
        }));
    }

    public boolean isEnabled() {
        return this.getSettings().REARRANGE_BEFORE_PROJECT_COMMIT;
    }

    @Override
    @NotNull
    protected String getProgressMessage() {
        String string = VcsBundle.message((String)"progress.text.rearranging.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected AbstractLayoutCodeProcessor createCodeProcessor(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return (AbstractLayoutCodeProcessor)new RearrangeCodeProcessor(this.getProject(), CheckinHandlerUtil.getPsiFiles(this.getProject(), (Collection<? extends VirtualFile>)files2), COMMAND_NAME, null, true);
    }

    static {
        String string = CodeInsightBundle.message((String)"process.rearrange.code.before.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        COMMAND_NAME = string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler$Companion;", "", "()V", "COMMAND_NAME", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

