/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl;", "Lcom/intellij/openapi/vcs/impl/ActiveChangeListTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "forcedChangeListId", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "doRunUnderChangeList", "", "changelistId", "task", "Ljava/lang/Runnable;", "getActiveChangeListId", "isActiveChangeList", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "runUnderChangeList", "", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nActiveChangeListTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActiveChangeListTracker.kt\ncom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n13#2:81\n*S KotlinDebug\n*F\n+ 1 ActiveChangeListTracker.kt\ncom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl\n*L\n29#1:81\n*E\n"})
public class ActiveChangeListTrackerImpl
implements ActiveChangeListTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private String forcedChangeListId;
    @NotNull
    private static final Logger LOG;

    public ActiveChangeListTrackerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String getActiveChangeListId() {
        return this.forcedChangeListId;
    }

    @Override
    public boolean isActiveChangeList(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        String activeListId = this.getActiveChangeListId();
        if (activeListId != null) {
            return Intrinsics.areEqual((Object)changeList.getId(), (Object)activeListId);
        }
        return changeList.isDefault();
    }

    @Override
    public void runUnderChangeList(@NotNull String changelistId, @NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (!this.doRunUnderChangeList(changelistId, task2)) {
            task2.run();
        }
    }

    private final boolean doRunUnderChangeList(String changelistId, Runnable task2) {
        LineStatusTrackerManager lstManager = LineStatusTrackerManager.Companion.getInstanceImpl(this.project);
        if (!lstManager.arePartialChangelistsEnabled()) {
            return false;
        }
        if (this.forcedChangeListId != null) {
            LOG.warn("Conflicting forced changelist request", new Throwable());
            return false;
        }
        Ref.BooleanRef success2 = new Ref.BooleanRef();
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.project);
        changeListManager.executeUnderDataLock(() -> ActiveChangeListTrackerImpl.doRunUnderChangeList$lambda$0(changeListManager, changelistId, this, success2, task2));
        return success2.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doRunUnderChangeList$lambda$0(ChangeListManagerImpl $changeListManager, String $changelistId, ActiveChangeListTrackerImpl this$0, Ref.BooleanRef $success, Runnable $task) {
        Intrinsics.checkNotNullParameter((Object)$changelistId, (String)"$changelistId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$success, (String)"$success");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        if ($changeListManager.getChangeList($changelistId) != null) {
            this$0.forcedChangeListId = $changelistId;
            try {
                LOG.debug("running operation under changelist: " + $changelistId);
                $success.element = true;
                $task.run();
            }
            finally {
                this$0.forcedChangeListId = null;
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ActiveChangeListTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

