/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CommitOptions;
import com.intellij.vcs.commit.CommitOptionsKt;
import com.intellij.vcs.commit.CommitOptionsPanel;
import com.intellij.vcs.commit.CommitOptionsUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010!H\u0016J\u0014\u0010\"\u001a\u00020\u001c*\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel;", "Lcom/intellij/vcs/commit/CommitOptionsUi;", "project", "Lcom/intellij/openapi/project/Project;", "actionNameSupplier", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "nonFocusable", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Z)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "<set-?>", "isEmpty", "()Z", "placeholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "visibleVcsListeners", "", "Ljava/lang/Runnable;", "visibleVcses", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "extractMeaningfulComponent", "setOptions", "", "options", "Lcom/intellij/vcs/commit/CommitOptions;", "setVisible", "vcses", "", "appendOptionRow", "Lcom/intellij/ui/dsl/builder/Panel;", "option", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "Companion", "VcsVisiblePredicate", "intellij.platform.vcs.impl"})
public final class CommitOptionsPanel
implements CommitOptionsUi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<String> actionNameSupplier;
    private final boolean nonFocusable;
    @NotNull
    private final JComponent component;
    private Placeholder placeholder;
    private boolean isEmpty;
    @Nullable
    private Set<? extends AbstractVcs> visibleVcses;
    @NotNull
    private final List<Runnable> visibleVcsListeners;

    public CommitOptionsPanel(@NotNull Project project, @NotNull Function0<String> actionNameSupplier, boolean nonFocusable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(actionNameSupplier, (String)"actionNameSupplier");
        this.project = project;
        this.actionNameSupplier = actionNameSupplier;
        this.nonFocusable = nonFocusable;
        this.isEmpty = true;
        this.visibleVcsListeners = new ArrayList();
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ CommitOptionsPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ CommitOptionsPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        CommitOptionsPanel.access$setPlaceholder$p(this.this$0, $this$row.placeholder().align(Align.FILL));
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)panel2), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.component = jScrollPane;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void setOptions(@NotNull CommitOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = UIUtil.removeMnemonic((String)((String)this.actionNameSupplier.invoke()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeMnemonic(...)");
        String actionName = string;
        this.visibleVcsListeners.clear();
        this.isEmpty = CommitOptionsKt.isEmpty(options);
        Placeholder placeholder = this.placeholder;
        if (placeholder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"placeholder");
            placeholder = null;
        }
        placeholder.setComponent((JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(options, this, actionName){
            final /* synthetic */ CommitOptions $options;
            final /* synthetic */ CommitOptionsPanel this$0;
            final /* synthetic */ String $actionName;
            {
                this.$options = $options;
                this.this$0 = $receiver;
                this.$actionName = $actionName;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                List<RefreshableOnComponent> extensionOptions;
                List<RefreshableOnComponent> afterOptions;
                Object[] vcs;
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                for (Map.Entry<AbstractVcs, RefreshableOnComponent> entry : this.$options.getVcsOptions().entrySet()) {
                    vcs = entry.getKey();
                    RefreshableOnComponent option = entry.getValue();
                    Panel.group$default((Panel)$this$panel, (String)vcs.getDisplayName(), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0, option){
                        final /* synthetic */ CommitOptionsPanel this$0;
                        final /* synthetic */ RefreshableOnComponent $option;
                        {
                            this.this$0 = $receiver;
                            this.$option = $option;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$group) {
                            Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                            CommitOptionsPanel.access$appendOptionRow(this.this$0, $this$group, this.$option);
                        }
                    }), (int)2, null).visibleIf((ComponentPredicate)this.this$0.new VcsVisiblePredicate((AbstractVcs)vcs));
                }
                List<RefreshableOnComponent> beforeOptions = this.$options.getBeforeOptions();
                if (!((Collection)beforeOptions).isEmpty()) {
                    Panel.group$default((Panel)$this$panel, (String)CommitOptionsPanel.Companion.commitChecksGroupTitle(CommitOptionsPanel.access$getProject$p(this.this$0), this.$actionName), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(beforeOptions, this.this$0){
                        final /* synthetic */ List<RefreshableOnComponent> $beforeOptions;
                        final /* synthetic */ CommitOptionsPanel this$0;
                        {
                            this.$beforeOptions = $beforeOptions;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$group) {
                            Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                            for (RefreshableOnComponent option : this.$beforeOptions) {
                                CommitOptionsPanel.access$appendOptionRow(this.this$0, $this$group, option);
                            }
                        }
                    }), (int)2, null);
                }
                if (!((Collection)(afterOptions = this.$options.getAfterOptions())).isEmpty()) {
                    vcs = new Object[]{this.$actionName};
                    Panel.group$default((Panel)$this$panel, (String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])vcs), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(afterOptions, this.this$0){
                        final /* synthetic */ List<RefreshableOnComponent> $afterOptions;
                        final /* synthetic */ CommitOptionsPanel this$0;
                        {
                            this.$afterOptions = $afterOptions;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$group) {
                            Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                            for (RefreshableOnComponent option : this.$afterOptions) {
                                CommitOptionsPanel.access$appendOptionRow(this.this$0, $this$group, option);
                            }
                        }
                    }), (int)2, null);
                }
                if (!((Collection)(extensionOptions = this.$options.getExtensionOptions())).isEmpty()) {
                    for (RefreshableOnComponent option : extensionOptions) {
                        CommitOptionsPanel.access$appendOptionRow(this.this$0, $this$panel, option);
                    }
                }
            }
        })));
        if (this.nonFocusable) {
            UIUtil.forEachComponentInHierarchy((Component)this.component, arg_0 -> CommitOptionsPanel.setOptions$lambda$0(setOptions.2.INSTANCE, arg_0));
        }
    }

    private final void appendOptionRow(Panel $this$appendOptionRow, RefreshableOnComponent option) {
        JComponent jComponent = option.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = this.extractMeaningfulComponent(jComponent);
        Panel.row$default((Panel)$this$appendOptionRow, null, (Function1)((Function1)new Function1<Row, Unit>(component, option){
            final /* synthetic */ JComponent $component;
            final /* synthetic */ RefreshableOnComponent $option;
            {
                this.$component = $component;
                this.$option = $option;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                JComponent jComponent = this.$component;
                if (jComponent == null) {
                    jComponent = this.$option.getComponent();
                }
                $this$row.cell(jComponent).align(Align.FILL);
            }
        }), (int)1, null);
    }

    private final JComponent extractMeaningfulComponent(JComponent component) {
        if (component instanceof DialogPanel) {
            return null;
        }
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (((JPanel)component).getLayout() instanceof BorderLayout && ((JPanel)component).getComponents().length == 1 && (border == null || border instanceof EmptyBorder)) {
                Component component2 = ((JPanel)component).getComponents()[0];
                return component2 instanceof JComponent ? (JComponent)component2 : null;
            }
        }
        return null;
    }

    @Override
    public void setVisible(@Nullable Collection<? extends AbstractVcs> vcses) {
        Collection<? extends AbstractVcs> collection = vcses;
        this.visibleVcses = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
        for (Runnable listener2 : this.visibleVcsListeners) {
            listener2.run();
        }
    }

    private static final void setOptions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$appendOptionRow(CommitOptionsPanel $this, Panel $receiver, RefreshableOnComponent option) {
        $this.appendOptionRow($receiver, option);
    }

    public static final /* synthetic */ Project access$getProject$p(CommitOptionsPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setPlaceholder$p(CommitOptionsPanel $this, Placeholder placeholder) {
        $this.placeholder = placeholder;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel$Companion;", "", "()V", "commitChecksGroupTitle", "", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "actionName", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitOptionsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitOptionsPanel.kt\ncom/intellij/vcs/commit/CommitOptionsPanel$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,145:1\n12474#2,2:146\n*S KotlinDebug\n*F\n+ 1 CommitOptionsPanel.kt\ncom/intellij/vcs/commit/CommitOptionsPanel$Companion\n*L\n136#1:146,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String commitChecksGroupTitle(@NotNull Project project, @NotNull String actionName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            if (Registry.is((String)"vcs.non.modal.post.commit.checks")) {
                boolean bl;
                block3: {
                    AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
                    Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
                    Object[] $this$any$iv = abstractVcsArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        AbstractVcs vcs = (AbstractVcs)element$iv;
                        boolean bl2 = false;
                        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
                        if (!((checkinEnvironment != null ? checkinEnvironment.getPostCommitChangeConverter() : null) != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) {
                    Object[] objectArray = new Object[]{actionName};
                    String string = VcsBundle.message((String)"border.standard.checkin.options.group.with.post.commit", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }
            }
            Object[] objectArray = new Object[]{actionName};
            String string = VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u000e\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel$VcsVisiblePredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "(Lcom/intellij/vcs/commit/CommitOptionsPanel;Lcom/intellij/openapi/vcs/AbstractVcs;)V", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.platform.vcs.impl"})
    private final class VcsVisiblePredicate
    extends ComponentPredicate {
        @NotNull
        private final AbstractVcs vcs;

        public VcsVisiblePredicate(AbstractVcs vcs) {
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            this.vcs = vcs;
        }

        @NotNull
        public final AbstractVcs getVcs() {
            return this.vcs;
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            CommitOptionsPanel.this.visibleVcsListeners.add(() -> VcsVisiblePredicate.addListener$lambda$0(listener2, this));
        }

        @NotNull
        public Boolean invoke() {
            Set set = CommitOptionsPanel.this.visibleVcses;
            return set != null ? set.contains(this.vcs) : true;
        }

        private static final void addListener$lambda$0(Function1 $listener, VcsVisiblePredicate this$0) {
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            $listener.invoke((Object)this$0.invoke());
        }
    }
}

