/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.protobuf.arrays;

import io.kinference.protobuf.arrays.PrimitiveArrayBuilder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0094\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/kinference/protobuf/arrays/DoubleArrayBuilder;", "Lio/kinference/protobuf/arrays/PrimitiveArrayBuilder;", "", "data", "([D)V", "<set-?>", "", "position", "getPosition", "()I", "append", "", "element", "", "build", "checkCapacity", "requiredCapacity", "checkCapacity$serializer_protobuf", "serializer-protobuf"})
public final class DoubleArrayBuilder
extends PrimitiveArrayBuilder<double[]> {
    @NotNull
    private double[] data;
    private int position;

    public DoubleArrayBuilder(@NotNull double[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.data = data2;
        this.position = this.data.length;
        this.checkCapacity$serializer_protobuf(50);
    }

    @Override
    protected int getPosition() {
        return this.position;
    }

    @Override
    public void checkCapacity$serializer_protobuf(int requiredCapacity) {
        if (this.data.length < requiredCapacity) {
            double[] dArray = Arrays.copyOf(this.data, RangesKt.coerceAtLeast((int)requiredCapacity, (int)(this.data.length * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(this, newSize)");
            this.data = dArray;
        }
    }

    public final void append(double element) {
        PrimitiveArrayBuilder.checkCapacity$serializer_protobuf$default(this, 0, 1, null);
        int n = this.getPosition();
        this.position = n + 1;
        this.data[n] = element;
    }

    @Override
    @NotNull
    public double[] build() {
        double[] dArray = Arrays.copyOf(this.data, this.getPosition());
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(this, newSize)");
        return dArray;
    }
}

