/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.core.jdkmath;

import java.io.PrintStream;

final class AccurateMathCalc {
    private static final long HEX_40000000 = 0x40000000L;
    private static final double[] FACT = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17};
    private static final double[][] LN_SPLIT_COEF = new double[][]{{2.0, 0.0}, {0.6666666269302368, 3.9736429850260626E-8}, {0.3999999761581421, 2.3841857910019882E-8}, {0.2857142686843872, 1.7029898543501842E-8}, {0.2222222089767456, 1.3245471311735498E-8}, {0.1818181574344635, 2.4384203044354907E-8}, {0.1538461446762085, 9.140260083262505E-9}, {0.13333332538604736, 9.220590270857665E-9}, {0.11764700710773468, 1.2393345855018391E-8}, {0.10526403784751892, 8.251545029714408E-9}, {0.0952233225107193, 1.2675934823758863E-8}, {0.08713622391223907, 1.1430250008909141E-8}, {0.07842259109020233, 2.404307984052299E-9}, {0.08371849358081818, 1.176342548272881E-8}, {0.03058958f, 1.2958646899018938E-9}, {0.14982303977012634, 1.225743062930824E-8}};
    private static final String TABLE_START_DECL = "    {";
    private static final String TABLE_END_DECL = "    };";

    private AccurateMathCalc() {
    }

    private static void buildSinCosTables(double[] SINE_TABLE_A, double[] SINE_TABLE_B, double[] COSINE_TABLE_A, double[] COSINE_TABLE_B, int SINE_TABLE_LEN, double[] TANGENT_TABLE_A, double[] TANGENT_TABLE_B) {
        double[] as;
        double[] ys;
        int i;
        double[] result2 = new double[2];
        for (i = 0; i < 7; ++i) {
            double x = (double)i / 8.0;
            AccurateMathCalc.slowSin(x, result2);
            SINE_TABLE_A[i] = result2[0];
            SINE_TABLE_B[i] = result2[1];
            AccurateMathCalc.slowCos(x, result2);
            COSINE_TABLE_A[i] = result2[0];
            COSINE_TABLE_B[i] = result2[1];
        }
        for (i = 7; i < SINE_TABLE_LEN; ++i) {
            double[] xs = new double[2];
            ys = new double[2];
            as = new double[2];
            double[] bs = new double[2];
            double[] temps = new double[2];
            if ((i & 1) == 0) {
                xs[0] = SINE_TABLE_A[i / 2];
                xs[1] = SINE_TABLE_B[i / 2];
                ys[0] = COSINE_TABLE_A[i / 2];
                ys[1] = COSINE_TABLE_B[i / 2];
                AccurateMathCalc.splitMult(xs, ys, result2);
                SINE_TABLE_A[i] = result2[0] * 2.0;
                SINE_TABLE_B[i] = result2[1] * 2.0;
                AccurateMathCalc.splitMult(ys, ys, as);
                AccurateMathCalc.splitMult(xs, xs, temps);
                temps[0] = -temps[0];
                temps[1] = -temps[1];
                AccurateMathCalc.splitAdd(as, temps, result2);
                COSINE_TABLE_A[i] = result2[0];
                COSINE_TABLE_B[i] = result2[1];
                continue;
            }
            xs[0] = SINE_TABLE_A[i / 2];
            xs[1] = SINE_TABLE_B[i / 2];
            ys[0] = COSINE_TABLE_A[i / 2];
            ys[1] = COSINE_TABLE_B[i / 2];
            as[0] = SINE_TABLE_A[i / 2 + 1];
            as[1] = SINE_TABLE_B[i / 2 + 1];
            bs[0] = COSINE_TABLE_A[i / 2 + 1];
            bs[1] = COSINE_TABLE_B[i / 2 + 1];
            AccurateMathCalc.splitMult(xs, bs, temps);
            AccurateMathCalc.splitMult(ys, as, result2);
            AccurateMathCalc.splitAdd(result2, temps, result2);
            SINE_TABLE_A[i] = result2[0];
            SINE_TABLE_B[i] = result2[1];
            AccurateMathCalc.splitMult(ys, bs, result2);
            AccurateMathCalc.splitMult(xs, as, temps);
            temps[0] = -temps[0];
            temps[1] = -temps[1];
            AccurateMathCalc.splitAdd(result2, temps, result2);
            COSINE_TABLE_A[i] = result2[0];
            COSINE_TABLE_B[i] = result2[1];
        }
        for (i = 0; i < SINE_TABLE_LEN; ++i) {
            double[] xs = new double[2];
            ys = new double[2];
            as = new double[]{COSINE_TABLE_A[i], COSINE_TABLE_B[i]};
            AccurateMathCalc.splitReciprocal(as, ys);
            xs[0] = SINE_TABLE_A[i];
            xs[1] = SINE_TABLE_B[i];
            AccurateMathCalc.splitMult(xs, ys, as);
            TANGENT_TABLE_A[i] = as[0];
            TANGENT_TABLE_B[i] = as[1];
        }
    }

    static double slowCos(double x, double[] result2) {
        double[] xs = new double[2];
        double[] ys = new double[2];
        double[] facts = new double[2];
        double[] as = new double[2];
        AccurateMathCalc.split(x, xs);
        ys[1] = 0.0;
        ys[0] = 0.0;
        for (int i = FACT.length - 1; i >= 0; --i) {
            AccurateMathCalc.splitMult(xs, ys, as);
            ys[0] = as[0];
            ys[1] = as[1];
            if ((i & 1) != 0) continue;
            AccurateMathCalc.split(FACT[i], as);
            AccurateMathCalc.splitReciprocal(as, facts);
            if ((i & 2) != 0) {
                facts[0] = -facts[0];
                facts[1] = -facts[1];
            }
            AccurateMathCalc.splitAdd(ys, facts, as);
            ys[0] = as[0];
            ys[1] = as[1];
        }
        if (result2 != null) {
            result2[0] = ys[0];
            result2[1] = ys[1];
        }
        return ys[0] + ys[1];
    }

    static double slowSin(double x, double[] result2) {
        double[] xs = new double[2];
        double[] ys = new double[2];
        double[] facts = new double[2];
        double[] as = new double[2];
        AccurateMathCalc.split(x, xs);
        ys[1] = 0.0;
        ys[0] = 0.0;
        for (int i = FACT.length - 1; i >= 0; --i) {
            AccurateMathCalc.splitMult(xs, ys, as);
            ys[0] = as[0];
            ys[1] = as[1];
            if ((i & 1) == 0) continue;
            AccurateMathCalc.split(FACT[i], as);
            AccurateMathCalc.splitReciprocal(as, facts);
            if ((i & 2) != 0) {
                facts[0] = -facts[0];
                facts[1] = -facts[1];
            }
            AccurateMathCalc.splitAdd(ys, facts, as);
            ys[0] = as[0];
            ys[1] = as[1];
        }
        if (result2 != null) {
            result2[0] = ys[0];
            result2[1] = ys[1];
        }
        return ys[0] + ys[1];
    }

    static double slowexp(double x, double[] result2) {
        double[] xs = new double[2];
        double[] ys = new double[2];
        double[] facts = new double[2];
        double[] as = new double[2];
        AccurateMathCalc.split(x, xs);
        ys[1] = 0.0;
        ys[0] = 0.0;
        for (int i = FACT.length - 1; i >= 0; --i) {
            AccurateMathCalc.splitMult(xs, ys, as);
            ys[0] = as[0];
            ys[1] = as[1];
            AccurateMathCalc.split(FACT[i], as);
            AccurateMathCalc.splitReciprocal(as, facts);
            AccurateMathCalc.splitAdd(ys, facts, as);
            ys[0] = as[0];
            ys[1] = as[1];
        }
        if (result2 != null) {
            result2[0] = ys[0];
            result2[1] = ys[1];
        }
        return ys[0] + ys[1];
    }

    private static void split(double d, double[] split2) {
        if (d < 8.0E298 && d > -8.0E298) {
            double a = d * 1.073741824E9;
            split2[0] = d + a - a;
            split2[1] = d - split2[0];
        } else {
            double a = d * 9.313225746154785E-10;
            split2[0] = (d + a - d) * 1.073741824E9;
            split2[1] = d - split2[0];
        }
    }

    private static void resplit(double[] a) {
        double c = a[0] + a[1];
        double d = -(c - a[0] - a[1]);
        if (c < 8.0E298 && c > -8.0E298) {
            double z = c * 1.073741824E9;
            a[0] = c + z - z;
            a[1] = c - a[0] + d;
        } else {
            double z = c * 9.313225746154785E-10;
            a[0] = (c + z - c) * 1.073741824E9;
            a[1] = c - a[0] + d;
        }
    }

    private static void splitMult(double[] a, double[] b, double[] ans) {
        ans[0] = a[0] * b[0];
        ans[1] = a[0] * b[1] + a[1] * b[0] + a[1] * b[1];
        AccurateMathCalc.resplit(ans);
    }

    private static void splitAdd(double[] a, double[] b, double[] ans) {
        ans[0] = a[0] + b[0];
        ans[1] = a[1] + b[1];
        AccurateMathCalc.resplit(ans);
    }

    static void splitReciprocal(double[] in, double[] result2) {
        double b = 2.384185791015625E-7;
        double a = 0.9999997615814209;
        if (in[0] == 0.0) {
            in[0] = in[1];
            in[1] = 0.0;
        }
        result2[0] = 0.9999997615814209 / in[0];
        result2[1] = (2.384185791015625E-7 * in[0] - 0.9999997615814209 * in[1]) / (in[0] * in[0] + in[0] * in[1]);
        if (result2[1] != result2[1]) {
            result2[1] = 0.0;
        }
        AccurateMathCalc.resplit(result2);
        for (int i = 0; i < 2; ++i) {
            double err = 1.0 - result2[0] * in[0] - result2[0] * in[1] - result2[1] * in[0] - result2[1] * in[1];
            result2[1] = result2[1] + (err *= result2[0] + result2[1]);
        }
    }

    private static void quadMult(double[] a, double[] b, double[] result2) {
        double[] xs = new double[2];
        double[] ys = new double[2];
        double[] zs = new double[2];
        AccurateMathCalc.split(a[0], xs);
        AccurateMathCalc.split(b[0], ys);
        AccurateMathCalc.splitMult(xs, ys, zs);
        result2[0] = zs[0];
        result2[1] = zs[1];
        AccurateMathCalc.split(b[1], ys);
        AccurateMathCalc.splitMult(xs, ys, zs);
        double tmp = result2[0] + zs[0];
        result2[1] = result2[1] - (tmp - result2[0] - zs[0]);
        result2[0] = tmp;
        tmp = result2[0] + zs[1];
        result2[1] = result2[1] - (tmp - result2[0] - zs[1]);
        result2[0] = tmp;
        AccurateMathCalc.split(a[1], xs);
        AccurateMathCalc.split(b[0], ys);
        AccurateMathCalc.splitMult(xs, ys, zs);
        tmp = result2[0] + zs[0];
        result2[1] = result2[1] - (tmp - result2[0] - zs[0]);
        result2[0] = tmp;
        tmp = result2[0] + zs[1];
        result2[1] = result2[1] - (tmp - result2[0] - zs[1]);
        result2[0] = tmp;
        AccurateMathCalc.split(a[1], xs);
        AccurateMathCalc.split(b[1], ys);
        AccurateMathCalc.splitMult(xs, ys, zs);
        tmp = result2[0] + zs[0];
        result2[1] = result2[1] - (tmp - result2[0] - zs[0]);
        result2[0] = tmp;
        tmp = result2[0] + zs[1];
        result2[1] = result2[1] - (tmp - result2[0] - zs[1]);
        result2[0] = tmp;
    }

    static double expint(int p, double[] result2) {
        double[] xs = new double[2];
        double[] as = new double[2];
        double[] ys = new double[2];
        xs[0] = Math.E;
        xs[1] = 1.4456468917292502E-16;
        AccurateMathCalc.split(1.0, ys);
        while (p > 0) {
            if ((p & 1) != 0) {
                AccurateMathCalc.quadMult(ys, xs, as);
                ys[0] = as[0];
                ys[1] = as[1];
            }
            AccurateMathCalc.quadMult(xs, xs, as);
            xs[0] = as[0];
            xs[1] = as[1];
            p >>= 1;
        }
        if (result2 != null) {
            result2[0] = ys[0];
            result2[1] = ys[1];
            AccurateMathCalc.resplit(result2);
        }
        return ys[0] + ys[1];
    }

    static double[] slowLog(double xi) {
        double[] x = new double[2];
        double[] x2 = new double[2];
        double[] y = new double[2];
        double[] a = new double[2];
        AccurateMathCalc.split(xi, x);
        x[0] = x[0] + 1.0;
        AccurateMathCalc.resplit(x);
        AccurateMathCalc.splitReciprocal(x, a);
        x[0] = x[0] - 2.0;
        AccurateMathCalc.resplit(x);
        AccurateMathCalc.splitMult(x, a, y);
        x[0] = y[0];
        x[1] = y[1];
        AccurateMathCalc.splitMult(x, x, x2);
        y[0] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][0];
        y[1] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][1];
        for (int i = LN_SPLIT_COEF.length - 2; i >= 0; --i) {
            AccurateMathCalc.splitMult(y, x2, a);
            y[0] = a[0];
            y[1] = a[1];
            AccurateMathCalc.splitAdd(y, LN_SPLIT_COEF[i], a);
            y[0] = a[0];
            y[1] = a[1];
        }
        AccurateMathCalc.splitMult(y, x, a);
        y[0] = a[0];
        y[1] = a[1];
        return y;
    }

    static void printarray(PrintStream out, String name, int expectedLen, double[][] array2d) {
        out.println(name);
        AccurateMathCalc.checkLen(expectedLen, array2d.length);
        out.println("    { ");
        int i = 0;
        for (double[] array : array2d) {
            out.print("        {");
            for (double d : array) {
                out.printf("%-25.25s", AccurateMathCalc.format(d));
            }
            out.println("}, // " + i++);
        }
        out.println(TABLE_END_DECL);
    }

    static void printarray(PrintStream out, String name, int expectedLen, double[] array) {
        out.println(name + "=");
        AccurateMathCalc.checkLen(expectedLen, array.length);
        out.println(TABLE_START_DECL);
        for (double d : array) {
            out.printf("        %s%n", AccurateMathCalc.format(d));
        }
        out.println(TABLE_END_DECL);
    }

    static String format(double d) {
        if (Double.isNaN(d)) {
            return "Double.NaN,";
        }
        return (d >= 0.0 ? "+" : "") + Double.toString(d) + "d,";
    }

    private static void checkLen(int expectedLen, int actual) {
        if (expectedLen != actual) {
            throw new IllegalStateException(actual + " != " + expectedLen);
        }
    }
}

