/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.jetbrains.rdclient.daemon.highlighters.inlays.IgnoreMouseClickRendererCustomizer;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/InlayClickConsumerAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rd.client"})
public final class InlayClickConsumerAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(false);
        InputEvent inputEvent = e.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent == null) {
            return;
        }
        MouseEvent mouseEvent2 = mouseEvent;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Point editorPoint = SwingUtilities.convertPoint(mouseEvent2.getComponent(), mouseEvent2.getPoint(), editor3.getContentComponent());
        Inlay inlay = editor3.getInlayModel().getElementAt(editorPoint);
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        if (IgnoreMouseClickRendererCustomizer.Companion.shouldIgnoreMouseClick(editorCustomElementRenderer)) {
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }
}

