/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "reduceEffects", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "schema", "reduceEffect", "effect", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "esVariable", "visitConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "esConstant", "visitReceiver", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitLambda", "lambda", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "resolution"})
@SourceDebugExtension(value={"SMAP\nReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reducer.kt\norg/jetbrains/kotlin/contracts/model/visitors/Reducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1611#2,9:123\n1863#2:132\n1864#2:134\n1620#2:135\n1#3:133\n*S KotlinDebug\n*F\n+ 1 Reducer.kt\norg/jetbrains/kotlin/contracts/model/visitors/Reducer\n*L\n30#1:123,9\n30#1:132\n30#1:134\n30#1:135\n30#1:133\n*E\n"})
public final class Reducer
implements ESExpressionVisitor<ESExpression> {
    @NotNull
    private final KotlinBuiltIns builtIns;

    public Reducer(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        this.builtIns = builtIns;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ESEffect> reduceEffects(@NotNull List<? extends ESEffect> schema) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Iterable $this$mapNotNull$iv = schema;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ESEffect it = (ESEffect)element$iv$iv;
            boolean bl2 = false;
            if (this.reduceEffect(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ESEffect reduceEffect(ESEffect effect) {
        if (effect instanceof ConditionalEffect) {
            ESExpression eSExpression = (ESExpression)((ConditionalEffect)effect).getCondition().accept(this);
            if (eSExpression == null) {
                return null;
            }
            ESExpression reducedCondition = eSExpression;
            if (ValuesKt.isFalse(reducedCondition)) {
                return null;
            }
            if (ValuesKt.isTrue(reducedCondition)) {
                return ((ConditionalEffect)effect).getSimpleEffect();
            }
            return effect;
        }
        return effect;
    }

    @Override
    @NotNull
    public ESExpression visitIs(@NotNull ESIs isOperator) {
        Boolean result;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)isOperator, (String)"isOperator");
        Object t = isOperator.getLeft().accept(this);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        ESValue reducedArg = (ESValue)t;
        ESType eSType = reducedArg.getType();
        KotlinType argType = eSType != null ? eSType.toKotlinType(this.builtIns) : null;
        KotlinType isType = isOperator.getFunctor().getType().toKotlinType(this.builtIns);
        ESValue eSValue = reducedArg;
        if (eSValue instanceof ESConstant) {
            KotlinType kotlinType = argType;
            Intrinsics.checkNotNull((Object)kotlinType);
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, isType);
        } else if (eSValue instanceof ESVariable || eSValue instanceof ESReceiver) {
            KotlinType kotlinType = argType;
            bl = (kotlinType != null ? TypeUtilsKt.isSubtypeOf(kotlinType, isType) : false) ? Boolean.valueOf(true) : null;
        } else {
            throw new IllegalStateException("Unknown ESValue: " + reducedArg);
        }
        Boolean bl2 = result = bl;
        if (bl2 == null) {
            return new ESIs(reducedArg, isOperator.getFunctor());
        }
        bl2.booleanValue();
        return ESConstants.INSTANCE.booleanValue(result ^ isOperator.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter((Object)equal, (String)"equal");
        ESValue eSValue = (ESValue)equal.getLeft().accept(this);
        if (eSValue == null) {
            return null;
        }
        ESValue reducedLeft = eSValue;
        ESValue reducedRight = equal.getRight();
        if (reducedLeft instanceof ESConstant) {
            return ESConstants.INSTANCE.booleanValue(Intrinsics.areEqual((Object)reducedLeft, (Object)reducedRight) ^ equal.getFunctor().isNegated());
        }
        return new ESEqual(reducedLeft, reducedRight, equal.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkNotNullParameter((Object)and, (String)"and");
        ESExpression eSExpression = (ESExpression)and.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)and.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isFalse(reducedLeft) || ValuesKt.isFalse(reducedRight) ? reducedLeft : (ValuesKt.isTrue(reducedLeft) ? reducedRight : (ValuesKt.isTrue(reducedRight) ? reducedLeft : (ESExpression)new ESAnd(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitOr(@NotNull ESOr or) {
        Intrinsics.checkNotNullParameter((Object)or, (String)"or");
        ESExpression eSExpression = (ESExpression)or.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)or.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isTrue(reducedLeft) || ValuesKt.isTrue(reducedRight) ? reducedLeft : (ValuesKt.isFalse(reducedLeft) ? reducedRight : (ValuesKt.isFalse(reducedRight) ? reducedLeft : (ESExpression)new ESOr(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter((Object)not, (String)"not");
        ESExpression eSExpression = (ESExpression)not.getArg().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedArg = eSExpression;
        return ValuesKt.isTrue(reducedArg) ? (ESExpression)ESConstants.INSTANCE.getFalseValue() : (ValuesKt.isFalse(reducedArg) ? (ESExpression)ESConstants.INSTANCE.getTrueValue() : reducedArg);
    }

    @Override
    @NotNull
    public ESVariable visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter((Object)esVariable, (String)"esVariable");
        return esVariable;
    }

    @Override
    @NotNull
    public ESConstant visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter((Object)esConstant, (String)"esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter((Object)esReceiver, (String)"esReceiver");
        return esReceiver;
    }

    @Override
    @Nullable
    public ESExpression visitLambda(@NotNull ESValue lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return null;
    }
}

