/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R3\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorCallLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<set-?>", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructorFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getConstructorFactory", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "setConstructorFactory", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "constructorFactory$delegate", "Lorg/jetbrains/kotlin/backend/common/Mapping$DeclarationMapping;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class ES6ConstructorCallLowering
implements BodyLoweringPass {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Mapping.DeclarationMapping constructorFactory$delegate;

    public ES6ConstructorCallLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.constructorFactory$delegate = this.context.getMapping().getSecondaryConstructorToFactory();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction getConstructorFactory(IrConstructor $this$constructorFactory) {
        return (IrSimpleFunction)this.constructorFactory$delegate.getValue((IrDeclaration)$this$constructorFactory, $$delegatedProperties[0]);
    }

    private final void setConstructorFactory(IrConstructor $this$constructorFactory, IrSimpleFunction irSimpleFunction) {
        this.constructorFactory$delegate.setValue((IrDeclaration)$this$constructorFactory, $$delegatedProperties[0], (Object)irSimpleFunction);
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.context.getEs6mode()) {
            return;
        }
        IrFunction containerFunction = container instanceof IrFunction ? (IrFunction)container : null;
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)((IrElementTransformerVoid)new IrElementTransformerVoidWithContext(containerFunction, this){
            final /* synthetic */ IrFunction $containerFunction;
            final /* synthetic */ ES6ConstructorCallLowering this$0;
            {
                this.$containerFunction = $containerFunction;
                this.this$0 = $receiver;
            }

            public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                IrFunction currentFunction;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrConstructor currentConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)currentConstructor));
                ScopeWithIr scopeWithIr = this.getCurrentFunction();
                IrElement irElement = scopeWithIr != null ? scopeWithIr.getIrElement() : null;
                IrFunction irFunction = irElement instanceof IrFunction ? (IrFunction)irElement : null;
                if (irFunction == null) {
                    irFunction = currentFunction = this.$containerFunction;
                }
                if (Intrinsics.areEqual((Object)irClass.getSymbol(), (Object)this.this$0.getContext().getIrBuiltIns().getAnyClass()) || IrJsUtilsKt.hasStrictSignature(currentConstructor, this.this$0.getContext())) {
                    return super.visitConstructorCall(expression2);
                }
                IrSimpleFunction irSimpleFunction = ES6ConstructorCallLowering.access$getConstructorFactory(this.this$0, currentConstructor);
                if (irSimpleFunction == null) {
                    throw new IllegalStateException("Replacement for the constructor is not found".toString());
                }
                IrSimpleFunction factoryFunction = irSimpleFunction;
                if (ES6ConstructorLoweringKt.isInitCall((IrFunctionAccessExpression)expression2)) {
                    IrCall irCall;
                    boolean bl = ES6ConstructorLoweringKt.isInitFunction((IrDeclaration)factoryFunction);
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-ES6ConstructorCallLowering$lower$1$visitConstructorCall$22 = false;
                        String $i$a$-assert-ES6ConstructorCallLowering$lower$1$visitConstructorCall$22 = "Expect to have init function replacement";
                        throw new AssertionError((Object)$i$a$-assert-ES6ConstructorCallLowering$lower$1$visitConstructorCall$22);
                    }
                    IrCall $this$visitConstructorCall_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, factoryFunction.getSymbol(), null, null, null, null, 30, null);
                    boolean bl2 = false;
                    IrUtilsKt.copyValueArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)$this$visitConstructorCall_u24lambda_u241), (IrMemberAccessExpression)((IrMemberAccessExpression)expression2), (IrFunction)((IrFunction)factoryFunction), (boolean)false, (boolean)false, (int)12, null);
                    return (IrExpression)irCall;
                }
                boolean isDelegatingCall = ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2) && currentFunction != null;
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, factoryFunction.getSymbol(), null, null, (IrStatementOrigin)(isDelegatingCall ? ES6ConstructorLoweringKt.getES6_DELEGATING_CONSTRUCTOR_REPLACEMENT() : JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT()), null, 22, null);
                ES6ConstructorCallLowering eS6ConstructorCallLowering = this.this$0;
                IrCall $this$visitConstructorCall_u24lambda_u243 = irCall;
                boolean bl = false;
                IrUtilsKt.copyValueArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)$this$visitConstructorCall_u24lambda_u243), (IrMemberAccessExpression)((IrMemberAccessExpression)expression2), (IrFunction)((IrFunction)factoryFunction), (boolean)false, (boolean)false, (int)12, null);
                if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2)) {
                    IrFunction irFunction2 = currentFunction;
                    if (irFunction2 != null && (irFunction2 = ES6AddBoxParameterLoweringKt.getBoxParameter(irFunction2)) != null) {
                        IrFunction it = irFunction2;
                        boolean bl3 = false;
                        $this$visitConstructorCall_u24lambda_u243.putValueArgument($this$visitConstructorCall_u24lambda_u243.getValueArgumentsCount() - 1, (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)it.getSymbol(), null, 2, null));
                    }
                    if ($this$visitConstructorCall_u24lambda_u243.getSuperQualifierSymbol() == null) {
                        IrValueParameter irValueParameter = factoryFunction.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter);
                        $this$visitConstructorCall_u24lambda_u243.setDispatchReceiver((IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)irValueParameter.getSymbol(), null, 2, null));
                    }
                } else {
                    $this$visitConstructorCall_u24lambda_u243.setDispatchReceiver(IrJsUtilsKt.jsConstructorReference(irClass, eS6ConstructorCallLowering.getContext()));
                }
                IrCall factoryFunctionCall = irCall;
                return super.visitCall(factoryFunctionCall);
            }
        }));
    }

    public static final /* synthetic */ IrSimpleFunction access$getConstructorFactory(ES6ConstructorCallLowering $this, IrConstructor $receiver) {
        return $this.getConstructorFactory($receiver);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ES6ConstructorCallLowering.class), "constructorFactory", "getConstructorFactory(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

